+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-01-08T21:51:00+00:00"
lastmod = "2017-01-10T15:10:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056145982/2017-01-10---0565-RENEE-FLEMING-AS-THE-MARSCHALLIN-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg"
primary_image_credit = "Renée Fleming as the Marschallin in Der Rosenkavalier, Royal Opera House, 2016. Photo by Catherine Ashmore."
publishDate = "2017-01-10T14:09:00+00:00"
related_articles = ["articles/falstaff-he-saidshe-said.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/ariodante-or-the-hebridean-handel.md","articles/a-problematic-creaky-old-masterpiece-les-vpres-siciliennes.md","articles/facts-leaps-taking-unnecessary-offence.md","articles/fleming-enchants-luscious-morsels-of-postopera-career.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/renee-fleming.md","scene/people/alice-coote.md","scene/people/matthew-rose.md","scene/people/sophie-bevan.md"]
short_description = "It&#039;s as though Richard Strauss envisioned the skill of singers like Renée Fleming and Alice Coote when he wrote that first scene of Rosenkavalier. It&#039;s not something that can be properly anticipated, the thrill of watching two exceptional singers perform roles for which they are rightly known."
slug = "in-review-der-rosenkavalier-at-roh"
title = "In review: Der Rosenkavalier at ROH"
+++

Robert Carsen's new production of [*Der Rosenkavalier*](http://www.roh.org.uk/productions/der-rosenkavalier-by-robert-carsen) spills over with everything for which the star director is known. The sparse-yet-well-chosen points of focus across the stage fit beautifully with the broad and spacious architecture of Paul Steinberg's sets; Brigitte Reiffenstuel's costumes were ones to die for, classic silhouettes wrapped in richly textured fabric. It was a picture of an enviable, and very real life for the Marschallin in Vienna, 1911.

There were sets reminiscent both of Carsen's fantastic [*Falstaff*](/falstaff-he-saidshe-said/), and of the hallways in Buckingham Palace; the red-draped bed was enormous and sexy; there were puppies and cannons and lust-inducing fur stoles. Still, for all its juicy details, Carsen's *Rosenkavalier* succeeded because it simply set the story tumble forward, effortlessly.

To let the drama simply be seems another notable trait of a Carsen show; for a noble idea like that to truly work, a production necessarily becomes about the ensemble. Why have easily ambling drama without an excellent cast to amble with it?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056989015/2017-01-10---1671-ALICE-COOTE-AS-OCTAVIAN-RENEE-FLEMING-AS-THE-MARSCHALLIN-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Alice Coote as Octavian and Renée Fleming as the Marschallin in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

It's as though Richard Strauss envisioned the skill of singers like [Renée Fleming](/scene/people/renee-fleming/) and [Alice Coote](/talking-with-singers-alice-coote/) when he wrote that first scene of *Rosenkavalier*. It's not something that can be properly anticipated, the thrill of watching two exceptional singers perform roles for which they are rightly known.

Coote set a high bar with her rich, virile sound as Octavian; she seemed to be speaking, yet no note went by without a thought. Her youthful flailings were charming and strangely sexy, and she easily shifted in and out of the comedy of "Mariandel" and Octavian's generally tense relationship with Baron Ochs. For all the dramatic exaggeration inherent in the score, Coote remained a brilliant singing actor; even with the high bar she set in the first scene, she seemed to save her best singing for the finale.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056896350/2017-01-10---1352-ALICE-COOTE-AS-OCTAVIAN-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Alice Coote as Octavian in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

As she made her first entrance onstage, Fleming, in fit voice and singing with that perfect ease in Strauss' music, seemed a picture of old Hollywood. She commanded our ears immediately, yet fell into the Marschallin's lovely and nostalgic story without ego or hype; Fleming and the Marschallin seemed one person. Last year, she announced that her performances in Carsen's *Der Rosenkavalier* at Covent Garden and the Met would be her final "mainstream" opera performances; one would have to be deaf and blind to notice that this truth added new, raw meaning to the Marschallin's musings on age and the passing of time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056845645/2017-01-10---1885-RENEE-FLEMING-AS-THE-MARSCHALLIN-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Renée Fleming as the Marschallin in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

When we first meet the young Sophie, sung perfectly by [Sophie Bevan](/scene/people/sophie-bevan/), she is wide-eyed and practically carbonated with excitement over her upcoming arranged marriage to Baron Ochs. She is utterly lovable, her naïveté forgivable. Bevan too seemed to "speak" naturally through the score; yet when the time was right, she squeezed every drop of beauty from Strauss' lingering, floating lines. Fleming's Marschallin, with her relaxed sexuality and comforting wisdom, seemed a hard competitor for little Sophie; yet Bevan's performance kept us on her side. With such strength built among the triangle of Octavian, the Marschallin, and Sophie, the final trio seemed full of impossible decisions. (Of course, it also released some unexpected tears.)


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056920471/2017-01-10---1063-SOPHIE-BEVAN-AS-SOPHIE-VON-FANINAL-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Sophie Beva as Sophie von Faninal in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

As Baron Ochs auf Lerchenau, [Matthew Rose](/scene/people/matthew-rose/) blustered and babbled through huge mouthfuls of German with easy and personality. His imposing stature made him slightly dangerous, yet he had an air about him of a harmless blowhard, unaware that we can all see him feeding his own ego. Though helped by Rose's performance, it's oddly comforting to note that Strauss himself sees Ochs as on the wrong side of history, and that he is continuously compared to the grace and understanding of Octavian. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484056941101/2017-01-10---1278-MATTHEW-ROSE-AS-BARON-OCHS-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

The revolving door of comprimario/comprimaria roles all seemed plucked from a real 1911 Vienna; everybody had a clear motive, everyone a space on the spectrum of compassion and opportunism. One notable standout among the supporting cast was David Junghoon Kim, who stepped in for an ailing Giorgio Berrugi as the Italian Singer. We've been following Kim, a member of the ROH's Jette Parker Young Artists Programme, since our first visit to Covent Garden; though brief, Kim's Italian aria seemed a preview of his impending career as a leading tenor. He's certainly one to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484057039840/2017-01-10---2024-DER-ROSENKAVALIER-PRODUCTION-IMAGE-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>*Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

The final piece of the *Rosenkavalier* puzzle fell to maestro Andris Nelsons, who led the Orchestra of the Royal Opera House through a flexible, human score. The packed orchestra pit was always transparent, full of coversation instead of a wash of sound. Under Nelsons, the Orchestra mirrored the cyclical look of Carsen's production; over book-ended images of a luxurious red bed and two people in love/lust, Nelsons began and closed Strauss' score with a shimmering sound, full of anticipation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484057053849/2017-01-10---1565-RENEE-FLEMING-AS-THE-MARSCHALLIN-SOPHIE-BEVAN-AS-SOPHIE-VON-FANINAL-ROH-PHOTO-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Renée Fleming as the Marschallin and Sophie Bevan as Sophie von Faninal in *Der Rosenkavalier*, Royal Opera House, 2016. Photo by Catherine Ashmore.</figcaption>
</figure>

*Der Rosenkavalier* runs for four more performances until **January 24**; the final two dates feature [Rachel Willis Sørenson](http://www.roh.org.uk/people/rachel-willis-srensen) as the Marschallin, and [Anna Stéphany](http://www.roh.org.uk/people/anna-stephany) as Octavian. For details and tickets, [click here.](http://www.roh.org.uk/productions/der-rosenkavalier-by-robert-carsen)
