+++
author = ["authors/greg.md"]
categories = "Review"
date = "2015-10-30T10:31:00-04:00"
lastmod = "2015-10-30T11:17:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446215673333/2015-10-30---AbrahamSquare.jpg.jpg"
publishDate = "2015-10-30T12:17:00-04:00"
related_people = ["scene/people/richard-margison.md"]
short_description = "Wednesday, October 28, 2015 at the Metropolitan United Church on the corner of Queen Street East and Church Street in the heart of Downtown Toronto was the the premiere of a new Canadian work by composer David Warrack."
slug = "in-review-david-warracks-abraham"
title = "In review: David Warrack&#039;s Abraham"
+++

Wednesday, October 28, 2015 at the Metropolitan United Church on the corner of Queen Street East and Church Street in the heart of Downtown Toronto was the the premiere of a new Canadian work by composer [David Warrack](http://www.davidwarrack.ca/). 

Warrack, a good friend of mine who's works I've sung quite a bit in the last couple of years (including a workshop of this particular piece), has been putting together this [oratorio](https://en.wikipedia.org/wiki/Oratorio) on the life of Abraham, the "father" of Islam, Judaism and Christianity. Titled [*ABRAHAM*](http://www.abrahamoratorio.ca/), the piece tells his whole life story, from the moment he decides/is inspired to follow a singular god as opposed to the pagan gods of his parents. It follows him from the time he's thrown in a fire where he dances for 3 days and comes out unscathed right up until the death of his wife Sarah. We meet Hagar the surrgogate mother of Ishmael (who branches off to form Islam\*) and Sarah's late-in-life-conception miracle, Isaac (who branches off to form Judaism\*).

Warrack's background in Musical Theatre shines through the whole score. Whimsical at points, folk-rocky at others and sometimes straight up contemporary "classical". 

The show opened with a presentation by the [Jerrahi Sufi Choir](http://www.jerrahi.ca/index.html) with Whirling Dervishes. Traditional music from the cradle of civilization definitely set the stage. I felt just a little like I was watching the [prologue](https://www.youtube.com/watch?v=biVEtQQ_9mo) in "The Prince of Egypt" or something like that. It set the stage nicely. Their second appearance (right after intermission) seemed a bit out of place though. 

The singers, of which there were many, were a varied cast ranging from Canadian opera royalty to budding new musical theatre talent. 

In the title role we hear everything from 50's style crooning to the thrilling helden tenor we're used to from [Richard Margison](/scene/people/richard-margson/). It was nice to hear him living so much in the piano to mezzo-piano range. It really brought the the forefront his beauty of tone which often gets overshadowed by how thrilling the size and range of his instrument is. I found his most intimate moments to be the most thrilling musically. I felt as if there was, at points, some trepidation with the score, either through technical (not technique) issues or under rehearsing, but these were few and far between. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446216055087/4iJAxmseiK69CekZWQBkJ90LDos9DsVu_zr-SpqZ8u1QBJQJxroeXZR8khg0OCjjs8yYgckOGNDkzIl9RwXyZvr1GvaJ%3Dw680-h680-c)
</figcaption>Tenor Richard Margison.</figcaption>
</figure>

In the role of his wife, Sarah, [Theresa Tova](http://theresatova.com/), known for her Gemini award-nominated role of Marge on the CTV drama *ENG*, I found her to be a little - well maybe a lot - all over the map. The music was by no means an easy sing for anyone in the role, but the technique seemed suspect. There were a lot of lovely moments, and she's not a bad singer, I just feel like maybe some smarter choices in navigating the passagio would have strengthened her performance. I also could have done with a little more rhythmic clarity. Tova does have some great numbers and a wonderful bloom over the top of her register. 

[Ramona Carmelly](http://ramonacarmelly.blogspot.ca/) as the Spoken Voice and the Angel really surprised me. I'm already a fan of her full-throated Wagnerian mezzo, but I got to hear a different kind of singing from her. A more contemporary musical theatre sound with - wait for it - some DAMN FINE BELTING! Whoa! What the hell? Kudos, Ramona - I didn't realize you'd had that deep a background and it was nice to find out about it this way. 

[Meredith Hall](http://deanartists.com/artist/meredith-hall/) as the slave Hagar who surrogates for an aging Sarah to provide Abraham with his first son Ishmael, brought her lovely and bright soprano legato with her in full force. In her we saw a compassionate, supportive mother with a real visceral connection to her son and his place in history through her music. I would have liked to hear more of a number between her and Abraham, but at 35 numbers over 4 movements, the work itself is already quite large. 

Hussein Janmohammed and George Krissa played the two sons of Abraham Ishmael and Isaac (respectively). Janmohammed is definitely a full lyric tenor in waiting. Some passages seemed a little low for him in the second half but his charming face and fluid tone more than made up for that. Krissa as Isaac displayed a bright, full Musical Theatre tenor that traversed a remarkably challenging range. There were definitely high C's... maybe a D? These two young men have very bright futures ahead. They make great music and are quite pleasing on the eyes. 

Backed up by [Lydia Adams](http://www.elmeriselersingers.com/adams_l.htm) helming the ever-resplendent [Elmer Iseler Singers](http://www.elmeriselersingers.com/) alongside Lynda Beaupré's fantastic [Bach Children's Chorus](http://bachchildrenschorus.ca/), I found myself wanting more choral numbers in the whole piece. Their sounds (both separately and together) were clean, professional, nuanced and artistic. Having sung the piece, I know how much of a devil of a score it is, and they rose to the challenge and knocked it out of the park. 

I think the concept is great and hearkens back to [Bernstein's *MASS*](https://www.youtube.com/watch?v=9tjsKzhpSwE). There's some beautiful tunes, but the piece comes across more of a pageant than an oratorio. Warrack's lyrics could probably do with a little more poetry and the spoken passages could be reduced drastically and stick more to the plot line of the story, than pontificating the point/moral of the piece. I think the language in the ensembles in Movement Four takes care of that. I like the idea of a spoken narration or a "Celebrant" if you will, but I think the piece could benefit from a few cuts. 

The presentation seemed like it may have been put together in a bit of a hurry, and I was more than distracted by the large number of people videotaping portions of the piece (in particular the Whirling Dervishes.) I also found it odd (perhaps even rude) that the Jerrahi Sufi Choir and the Whirling Dervishes very conspicuously packed up and left when they finished their second offering after intermission. It distracted quite a bit from 2 very moving portions of the show where Sarah sings of her affection for her son, Isaac; and Abraham receives the directive from God to sacrifice Isaac. While I'm no stranger to performers leaving the hall before curtain, usually there's some sort of masked exit or a least a bit of an attempt at being inconspicuous. I feel like the Sufi Choir and Dervishes may have been a bit of a late add-on to tie in with the charitable aspect for Syrian Refugees. Their presence was culturally significant and interesting, but not really congruent with the piece. 

But leave the children's chorus as it is. I can totally imagine "A New Child" becoming a standard in the honour choir canon here in the Great White North alongside ["Siyahamba"](https://www.youtube.com/watch?v=_am5crjgCCE) and ["Les Chansons des Roses"](https://www.youtube.com/watch?v=gf2b4Jb-Tb8).

*ABRAHAM* - although I wouldn't call it a true oratorio like *Messiah*, or *Elijah* - it IS a great cross-section of music with a definite theatrical bent. It's also a remarkable story that deserves to be told. Keep an eye out for future productions. 

*I understand this is a gross reduction in the entire story of these two important religious groups. 
