+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-09-23T09:28:00+01:00"
lastmod = "2016-09-23T12:59:00+01:00"
preamble = "Feature image: Angela Brower (Dorabella), Daniel Behle (Ferrando), Alessio Arduini (Guglielmo), Corinne Winters (Fiordiligi), ROH. Photo: Stephen Cummiskey."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474619239896/2016-09-23---ANGELA-BROWER-AS-DORABELLA-DANIEL-BEHLE-AS-FERRANDO-ALESSIO-ARDUINI-AS-GUGLIELMO-CORINNE-WINTERS-AS-FIORDILIGI-ROH-PHOTO-STEPHEN-CUMMISKEY.jpg.jpg"
primary_image_credit = "Brower (Dorabella), Behle (Ferrando), Arduini (Guglielmo), Winters (Fiordiligi), © ROH. 2016. Photo: Stephen Cummiskey."
publishDate = "2016-09-23T12:55:00+01:00"
related_articles = ["articles/in-review-norma-at-roh.md", "articles/in-review-lucia-di-lammermoor-at-roh.md", "articles/in-review-tannhauser-at-roh.md", "articles/in-review-the-barber-of-seville-at-roh.md", "articles/in-review-boris-godunov.md", "articles/in-review-il-trittico-at-roh.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/corinne-winters.md", "scene/people/angela-brower.md", "scene/people/daniel-behle.md", "scene/people/sabina-puertolas.md"]
short_description = "It&#039;s not a bad solution to look to the show&#039;s theatrical context, itself a way of addressing the suspended disbelief. If the action takes place in a theatre, each scene can be something new, even heavy-handed in its symbolism. There are chorus members and stage crew to help create scenes that depict temptation, or a fab wedding banquet, or an entire train station."
slug = "in-review-cosi-fan-tutte-at-roh"
title = "In review: Così fan tutte at ROH"

+++
The catalyst for Jan Philipp Gloger's new staging of _Così fan tutte_ for the [Royal Opera House](/scene/companies/royal-opera-house/) was the question, "What would happen if this _Così fan tutte_ were to take place after a performance of _Così fan tutte_ - if the couples who are so sure of themselves and of their ideas of love were ctually in the audience and wanted to discuss what they've just seen?"

The German director's debut production at Covent Garden was a meta take on Mozart and Da Ponte's bizarre morality play on heterosexual relationships; the action straddled the worlds of the observer and of the performer, all appropriately directed - so to speak - by Don Alfonso.

Gloger uses the overture to stage the curtain calls from a more powedered-wig production of _Così_, which in this case, is the opera-within-the-opera. From there, we meet two couples (_the_ two couples) who have just seen the show, standing in the aisles with bright red ROH programme in hand. Ferrando and Gugliemo's heated banter with a singer in the show (Don Alfonso) begin a backstage experiment of sorts; the action unfurls in the theatre lobby, the lobby bar, and in the backstage guts of the Opera House.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474619388627/2016-09-23---PR8A7613_hi.jpg.jpg) {{% /md %}}<figcaption>Alessio Arduini as Guglielmo. _Così fan tutte_ © ROH. Photo by Stephen Cummiskey.</figcaption>
</figure>

Opening night of this _Così_ was certainly full of debuts, including the director, design team, and two-thirds of the cast. ROH first-timer [Daniel Behle](/scene/people/daniel-behle/) started off as a sweet-sounding Ferrando, with that heady ring of Mozart tenors and Peter Quint; by Act II, he was heroic and boiling with energy. His arias were flawless, including the tough sing in the second act. He was a great foil to [Alessio Arduini](http://barihunks.blogspot.co.uk/2016/09/alessio-arduini-returns-to-royal-opera.html)'s Guglielmo, whose round and virile sound had something predatory in it, in a great way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474626721067/2016-09-23---SC1_9359_hi.jpg.jpg) {{% /md %}}<figcaption>Daniel Behle as Ferrando and Corinne Winters as Fiordiligi, _Così fan tutte_ at the Royal Opera House. Photo by Stephem Cummiskey.</figcaption>
</figure>

Two more ROH debuts came from [Corinne Winters](/talking-with-singers-corinne-winters/) as Fiordiligi, and [Angela Brower](/scene/people/angela-brower/) as Dorabella. They were great actors, and they had a fantastic contrast of physicality that helped us understand the relationship between the two women. Brower sang with a bright, optimistic sound, and though her Dorabella was noticeably perkier than Fiordiligi, she was still feminine and sexy. Winters had a regal calmness about her, which suited the gorgeous, rich warmth in her sound. Her "Per pietà" was phenomenal, paced beautifully; she always found room for her best sound, and still she had lovely agility saved for the end.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474619396003/2016-09-23---PR8A7769_hi.jpg.jpg) {{% /md %}}<figcaption>Angela Brower as Dorabella, Corinne Winters as Fiordiligi. © ROH. Photo by Stephen Cummiskey.</figcaption> </figure>

The lovers trade stunning duets through the night; really, any combination of the four seemed an organic fit. Also well-matched were Johannes Martin Kränzle as Don Alfonso and [Sabina Puértolas](/scene/people/sabina-puertolas/) as Despina. Kränzle walked the narrow line between musing and meddling, and Puértolas brought out a fiesty strength in her sound to match this Despina.

Semyon Bychkov led the Orchestra of the Royal Opera House through a hefty playing of _Così_. The richness in sound suited the voices onstage, yet Bychkov's tempos seemed to drag indulgently. Numbers seemed to lose tension and diffuse, rather than achieve the larger arc of Mozart's. Winters negotiated extraordinarily long lines in a slower-than-necessary quintet, and Puértolas had fun with an Act II aria that seemed exhaustive rather than dance-like.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474626511192/2016-09-23---PR8A6578_hi.jpg.jpg) {{% /md %}}<figcaption>Sabina Puértolas as Despina, _Così fan tutte_ © ROH. Photo by Stephen Cummiskey</figcaption>
</figure>

_Così fan tutte_, like _Don Giovanni_, seems to be almost impossible to direct. The opera earns endless debate about the seriousness of the piece, how much sexism exists within it, and just how silly the men-in-disguise bit is supposed to be. It's not a bad solution to look to the show's theatrical context, itself a way of addressing the suspended disbelief. If the action takes place in a theatre, each scene can be something new, even heavy-handed in its symbolism. There are chorus members and stage crew to help create scenes that depict temptation, or a fab wedding banquet, or an entire train station.

Yet there's enough specificity in Da Ponte's libretto to raise more questions than Gloger solves. Perhaps it's picky to point out small holes, like the lack of chocolate, doors to knock upon, and 15-year old girls. Or why, if they have phones to take selfies with, don't the girls use them to call an ambulance when the men are poisoned?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474619363767/2016-09-23---PR8A7061_hi.jpg.jpg) {{% /md %}}<figcaption>Così fan tutte at the Royal Opera House, production image, © ROH. Photo by Stephen Cummiskey.</figcaption> </figure>

There are still larger issues that come out of a stubborn-seeming approach to a concept. If the lovers have just met Alfonso and Despina, why do they interact with them at such high personal stakes? Why do the women demand that the men leave in the Act I finale, when the action is in a bar, instead of their home? Fiordiligi's "Come scoglio" doesn't hold the same power when she and Dorabella could just as easily leave the bar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474626523776/2016-09-23---PR8A6791_hi.jpg.jpg) {{% /md %}}<figcaption>Johannes Martin Kränzle as Don Alfonso, Corinne Winters as Fiordiligi, Alessio Arduini as Guglielmo. _Così fan tutte_ © ROH. Photo by Stephen Cummiskey</figcaption>
</figure>

"We decided to explain that the women know from the beginning of the second act that the 'foreign men' are really their own boyfriends," says Gloger in an interview with Katharina John. It's always odd to hear this choice from a director of _Così_. It doesn't seem to answer any of the questions inherent in the score, or newly presented in this production, and it simply adds to the persuasive question of "But _why?_" that looms overhead.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474626467383/2016-0-23---SC1_9425_hi.jpg.jpg) {{% /md %}}<figcaption>© ROH. Photo by Stephen Cummiskey</figcaption> </figure>

The shows highlights clearly come from Daniel Behle, Angela Brower, Alessio Arduini, and Corinne Winters. Their singing is top-notch, full of style and individuality, and they're all real people. [_Così fan tutte_](http://www.roh.org.uk/productions/cosi-fan-tutte-by-jan-philipp-gloger) runs at the Royal Opera House until October 19, and you'll want to hear this cast. [Click here](http://www.roh.org.uk/productions/cosi-fan-tutte-by-jan-philipp-gloger) for details and tickets.