+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-29T12:10:00+01:00"
lastmod = "2016-04-29T14:03:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461932677954/2016-04-29---Cadogan-Hall.jpg.jpg"
primary_image_credit = "Cadogan Hall."
publishDate = "2016-04-29T13:55:00+01:00"
related_articles = ["articles/in-review-rowan-pierce-the-london-handel-players.md","articles/a-warm-introduction-the-mozartists-at-wigmore-hall.md","articles/a-very-happy-20th-birthday-for-classical-opera.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/ian-page.md","scene/people/rachel-kelly.md","scene/people/angela-simkin.md"]
short_description = "Perhaps it&#039;s true that Jommelli will not be remembered as one of the great composers of his time, but Il Vologeso is a great opera. It&#039;s full of love and lust, neglected and abused women, political differences, pride, and just endings. Under Ian Page, the Orchestra of Classical Opera started with a burst of energy that stayed present throughout the night; no two phrases were alike, and the orchestra were main players in the drama alongside the singers."
slug = "in-review-classical-operas-il-vologeso"
title = "In review: Classical Opera&#039;s Il Vologeso"
+++

When we spoke with [Ian Page](/ian-page-mozart-imagination/), conductor and Artistic Director of [Classical Opera](/scene/companies/classical-opera/), he was passionate about the musical fun, play, and imagination that can come out of paying attention to detail. Period instruments and tuning, and extensive study of old scores can often result in not much more than tomes of trivia and perhaps a satisfying amount of historical accuracy. Instead, Page and the Classical Opera ensemble take what's native and contemporary about their 18th-century repertoire, and hand it fully and proudly back to the audience. In other words, they prove that respect for the old can illuminate why this music is inspiring, both for Mozart and for 21st-century audiences.

Niccolò Jommelli's *Il Vologeso* is part of the second year of [MOZART 250](http://www.classicalopera.co.uk/mozart-250/), Classical Opera's large-scale project of performing the works of Mozart and his contemporaries, 250 years after their premieres. Jommelli wrote a huge number of operas, and 1766 *Il Vologeso* was one of his most popular. Page writes in his programme notes, "Jommelli does not belong among the truly great composers, to be sure, but a performance of one of his most successful operas offers a fascinating opportunity to reassess a forgotten name of musical history, and even if the differences outweigh the similarities, it provides us with a richer appreciation of the musical scene onto which the young Mozart was soon to explode."

Perhaps it's true that Jommelli will not be remembered as one of the great composers of his time, but *Il Vologeso* is a great opera. It's full of love and lust, neglected and abused women, political differences, pride, and just endings. Under Ian Page, the Orchestra of Classical Opera started with a burst of energy that stayed present throughout the night; no two phrases were alike, and the orchestra were main players in the drama alongside the singers. 

Page made a few judicious edits to Jommelli's score, in the name of cohesion and perhaps to better suit this in-concert performance. The strong cast of six singers carried the story with expertise. In the title role was mezzo-soprano [Rachel Kelly](/scene/people/rachel-kelly/), who brought fierce strength and masculinity to Vologeso, King of Parthia. She was masculine without trying too hard, and the commanding point to her sound was thrilling from bottom to top. Matching that command was soprano [Gemma Summerfield](/scene/people/gemma-summerfield/) as Berenice, Queen of Armenia and Vologeso's fiancée. Her arias demanded plenty of technique as a singer and actor, and she had a warmth that seemed to turn on a dime when Berenice needed to dig in her heels against the manipulative Emperor Lucio Vero. Her final mad-scene-like aria reminded us a bit of Elettra in Mozart's *Idomeneo*, and Dejaneira's final scene in Handel's *Hercules*. Summerfield's performance was one of those moments where a character seems to warrant a change in an opera's title; *Il Vologeso* could easily be called instead, *La Berenice*.

As Lucio Vero, tenor [Stuart Jackson](/scene/people/stuart-jackson/) sang with menacing fire in his sound, balanced by moments of beauty and agility, like in his cavatina, "Che faro?" Jackson delivered a wicked rage aria, and some blinding coloratura that made us think of Mozart's Belmonte (*Die Entführung aus dem Serail*) and even Rossini's Count Almaviva (*Il barbiere di Siviglia*); at the same time, he sang with a good amount of heft, reminiscent of Tito and Don Ottavio. Mezzo-soprano [Angela Simkin](/scene/people/angela-simkin/) was tragic as Lucilla, Vero's fiancée who gets discarded by the Emperor in favour of the more appealing Berenice. Simkin had a rich sound that suited the pitiable woman, and she was a beautiful foil in sound and spirit to the true object of Vero's desire.

As Flavio, a Roman ambassador and supporter of Lucilla's, soprano [Jennifer France](/scene/people/jennifer-france/) was a ball of energy. She had fiercely difficult coloratura to sing, and she mixed the descriptive music with proud fire that spoke to Flavio's loyalty. Countertenor [Tom Verney](/scene/people/tom-verney/) was a strong Aniceto, Vero's attendant, and he impressed with what seemed like difficult, low writing in his aria.

It was our first hearing of Classical Opera's work, and they were a total breath of fresh air. There was no ego in their mission, and the artists performed with respect for each other and for the audience's experience. You can hear them next at Wigmore Hall, featuring mezzo-soprano [Ann Hallenberg on **May 23, 7:30pm**](http://www.classicalopera.co.uk/performances/ann-hallenberg-at-wigmore-hall/), and CO presents Mozart's [*Don Giovanni*](http://www.classicalopera.co.uk/performances/don-giovanni/?content=intro) at Cadogan Hall on **June 17, 7:30pm**.

