+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-05-05T17:16:00+01:00"
lastmod = "2016-05-05T18:08:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462465222662/2016-05-06---Rachvelishvili-as-Carmen-Thomas-as-Jose-Photo-by-Michael-Cooper.jpg.jpg"
primary_image_credit = "Russell Thomas as Don José, Anita Rachvelishvili as Carmen in the COC production of Carmen, 2016, photo: Michael Cooper."
publishDate = "2016-05-05T18:08:00+01:00"
related_articles = ["articles/in-review-maometto-ii.md","articles/in-review-the-rape-of-lucretia.md","articles/nashville-operas-carmen-she-dies-because-she-told-a-man-no.md","articles/in-review-carmen-at-nashville-opera.md","articles/la-opera-scores-in-first-half-of-bizet-doubleheader.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-childrens-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/anita-rachvelishvili.md","scene/people/sasha-djihanian.md","scene/people/charlotte-burrage.md","scene/people/peter-barrett.md","scene/people/alain-coulombe.md","scene/people/iain-macneil.md","scene/people/jeanphilippe-fortierlazure.md","scene/people/simone-osborne.md","scene/people/joel-ivany.md","scene/people/russell-thomas.md"]
short_description = "Ivany&#039;s setting of the story lends itself well to the given circumstances already laid out in the play and the score. I particularly liked several of the choices Ivany has made. I felt like he directed José to be less of a jilted lover, and more a young man who completely misreads the intentions of a worldly young woman. This man&#039;s inability to deal with the idea that Carmen&#039;s feelings have changed lead to disastrous consequences."
slug = "in-review-carmen-at-the-coc"
title = "In review: Carmen at the COC"
+++

Back for a double header at the Four Seasons Centre for the Performing Arts, Wednesday night the seating gods smiled upon us - yet again. From our super sweet seats I was about to witness (finally) the Canadian Opera Company's thrilling production of Bizet's perennial crowd pleaser, *Carmen*.

We all know the story, a woman, feckless in her amourous endeavours meets an untimely end at the hands of a young soldier who doesn't comprehend that "no" means no. 

This time we see a production staged by Toronto indie opera darling, and director-du-jour, Joel Ivany, and once again he does not let us down. This is a production that not only celebrates the beautiful work of Bizet and the glorious work of the musicans, but also lauds the magic that is true theatre. Ivany's setting of the story lends itself well to the given circumstances already laid out in the play and the score. I particularly liked several of the choices Ivany has made. I felt like he directed José to be less of a jilted lover, and more a young man who completely misreads the intentions of a worldly young woman. This man's inability to deal with the idea that Carmen's feelings have changed lead to disastrous consequences. I feel like this is a more realistic and tangible way to approach the relationship between the two lovers and is more believable when we see his misguided affections driving him to inhuman acts.

Also Act IV. Best. Treatment. Ever. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462465319307/2016-05-06---Rachvelishvili-as-Carmen-Coulombe-as-Zuniga-Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>Anita Rachvelishvili as Carmen (centre) as Alain Coulombe as Zuniga looks on (at left) in the Canadian Opera Company production of *Carmen*, 2016, photo: Michael Cooper.
</figcaption>
</figure>

Georgian mezzo soprano [Anita Rachvelishvili](/scene/people/anita-rachvelishvili/) was born to play this role. I found her subtle choices in character supported her astounding vocals perfectly. Watching her dance her way through this character's dramatic arc is a delight. There is a moment in the Act IV duet where you see her realize she's in danger, and the effect is palpable. Her rich, velvety tone was everything you could want from this sultry cigarette girl. In the blink of an eye she could deliver a chest voice worthy of winning a Tony award to a brilliant top that shone through the house; she mastered the unforgiving range covered by Carmen flawlessly. 

What a current run it is for the women performing at the Canadian Opera Company right now. 

Tenor [Russell Thomas](/scene/people/russell-thomas/) was the perfect vocal fit for Bizet's Don José.  Acting-wise, I did feel him a little stiff next to Rachvelishvili's Carmen, but to be fair, that's a tough game to match. Vocally superb, his "La fleur" was the best I've ever heard in real life. He did relax more into Don José and showed us more of his insecurity through his relationship with his mother which is brought to the fore any time Micaëla shows up. This momma's-boy complex distorting his view on how he sees and treats women - an unfortunate, yet totally relevant topic in today's discourse. The whole time this very subtle and nuanced performance we were enveloped by this thick, strong lyric tenor sound. It may at times have hindered his connections dramatically onstage, but his Act IV performance more than makes up for it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462465334986/2016-05-06---Osborne-as-Micaela-Thomas-as-Jose---Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>Simone Osborne as Micaëla and Russell Thomas as Don José in the Canadian Opera Company production of *Carmen*, 2016, photo: Michael Cooper.</figcaption>
</figure>

COC darling and favourite [Simone Osborne](/talking-with-singers-simone-osborne/) sang the role of Micaëla beautifully. Her bright tone, and sparkle was delicious on this role. Her skills at playing the ingenue seriously get better in every production I see her in. I find that Bizet's orchestrations may have been a little too unforgiving for her delicacy and found myself losing her a bit in the mid-voice of her range. That orchestra is massive and the scoring is lush and perhaps could have used a little more sensitivity from the pit in marrying with her voice. It may also just have been my placement in the house. Her "Je dis" was breathtaking. Alone onstage, in a ruined temple, under a blanket of stars she brought Micaëla's longing to life. I'd love to hear her sing this in a more intimate space with just a piano. I imagine it would be thrilling.

[Christian van Horn](/talking-with-singers-christian-van-horn/)'s Escamillo is every bit the strut-and-puff toreador we want him to be. Tall and lean and dreamy, he snakes through the chorus during his fabulous delivery of the couplets "Votre toast". His sound was rich and smooth and didn't lose focus as he went up over the top of his range - which is a pitfall for a lot of bass-baritones. This Escamillo drives the women wild - and some of the men - but I found him to be a little staid. I felt a little more freedom of movement in his physicality would add even another level of charisma, there was a hint of stand and deliver there, which is fine for a lot of roles, but I don't think it's a strong choice for Escamillo; it showed during the knife fight with Thomas's José. The singing of that duet, however, was one of the highlights of my night. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462465346275/2016-05-06---Van-Horn-as-Escamillo-Burrage-as-Mercedes-Djihanian-as-Frasquita---photo-by-Michael-Cooper.jpg.jpg)
<figcaption>Christian Van Horn as Escamillo (centre) and Sasha Djihanian as Frasquita (right, at table) in the Canadian Opera Company production of *Carmen*, 2016, photo: Michael Cooper.</figcaption>
</figure>

Supporting Rachvelishvili in her domination of men were the lovely [Sasha Djihanian](/scene/people/sasha-djihanian/) as Frasquita and [Charlotte Burrage](/scene/people/charlotte-burrage/) as Mercédès. The two sounded lovely together and Djihanian shone in the Act II quintet - probably one of my favourite movements in all of opera. I found Burrage lacked a worldliness to her that Frasquita and Carmen had in spades, I feel this held her back a bit for most of the show, but in the trio where the two warn Carmen of José's approach in Act IV, her reserve actually worked really well to dramatically inform her warning of Carmen. 

For a show about a woman, this cast sure has a lot of dudes. As Moralès [Peter Barrett](/scene/people/peter-barrett/) was excellent. His voice the perfect colour to blend with the male chorus and to stand out in front of it. His ability to alternate between the two was fantastic. As the older Zuniga, bass [Alain Coulombe](/scene/people/alain-coulombe/) was delightful. Smarmy and dangerous, he's all we could ask for and more. The "gypsy" smugglers Dancaïre and Remendado were ably played by [Iain MacNeil](/scene/people/iain-macneil/) and [Jean-Philippe Fortier-Lazure](/scene/people/jean-philippe-fortier-lazure/) respectively (both of the Canadian Opera Company Ensemble Studio). The two had great chemistry together and along with Rachvelishvili comfortably married the danger of their profession with the fun of their spirits. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462465358433/2016-05-06---Burrage-as-Mercedes-MacNeil-as-Dancaire-Rachvelishvili-as-Carmen-Fortier-Lazure-as-Remendado-Djihanian-as-Frasquita---Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>(l-r): Charlotte Burrage (Mercédès), Iain MacNeil (Dancaïre), Anita Rachvelishvili (Carmen), Jean-Philippe Fortier-Lazure (Remendado), Sasha Dhijanian (Frasquita) in the Canadian Opera Company production of *Carmen*, 2016, photo: Michael Cooper.</figcaption>
</figure>

The [Canadian Children's Opera Company](/scene/companies/canadian-childrens-opera-company/) definitely stole our hearts from the second they trotted on the stage. Well-done. That was some super-skilled, clean, and accurate singing all done with the kind of energetic staging that only a children's company can produce. 

Under the baton of Paolo Carignani, the COC Orchestra and Chorus brought Bizet's amazing score to life. From the downbeat of the overture to José's last "Carmen" at the final curtain, I loved his tempi and the articulation was decidedly French. Bravi!

Interestingly enough, *Carmen* premiered in Toronto only 4 years after it premiered in France according to the COC Program - which is something pretty cool. It actually pre-dates Canada's first professional hockey team by 27 years. So, do yourself a favour and [grab a ticket](http://www.coc.ca/PerformancesAndTickets/1516Season/Carmen.aspx) and witness a live and in real-time tribute to Canadian history. The show runs [through to May 15, 2016](http://www.coc.ca/PerformancesAndTickets/1516Season/Carmen.aspx) and really shouldn't be missed. 

A great way to cap off a great season at the Canadian Opera Company. 
