+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-19T10:32:00+00:00"
lastmod = "2016-03-19T15:05:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398140443/Square---BRYN-TERFEL-AS-BORIS-GODUNOV-ROH-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg"
primary_image_credit = "Bryn Terfel as Boris Godunov. Copyright: ROH. Photo by Catherine Ashmore."
publishDate = "2016-03-19T14:50:00+00:00"
related_articles = ["articles/in-review-il-trittico-at-roh.md","articles/in-review-jenufa-czech-philharmonic.md","articles/in-review-tannhauser-at-roh.md","articles/in-review-cosi-fan-tutte-at-roh.md","articles/hibla-gerzmava-danielle-akta-with-the-moscow-virtuosi.md","articles/overdue-for-a-chicago-performance-the-haunted-manor.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/bryn-terfel.md","scene/people/ain-anger.md","scene/people/david-butt-philip.md"]
short_description = "Richard Jones makes much of this incessant guilt, exaggerating the unjustness of Boris&#039; actions with childish images of colourful spinning tops and a cherub-like mask on the silent Dmitry. Jones carries the image through the final tableau, driving home the sacrifices of the young and innocent, when men seek political power."
slug = "in-review-boris-godunov"
title = "In review: Boris Godunov"
+++

Last night's *Boris Godunov* at the [Royal Opera House](/scene/companies/royal-opera-house/) was an exciting time. [Bryn Terfel](/scene/people/bryn-terfel.) had his second performance in the title role, a new one for him, and Music Director Anthony Pappano took the podium to conduct this new production by Richard Jones. The ROH presents, for the first time, the rarely heard [1869 version](https://en.wikipedia.org/wiki/Boris_Godunov_(opera)#Versions) of Musorgsky's score, slimmer in scenes and truer to Pushkin's drama. There was no interval for the production, and the story unfolded uncomfortably and relentlessly as a result, putting the audience in shoes similar to those of Tsar Boris himself.

Boris gains his place as Tsar of Russian, after murdering Dmitry, the young, true successor; not lacking a conscience, Boris rules fairly and benevolently, still tormented by the memory of the slain boy. Richard Jones makes much of this incessant guilt, exaggerating the unjustness of Boris' actions with childish images of colourful spinning tops and a silent secene, repeated *ad nauseam*, depicting the regicide-plus-paedocide. Jones carries the image through the final tableau, driving home the sacrifices made by  the young and innocent when men seek political power.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398362556/BORIS-GODUNOV-PRODUCTION-IMAGE-ROH.-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>A scene from *Boris Godunov*. Copyright: ROH. Photograph by Catherine Ashmore.</figcaption>
</figure>

Pappano pulled enormous, rich sound from the orchestra, chorus, and soloists; Musorgsky's score is daunting, reminding us of huge buildings and loud bells and large systems of political power. Miriam Buether's sets mirrored the wide scope of the music, creating spaces that loomed large, often filled with Kremlin-reminiscent colour through Nicky Gillibrand's stunning costumes. It all looked quite Russian, in perhaps a stereotypical way; yet there was truth to this *Boris Godunov*, helped by a strong cast of singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398645820/BRYN-TERFEL-AS-BORIS-GODUNOV-BEN-KNIGHT-AS-FYODOR-ROH-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Bryn Terfel as Boris Godunov, Ben Knight as Fyodor. Copyright: ROH. Photograph by Catherine Ashmore.</figcaption>
</figure>

In the title role, Bryn Terfel was intimidating in size and unpredictable in voice. He had a voice for the first declamatory scene, addressing his people; as the story unfolded, this calculated, formal, slightly dishonest sound morphed into a father talking to his children, and into a paranoid man, terrified of uncovered secrets. There were moments of pressed singing, making his intonation creep sharp, yet in the context of the full show, Terfel's Boris was a complete man. We heard him "at work", and we heard him "at home", and despite knowing that Boris created his own problems for himself, we found ourselves on his side by the end.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398500465/AIN-ANGER-AS-PIMEN-DAVID-BUTT-PHILIP-AS-GRIGORY-OTREPIEV-THE-FALSE-DMITRY-ROH-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Ain Anger as Pimen, David Butt Phlip as Grigory Otrepiev ("the False Dmitry"). Copyright: ROH. Photograph by Catherine Ashmore.</figcaption>
</figure>

The supporting cast was full of vocal gems. Lithuanian bass-baritone Kostas Smoriginas had a stunning sound as Andrey Shchelkalov, providing what felt like a benevolent foil to the unpredictable Boris. Making his ROH debut as the monk Pimen, it was a thrilling experience to hear Estonian bass [Ain Anger](/scene/people/ain-anger/) and his a booming, beautiful ring. Tenor David Butt Philip was heroic and virile as Grigory Otrepiev, "the false Dmitry"; he had a sound that seemed perfect for this repertoire, even with all the Rodolfos under his belt. John Tomlinson and Harry Nicoll graced us with some comic relief as the wine-friendly monks, Varlaam and Missail; they seemed like a great pair of drinking buddies, despite the seriousness going on around them.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398584567/JOHN-TOMLINSON-AS-VARLAAM--HARRY-NICOLL-AS-MISSAIL-ROH-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>John Tomlinson as Varlaam, Harry Nicoll as Missail. Copyright: ROH. Photograph by Catherine Ashmore.</figcaption>
</figure>

Rebecca de Pont Davies was a breath of fresh air as the Hostess of the Inn, one of the few unashamedly human characters in this stark opera. Jette Parker Youth Artist Vlada Borovko was heartbreakingly beautiful as Xenia, Boris' daughter. She sang with a clear, powerful sound that fit this masculine opera. As Prince Shuisky, perhaps the closest thing Boris has to a friend, tenor John Graham-Hall was honest, almost apologetic. Finally, Ben Knight was a touching Fyodor, Boris' son; the final image of Jones' production showed the newly crowned Tsar Fyodor, pursued by Grigory, making good on his promise to bring justice to the tainted throne. Fyodor, with fellow would-be young Tsar, Dmitry, are the two named innocents dragged into the mess of men, and Richard Jones didn't let us forget it.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458398557335/JOHN-GRAHAM-HALL-AS-PRINCE-VASILY-IVANOVICH-SHUISKY-BRYN-TERFEL-AS-BORIS-GODUNOV-ROH-PHOTOGRAPH-BY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>John Graham Hall as Prince Vasily Ivanovich Shuisky, Bryn Terfel as Boris Godunov. Copyright: ROH. Photograph by Catherine Ashmore.</figcaption>
</figure>

"Daunting" and "overpowering" were two words that consistently came to mind watching this *Boris Godunov*. It's an arresting production filled with strong singing and a fiery orchestra under Pappano's baton. 

The March 21 performance will be [broadcast live to worldwide cinemas](http://www.roh.org.uk/showings/boris-godunov-live-2016), and it's not one to miss. For details and ticket information for the remaning shows (running until April 5), follow our box office links below.
