+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-05-06T17:07:00-04:00"
lastmod = "2015-06-03T16:57:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430946263145/Erwartung-MC-0760Square.jpg.jpg"
primary_image_credit = "Krisztina Szabó as The Woman in Erwartung, 2015. Photo by Michael Cooper."
publishDate = "2015-05-09T09:29:00-04:00"
related_articles = ["articles/coc1617.md","articles/dean-burry-on-the-highwayman.md","articles/killer-women-shadwell-operas-doublebill.md","articles/in-review-scenes-from-the-end.md","articles/a-lopsided-bloody-doublebill-at-hackney-empire.md","articles/folk-songs-esprit-szabo.md","articles/belle-bete-la-opera-beauty.md","articles/overdue-for-a-chicago-performance-the-haunted-manor.md","articles/an-astonishing-bryan-hymel-in-the-royal-operas-double-bill.md","articles/metrowest-double-bill-provides-thrills-delights-despite-mismatch.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/krisztina-szab.md","scene/people/johannes-debus.md","scene/people/john-relyea.md","scene/people/ekaterina-gubanova.md","scene/people/robert-lepage.md"]
short_description = "Last night I was able to check off one of my must-sees. For a while I felt like the only opera fan in Toronto who hadn&#039;t seen Robert Lepage&#039;s double bill of Bluebeard&#039;s Castle/Erwartung, but I fixed that. The production couldn&#039;t have brought more hype along with it, and I usually try and ignore hype so that it doesn&#039;t skew my otherwise fine enjoyment of a production. The rumours turned out to be true, and I was amazed."
slug = "in-review-bluebeards-castle-erwartung"
title = "In review: Bluebeard&#039;s Castle/ Erwartung"
+++

Last night I was able to check off one of my must-sees. For a while I felt like the only opera fan in Toronto who hadn't seen Robert Lepage's double bill of *Bluebeard's Castle/Erwartung*, but I fixed that. The production couldn't have brought more hype along with it, and I usually try and ignore hype so that it doesn't skew my otherwise fine enjoyment of a production. The rumours turned out to be true, and I was amazed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1431189694639/Blubeard-MC-0102.jpg.jpg)
<figcaption>John Relyea and Ekaterina Gubanova in Bluebeard's Castle. Photo: Michael Cooper</figcaption>
</figure>

I'm not even sure what to say about *Bluebeard's Castle*, other than I couldn't tear my eyes away. Michael Levine's set is a claustrophobic box of blackness, and Robert Thomson's ingenious lighting design helps us to see just enough of Bluebeard's dark world. I couldn't get over how uncluttered, yet how perfectly clear the design really was. The shadows from the castle's cate, the keyhole-shaped pools of light indicating the seven terrifying doors, it was specific enough to tell a clear story, and unspecific enough to change and morph as the story unravels.

Those seven doors, too. It seems so simple to indicate with lighting the magnitude of Bluebeard's locked secrets; it may have been simple, but it was an arresting picture every time: red (torture chamber), gold (jewels), gleaming white (weapons), water ripples (lake of tears), and what seemed like the entire planet (Bluebeard's empire). 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1431189716405/Blubeard-MC-0573.jpg.jpg)
<figcaption>John Relyea and Ekaterina Gubanova in Blubeard's Castle. Photo: Michael Cooper.</figcaption>
</figure>

John Relyea and Ekaterina Gubanova were totally stunning as Bluebeard and his new wife, Judith. The two sounded spectacular, making real art out of what is no doubt a tricky score. I found myself watching Relyea lurk around in the background, aided by a small travelling spotlight that followed Bluebeard throughout the show. I loved how in the blackness of the set, the pools of light distort one's perspective; one of the eeriest moments was when Judith was downstage, Bluebeard behind her, but I couldn't tell the distance between them.

Speaking of eerie (spoiler: fair warning), when those dead wives came out of the stage in bloodsoaked dresses (and I mean soaked), that was the first time I've been genuinely scared by live theatre. It was terrifying, and I again couldn't take my eyes off of any of it.

*Bluebeard* had me asking questions in the intermission. I was drawn to Judith's repeated response when Bluebeard asks her why she needs to keep opening the doors: "Because I love you," she says to him. It was a fascinating look at how a private man deals with external, almost unrelated pressure to open up his life to others. Bluebeard has an incredible journey from reluctance, to defiance, to resignation; the opening of each of the doors is punctuated with a question to Judith, "are you afraid?" I was.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1431189727392/Erwartung-MC-0826.jpg.jpg)
<figcaption>Krisztina Szabó as The Woman in Erwartung. Photo: Michael Cooper</figcaption>
</figure>

Then came *Erwartung*, and I got the heebie-jeebies almost immediately. Krisztina Szabó embodied The Woman, who relives a nightmarish scene of searching for the lover she lost (killed). In *Erwartung* there's insanity, a constant, nagging feeling that something is seriously wrong. I loved how Thomson and Levine traded *Bluebeard*'s darkness and claustrophobia for open space and oppressive white light; the space and light were no relief from *Bluebeard*, just unnerving in a new way. 

Perspective was off in *Erwartung*, what you thought was up is actually down. Schoenberg's constantly changing score and The Woman's insanity are great reasons to mess with an audience's point of reference; another great reason is that it is *terrifying*. The Woman's shrink, her past lover, the tree branch that she mistook for his body, they all slide sideways into our view via the big brick wall that doubles as a floor. It was like a David Lynch film, or like those staircases leading every which way. Mostly it was freaky, and it left us wondering how they pulled off some of those illusions. 

*Erwartung* is disjointed, yet has a clear narrative; the one true constant is The Woman. Krisztina Szabó stunned me again with this performance. In an interview she told me that *Erwartung* was by far the most difficult thing she's had to learn; she really did embody this role, though. There were no moments of "just singing," everything meant something specific, every word was newly coloured. So incredible.

The COC Orchestra under Music Director Johannes Debus played spectacularly. For the players, these two operas are worlds apart; yet the orchestra too joined the organic melding of elements in this production. 

When I interviewed revival director François Racine, I asked him why this double-bill has seen such success over its 20 years. He replied simply, "Because it's brilliant." That's all there really is to it. Lepage and his team brought us two entirely integrated works of art, where no piece of the puzzle can be removed without the whole thing falling apart. I *love* stuff like that, especially when every singular element is so brilliantly presented. 

What a night. Go see *Bluebeard's Castle/Erwartung*, don't ask questions. Follow the box office links below for more details and to purchase tickets.

