+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-11-15T12:46:00+00:00"
lastmod = "2016-11-15T14:16:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479214379013/2016-11-15---Ayre-Square-Block.jpg.jpg"
primary_image_credit = "Photo by Darryl Block."
publishDate = "2016-11-15T13:11:00+00:00"
related_articles = ["articles/in-review-obeah-opera.md","articles/in-review-pellas-et-mlisande.md","articles/atgs-opera-pubs-it-can-all-get-a-bit-wild.md","articles/ayre-live-launches-atgs-new-record-label.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/miriam-khalil.md","scene/people/adanya-dunn.md","scene/people/ellen-mcateer.md"]
short_description = "This wasn&#039;t just &quot;Miriam sings beautifully,&quot; she brought us in and told us stories of life, danger, heartbreak, violence, and love. Miriam is - and always was - a flawless singer, but her acting in this show was unparalleled. Sensitive, candid, visceral, and dedicated to truth - all the things I crave in a theatrical performance."
slug = "in-review-ayre"
title = "In review: Ayre"
+++

Tucked away on Wynford Road in North York is the beautiful Ismaili Centre. Located next to the Aga Khan Museum, the Ismaili Centre is one of Toronto's newest gems. The white marble floors and mosaics of semiprecious stones provided a stunning locale for [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/)'s latest offering.

The show, named [*Ayre: An evening of Osvaldo Golijov*](http://againstthegraintheatre.com/ayre/) was a collection of music by Argentine composer Osvaldo Golijov.

The first half was a migratory journey through the Centre starting in the gallery, featuring a string quartet from the Glenn Gould School (violinists Jenifer Murphy and Barry Shiffman, violist Laila Zakzook, cellist Drew Comstock), plus GGS clarinetist Brad Cherwin, and sopranos [Ellen McAteer](/scene/people/ellen-mcateer/) and [Adanya Dunn](/scene/people/adanya-dunn/). 

The night opened with a quartet piece called *Yiddishbbuk*; written in 1992, the piece sounds very much of the time. Portraying a "broken song played on a shattered cimbalom," the disjunct rhythms and dynamics piled on top of each other in a sort of highly organized cacophony. The piece gave you a great insight into where Golijov's journey began towards finding his composer's voice. The players executed the volatility of the  piece with intelligence and candor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479215082916/2016-11-16---Dunn.jpg.jpg)
<figcaption>Soprano Adanya Dunn. Photo by Darryl Block.</figcaption>
</figure>

The second piece, titled *Lúa Descolorida* featured the quartet and Adanya Dunn. Ms. Dunn first caught our attention in the University of Toronto Opera School production of Britten's *Albert Herring* and hasn't stopped since.  This piece, witten in Gallego (the language of the Galicians - simply put: Spanish Celts) while the shortest on the program, I found gave us our first glimpse at how Golijov can use the voice in a more traditional sense. 

While the interplay between vocals and strings was fantastic, it was still very much a vocal piece with string quartet. Dunn's voice handled the extreme range and colours covered in the piece beautifully. The area of the foyer where this piece took place was a little unforgiving acoustically, but you were so transfixed by the intimacy of the whole affair you barely noticed.

*Tenebrae* was next, featuring the quartet with soprano Ellen McAteer and Brad Cherwin on clarinet. This piece saw the vocals and clarinet basically singing a duet with each other; Cherwin's clarinet sound blended seamlessly with McAteer's rich soprano to the point where I thought at times the clarinet was producing the consonants. In this piece, you felt less like it was a piece for "voice and small ensemble" and more "sextet where one instrument is a human voice" and it was the perfect way to cap off the first half.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479215043542/2016-11-16---McAteer.jpg.jpg)
<figcaption>Soprano Ellen McAteer. Photo by Darryl Block.</figcaption>
</figure>

After an intermission of hob-nobbing with a "who's-who" of the opera world (seriously - this was the place to be) we were ushered into a more traditionally arranged performance space.

There was no way I could be prepared for what happened next.

*Ayre* is a song cycle of eleven movements with an eleven-piece "band," including clarinets, horn, guitar, harp, electronics, percussion, double bass, cello, viola, violin, and flute arranged in that order along the borders of the stage. The piece was originally written for American supervox Dawn Upshaw, but I believe that's only because Golijov hadn't yet met [Miriam Khalil](/scene/people/miriam-khalil/).

After a brief introduction by Artistic Director [Joel Ivany](/scene/people/joel-ivany/), we settled in for what was possibly one of the most impressive vocal feats of the season.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479215219070/2016-11-16---Ayre-Block.jpg.jpg)
<figcaption>Photo by Darryl Block.</figcaption>
</figure>

Khalil took us on an emotional and musical journey that I'm still recovering from much later. *Ayre* draws its material from Spanish, Arabic, Hebrew, Sardinian, and Ladino texts ranging from 500BC to about 1492AD. The whole piece was phenomenal, but when it's presented by a singer of Khalil's calibre (of which there are few) it's transformative on every level. 

Throughout the piece Khalil's dark rich tone was always in the forefront, but what really impressed me is the focus on the drama of all these songs. This wasn't just "Miriam sings beautifully," she brought us in and told us stories of life, danger, heartbreak, violence, and love. Miriam is - and always was - a flawless singer, but her acting in this show was unparalleled. Sensitive, candid, visceral, and dedicated to truth - all the things I crave in a theatrical performance.

From the point the second movement started, I was in tears. Not the violent tears I cried after the "Red Wedding" or after reading the "battle of Hogwart's", but the kind of tears you cry when you experience true beauty in person. Beauty with all its nuances, difficulties, and darkness that aren't being excused, but incorporated - even celebrated. Like the whole audience, I was suspended in this stasis of stirred emotion the repercussions of which were felt long after the final bows were taken. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479215182303/2016-11-16---Ayre-Block-2.jpg.jpg)
<figcaption>Soprano Miriam Khalil. Photo by Darryl Block.</figcaption>
</figure>

Khalil used every colour, effect, and tool available to her vocally over the course of this production. I have to say, it's one of the highlights of my season to finally have heard Miriam sing in Arabic. It provided a perspective that brought you to understand where the beauty of her sound comes from. There were times when her voice was looped and she sang in canon with herself creating a mystical apogee through which the piece travelled - the fact that this part of the show was sung in her native Arabic was also part of the thrill of it all. So much truth and passion enveloped every syllable she uttered. 

Shout out to electronic musician Jeremy Flower who designed all the digital sounds as part of the show. They blended seamlessly with the rest of the show and especially in the protest song and the breaks between "Wah Habibi". I also have to applaud the decision for amplification of all instruments. I often find that when ensembles incorporate a digital/electronic element that gets played through a PA system, it's hard to balance that amplification properly with the acoustic musicians and singers. I've always held the position that if one instrument goes through a monitor, they all have to - for the sake of the audience's enjoyment. 

[\#AtGAyre](http://againstthegraintheatre.com/ayre/) is closed now, and if you missed it - you missed a good one. However, I urge you to check out Golijov's music if you're not already aware of it.

Against the Grain Theatre returns in the spring with a remount of the show that started it all - [*La Bohème*](http://againstthegraintheatre.com/la-boheme/) - May/June 2017 at the Trazac Club. Plus, don't forget to check out their next [Opera Pub](/atgs-opera-pubs-it-can-all-get-a-bit-wild/) at the Amsterdam Bicycle Club on December 1st. 
