+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-04-16T10:48:00-04:00"
lastmod = "2015-04-23T22:30:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429842444037/AshRosesAlbum.png"
publishDate = "2014-04-16T10:48:00-04:00"
related_articles = ["articles/phillip-addis-emily-hamper-the-pilgrim-soul.md","articles/album-review-cloud-light.md"]
related_companies = ["scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/lawrence-wiliford.md","scene/people/mireille-asselin.md","scene/people/liz-upchurch.md","scene/people/steven-philcox.md"]
short_description = "Ash Roses is the first CD released by the Canadian Art Song Project (CASP), and it features the music of composer Derek Holman. I&#039;m not personally familiar with Holman&#039;s work, but I caught some at the CASP recital in the Richard Bradshaw Amphitheatre a few weeks ago, and I distinctly remember liking it."
slug = "in-review-ash-roses"
title = "In review: Ash Roses"
+++

_Ash Roses_ is the first CD released by the [Canadian Art Song Project](http://www.canadianartsongproject.ca/) (CASP), and it features the music of composer [Derek Holman](http://www.musiccentre.ca/node/37210/biography). I'm not personally familiar with Holman's work, but I caught some at the CASP recital in the [Richard Bradshaw Amphitheatre](http://www.coc.ca/performancesandtickets/freeconcertseries.aspx) a few weeks ago, and I distinctly remember liking it. The album features Canadian singers [Mireille Asselin](http://www.mireilleasselin.com/) and [Lawrence Wiliford](http://www.lawrencewiliford.com/), co-founder of the Canadian Art Song Project (with Steven Philcox), with pianist [Liz Upchurch](http://www.standrewsartscouncil.nb.ca/faculty/lizupchurch.htm) and harpist Sanya Eng.

The first set, _The Four Seasons_ was commissioned by the [Canadian Opera Company](http://www.coc.ca/) in memory of Richard Bradshaw; Lawrence Wiliford and Liz Upchurch premiered it in 2009 at the Richard Bradshaw Amphitheatre. The cycle uses texts by cornerstone English poets like Shakespeare, Hardy, and Tennyson, and the poems are ordered by season, starting with winter and ending with autumn. Says Holman in his program notes, it was "an echo of Richard's strength and optimism: 'If winter comes, can spring be far behind?'"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429842539150/Lawrence.jpg.jpg)
<figcaption>Tenor Lawrence Wiliford.</figcaption>
</figure>

I liked this set; it had a transparent texture, keeping the text unobscured. The songs are frank, with never more bars than needed, but Holman always leaves space for real enjoyment of the words. In this set I was reminded of Dominick Argento and Gerald Finzi, perhaps because of the poems chosen. "Summer Thirst" is one of my favourites, starting off not-so-subtly as a drinking song, and delivered as a defiant philosopher.

Lawrence sounds beautifully clear, just like he's speaking, risking plenty to give us every word. He had moments of gorgeous soft singing, but showed off lots of power, like in the final song, "The West Wind". Liz's playing matched Lawrence's clarity and precision, but she got to show us her chops as well. In "Towering Camelot" and "The West Wind" I thought of Rachmaninoff, Chopin and Prokofiev; Liz always enjoyed the rolling bass lines (and so did I).

The title set, _Ash Roses_, is sung by Canadian soprano Mireille Asselin, with Liz Upchurch again at the piano. The set was premiered in 1995 at the University of Toronto by [Karina Gauvin](http://karinagauvin.com/) and [Michael McMahon](http://www.mcgill.ca/music/about-us/bio/michael-mcmahon). The texts are by Canadian poet Tricia Postle, who was a U of T student at the time Derek Holman was starting to write a song cycle for Gauvin. The songs are brilliant, almost schizophrenic, and definitely funny when they should be. I spent the whole set saying to myself, "No, I think _this_ is my favourite." "Maze" is about finding one's way, and I actually found it sort of sexy. "Sweet Breath at Night" is a bit of black comedy, about the possibility of panthers being in one's bedroom (and the possibility of senility). The word-painting in this song was so obvious it was brilliant. In this song, Liz proved she's a chameleon at the keys, and Mireille got to show off her fiery coloratura and enormous palate of colour. She also sang my favourite out-of-context line of the album: "Drinking from the toilet bowl."Out of the six songs, however, "Arabesque" stood out for me. It's an exquisitely built poem, using old devices like threefold repetition and an ever-growing refrain. Holman sets it in no hurry, lingering over these words exactly as I needed. Mireille's singing is just _beautiful._

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429842591174/Mireille-816x1024.jpg.jpg)
<figcaption>Soprano Mireille Asselin.</figcaption>
</figure>


I loved the duet, _Now Sleeps the Crimson Petal_, sung by Lawrence and Mireille. The Tennyson text was set like a dialogue, each voice passing off alternating lines of text. When they did sing together, they created pulling harmonies that reminded me of Richard Strauss or John Duke. The dialogue-like setting made me look at this poem differently; it started to feel like a real conversation between two people, and it really did double the impact.

The final set on the album is _Three Songs for High Voice and Harp_, set to texts by [Thomas Hardy](http://en.wikipedia.org/wiki/Thomas_Hardy), E.H. Thomas and [A.E. Housman](http://www.poets.org/poet.php/prmPID/631). The songs premiered in 2011 by Lawrence Wiliford and Sanya Eng at U of T, and Lawrence and Sanya returned to record them for _Ash Roses_. The first two songs, "Midnight on the Great Western" and "Adlestrop" are poems that storytelling style, like old ballads. Lawrence enjoys playing the role of storyteller, and he sings this set with care and skill. With expansive chords, Sanya instantly creates this "once upon a time" feeling, like we were all sitting down by a fire to hear some tall tales. These two songs were stories about travellers, and in both, Sanya seems to evoke the sound of a dreamy passenger train. Holman dedicates the final song, "Loveliest of Trees", to his wife Margaret. It has a bit of a minstrel-song feel to it, but a bit more celestial-sounding, and with some surprising harmonies. Lawrence sings this song particularly beautifully.

It's clear that the Canadian Art Song Project is not starved for excellent artists. Their first album release is a successful start to what I hope will be a trend of recording more and more Canadian music. You can help make that happen by picking up a copy of _Ash Roses_ online at [Canadian Music Centre](http://www.musiccentre.ca/node/81884), or [iTunes](https://itunes.apple.com/ca/album/holman-ash-roses/id840876792).
