+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-01-10T15:05:00-05:00"
lastmod = "2015-04-11T23:32:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428809465138/anne-sofie-von-otter-credit-ewa-marie-rundquist.jpg.jpg"
publishDate = "2015-01-10T15:05:00-05:00"
related_articles = ["articles/in-review-dmitri-hvorostovsky-at-koerner-hall.md"]
short_description = "Last night I went to see famed mezzo-soprano Anne Sofie von Otter and star pianist Angela Hewitt in recital. I couldn’t believe my luck; these two women are both artists whom I’ve wanted to hear live for years, and here they both were at the very convenient Koerner Hall. They performed a focused, cohesive program. "
slug = "in-review-anne-sofie-von-otter-and-angela-hewitt"
title = "In review: Anne Sofie von Otter and Angela Hewitt"
+++

<p class="intro">
	Last night I went to see famed mezzo-soprano <a href="http://www.annesofievonotter.com/" target="_blank">Anne Sofie von Otter</a> and star pianist <a href="http://www.angelahewitt.com/" target="_blank">Angela Hewitt</a> in recital. I couldn't believe my luck; these two women are both artists whom I've wanted to hear live for years, and here they both were at the very convenient Koerner Hall. They performed a focused, cohesive program. The first half was (mostly) all German, featuring Lieder by Beethoven, Schubert and Brahms, and French repertoire (Hahn, Chabrier, and Fauré) took up the second half, including one of my own personal favourites, Debussy's <em>Trois chansons de Bilitis</em>. Hewitt showed off her solo chops, too, with piano music by Schubert, Brahms and Chabrier.<br>
</p>
<p>
	Anne Sofie sang in a easy, bright voice, and she always made sure the voice was a vehicle for the text. The first half, I thought, was full of music that progressively suited her voice more and more. Beethoven songs aren't my favourite, and Anne Sofie made a point of mentioning that old Ludwig isn't the greatest writer for the voice. But I loved what the one Italian-language song ("In questa tomba oscura") did for her sound; there was more line in the song anyway, but something about the brighter language gave me my first chance to really hear Anne Sofie's voice. Her Schubert was sensitive but not too precious (I really dislike wimpy Schubert). It was in the Brahms Lieder that I loved her most. She showed off a textbook legato in these songs, not letting a note go by un-sung. And she still sounds young! I love when you can hear technical evidence of a singer who's been smart for decades.
</p>
<p>
	Surprisingly, I liked her French half the best. Again, the brighter language gave her lots of ring, and she seemed more willing to fill out the top of her voice. She and Angela gave one of the more beautiful readings of <em>Trois chansons de Bilitis</em> that I've ever heard. Speaking of Angela, she was a great collaborator, with a healthy mix of leading and listening. She brought out aspects of these songs, some of which I know well, that I'd never heard or paid attention to before. It sounds like an odd thing to say, but Angela's left hand was spectacular. She made sense of the Beethoven Lieder this way, and found the trick to all those odd Brahms phrases. In the French repertoire, her sound was what I'd always strived for when I took on pieces like Fauré's <em>Clair de lune</em>. She had a specific sound to each song that was noticeable, and she didn't shy away from playing with guts. I thought she covered Anne Sofie a few times, but I forgave her easily. Angela rocked out on her last solo piece, Chabrier's Idylle, which sounded like Beethoven if he were Poulenc, and got wide-armed applause from Anne Sofie herself.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428809512628/Hewitt_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ZBGHFGoienyyC0Dr9GBuYcLykgi9DCLLANuJWQjnmpp-yRSjuxGxoX5t-t8B7U4Kle4_USheNsxJ8-m15mcLpzPYsTI" src="http://lh3.googleusercontent.com/ZBGHFGoienyyC0Dr9GBuYcLykgi9DCLLANuJWQjnmpp-yRSjuxGxoX5t-t8B7U4Kle4_USheNsxJ8-m15mcLpzPYsTI=s1200"></a><figcaption>Pianist Angela Hewitt. Photo: Maiwolf</figcaption></figure>
<p>
	The repertoire for this concert was, for my own taste, a bit conservative. I kind of wanted to hear what Anne Sofie would sound like in some Kurt Weill cabaret songs, or something really weird. But these two women did what they do best, and it was obvious that they both loved every song they performed. Conservative as it may have been, Angela and Anne Sofie had fun. Angela seemed to act out stories with her hands, and Anne Sofie did a little jig to a song's peppy postlude more than once. A recital like this is a testament to the women's skill. Angela showed that her playing is about the music, not about putting herself at the forefront; Anne Sofie reminded us all that she's got more tricks up her sleeve than being an Octavian-extraordinaire.
</p>
<p>
	I sat beside Michael Vincent (of <a href="http://www.musicaltoronto.org/" target="_blank">Musical Toronto</a>) for the concert, and he mentioned to me that Anne Sofie von Otter and Angela Hewitt had been trying to co-ordinate a concert together for several years. I hope they do it again soon.
</p>
