+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-10-29T12:34:00+01:00"
lastmod = "2016-10-31T17:43:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477935295846/2016-10-31---Temple-Music-281.jpg.jpg"
primary_image_credit = "Raphaela Papadakis in And London Burned, Temple Church, 2016. Photo by Chris Christodoulou."
publishDate = "2016-10-29T13:52:00+01:00"
related_people = ["scene/people/alessandro-fisher.md"]
short_description = "It was the stories of the Londoners, represented by Gwilym Bowen, Aoife O&#039;Sullivan, and Andrew Rupp (who also sang the Duke of York and Dryden), that earned even more fear than the tale of the fire itself; they were the horrifying story of *people* during a disaster. There were the carters who inflated their prices to evil proportions; there were those who wasted time blaming the fire on sin or the Dutch or the year 1666; there were looters, racists, and useless officials. It&#039;s terrifying to consider, in a disaster, how a city is at the mercy of its citizens."
slug = "in-review-and-london-burned"
title = "In review: And London Burned"
+++

In this 350th year since the [Great Fire of London](https://en.wikipedia.org/wiki/Great_Fire_of_London) in September of 1666, Temple Church has commissioned the new opera by [Matt Rogers](http://www.gameshowoutpatient.com/) and [Sally O'Reilly](http://www.sallyoreilly.org.uk/), *And London Burned*. 

O'Reilly's libretto draws from the historical accounts of the fire that swallowed a massive area of the City of London, along the Thames roughly between the Tower of London and Blackfriars Bridge, and north of the river as far as the Barbican Centre of today. Most of the City's buildings and churches - including St. Paul's Cathedral - were destroyed, along with the homes of 70,000 of the then 80,000 residents.

The Temple Church, though, survived. "There are bound to have been those who watched from the roof of the Temple Church as the skies darkened and the roar and glow of the flames came ever closer, driven unstoppably on by a near gale," writes Donald Cryan, Teasurer of the Honourable Society of the Inner Temple. "There were the citizens of London in unprecedented numbers, rich and poor, whose homes and livelihoods had been devastated. There was the great City itself, with its mansions, hovels, workshops, warehouses, shops, counting-houses, gaols, Livery Halls, churches and the great Cathedral of St. Paul, all no more than a smouldering desert."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477935778755/2016-10-31---Temple-Music-175.jpg.jpg)
<figcaption>Photo by Chris Christodoulou.</figcaption>
</figure>

It was indeed eerie - and for the history lovers, exciting - to hear *And London Burned* in the Temple Church. Matt Rogers' score begins with wordless monodies, like the conversations of Londoners in the hours before the fire began, and we hear the sparks and embers as the disaster grows beyond control. There is a distinct mixture of civic pride and tragic history, with proud horns playing in painful dissonance, and the touching use of the organ to evoke both fear and tradition. Musical Director [Christopher Stark](https://christopher-stark-8hlw.squarespace.com/#welcome) led the 7-piece orchestra deftly and helpfully, providing clarity in what seems a murky score.

Five singers brought the story to life across a runway stage in the middle of Temple Church. London herself was anthropomorphized, sung wisely - and at times, seductively - by soprano [Raphaela Papadakis](/scene/people/raphaela-papdakis/). We meet the law student who later lends his hand against the fire and resulting civil disorder, sung in a pleasing tenor by [Alessandro Fisher](/scene/people/alessandro-fisher/). 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477935662408/2016-10-31---Temple-Music-190.jpg.jpg)<figcaption>Photo by Chris Christodoulou.</figcaption>
</figure>

Earning more fear than the fire itself were the stories of the Londoners, represented by [Gwilym Bowen](/scene/people/gwilym-bowen/), Aoife O'Sullivan, and Andrew Rupp (who also sang the Duke of York and Dryden); they were the horrifying picture of what happens to everyday people during a disaster. There were the carters who inflated their prices to evil proportions; there were those who wasted time blaming the fire on sin or the Dutch or the year 1666; there were looters, racists, and a [useless mayor](https://en.wikipedia.org/wiki/Thomas_Bloodworth). It's terrifying to consider, in a disaster, how a city is at the mercy of its citizens.

Director Sinéad O'Neill made great use of the Temple Church interior, placing voices above and around the audience, as though the listeners were at the heart of the action.  The singers had great clarity of text, working hard against the impressive echo of the Church's acoustics. The runway stage was a great solution to the tricky seating set-up; at times, visibility was difficult when the singers moved to the extreme ends of the stage. Still, *And London Burned* is a piece that we'd love to see again, if only to keep our eyes on new characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477935770736/2016-10-31---Temple-Music-139.jpg.jpg)
<figcaption>Photo by Chris Christodoulou.</figcaption>
</figure>
