+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-12-28T13:00:00-05:00"
lastmod = "2015-04-12T12:09:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428853512946/166-copy_Fotor.jpg.jpg"
publishDate = "2014-12-28T13:00:00-05:00"
related_articles = ["articles/this-weekend-chelsea-moor-castle.md","articles/dont-miss-sasha-regans-allmale-mikado.md","articles/dont-miss-the-chocolate-soldier.md","articles/tots-candide-its-very-sincere-and-passionate-.md","articles/technicolour-gs-enos-iolanthe.md"]
related_companies = ["scene/companies/toronto-operetta-theatre.md"]
related_people = ["scene/people/adrian-kramer.md","scene/people/lucia-cesaroni.md","scene/people/giles-tomkins.md","scene/people/gregory-finney.md"]
short_description = "Last night I went to see Toronto Operetta Theatre‘s production of The Mikado at the St. Lawrence Centre for the Arts. Neither Gilbert nor Sullivan show up frequently on my list of must-sees, due to personal taste and perhaps too many earworms (#iamtheverymodelofamodernmajorgeneral). But I had much faith (and a few friends) in the Canadian cast, and I absolutely wasn’t disappointed."
slug = "in-review-ah-mikado"
title = "In review: Ah! Mikado!"
+++

<p class="intro">
	Last night I went to see 
	<a href="http://www.torontooperetta.com/index.html" target="_blank">Toronto Operetta Theatre</a>'s production of <em>The Mikado</em> at the St. Lawrence Centre for the Arts. Neither Gilbert nor Sullivan show up frequently on my list of must-sees, due to personal taste and perhaps too many earworms (#iamtheverymodelofamodernmajorgeneral). But I had much faith (and a few friends) in the Canadian cast, and I absolutely wasn't disappointed. Now, I'm no expert in the hidden political commentary and layers of meaning that I know exist in good G&amp;S, and in the case of <em>The Mikado</em>, I tend to get hung up on the exaggerated Japanesery and tackiness of the whole story. Not to mention the endless pentatonic scales in the score that sounded like bits from <em>Madama Butterfly</em>; I reminded myself that when Western composers limit themselves to the "five Asian pitches", they limit their options for melodic originality. I'll put my quibbles with the show itself aside, because it was clear that this production was not trying to tell a true story of actual people in Japan. TOT General Director <a href="http://www.torontooperetta.com/about.html" target="_blank">Guillermo Silva-Marin</a> clearly knew that exaggeration is one's ticket out of the shroud of a dated piece like <em>The Mikado</em>. The giggling gaggle of Japanese girls, the archaic reverence to the Mikado (ah! Mikado!), it was all clearly overdone to the point of freeing the artists from the elements in the show that can make today's audiences squirm.<br>
</p>
<p>
	Speaking of the artists: as Nanki-Poo, tenor 
	<a href="https://twitter.com/aitkramer" target="_blank">Adrian Kramer</a> sounded fantastic. He sang with his full voice, which was round and even from top to bottom. He had throaty qualities as his rose higher (which I loved), and it gave him a bit of an Italian-tenor sound; he also had moments of real vocal risk to get a wide palate of colours. I always love when the tenor's full voice isn't his only trick. Adrian's voice filled out the leading role with command, and it mixed hilariously with his cartoon-like faces, slapstick comedy, and demeanour that was young and loveable.
</p>
<p>
	As Nanki-Poo's love Yum-Yum, soprano 
	<a href="http://luciacesaroni.com/" target="_blank">Lucia Cesaroni</a> was wide-eyed, bubbly and adorable; I think she had my favourite entrance by a soprano that I've seen in a long time, filling the hall with deafening shrieks of excitement upon seeing her friends. She sang beautifully too. I'm a huge fan of Lucia's voice, with its warmth and darkness and surprising ease up top. Yum-Yum doesn't give a soprano much room for line, save for her Act II aria, "The sun whose rays are all ablaze". Lucia sang that with gorgeous evenness and soul in her sound, and even tackled the finnicky, awkwardly-high bits in her many ensemble numbers. Like Adrian, Lucia commanded attention with her voice, and offered up a Yum-Yum who was charming, simple, and young. The two of them together were so freaking cute, in that way that nerds are so freaking cute together. They were goofy and passionate, as Nanki-Poo and Yum-Yum were not only each other's true loves, but also best friends and partners in crime. Aww.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428854894043/156-copy_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/7ciyg9HkJW4evejfdK71jiWQblDe1qchq30__x1uaf6dNpmoBdybk8Iraf8c_9WFqZZDghfcDsZsRBFe5jtrrVFmUhb0" src="http://lh3.googleusercontent.com/7ciyg9HkJW4evejfdK71jiWQblDe1qchq30__x1uaf6dNpmoBdybk8Iraf8c_9WFqZZDghfcDsZsRBFe5jtrrVFmUhb0=s1200"></a><figcaption>Adrian Kramer (Nanki-Poo) and Lucia Cesaroni (Yum-Yum)</figcaption></figure>
<p>
	Another standout for me was bass-baritone 
	<a href="http://www.gilestomkins.com/" target="_blank">Giles Tomkins</a> as the Mikado. I've always loved Giles' voice, but I don't think I'd ever seen him in anything funny before. He had a booming clarity when he sang, giving him due authority to go with his tall (and wide, thanks to his costume!) presence. His speaking voice was just as satisfying, but I loved best his fantastic, quasi-evil belly laugh that happened right after the line about ".....elliptical billiard balls!!" Giles was a real pro and it was fantastic to see him in this role that seemed to bring out some of his best onstage qualities.
</p>
<p>
	Tenor 
	<a href="http://www.torontooperetta.com/artists.html" target="_blank">Joseph Angelo</a> sang Ko-Ko, the Lord High Executioner, and the man who's supposed to marry Yum-Yum. He was great with all his moments of slapstick comedy, acting as a proper foil to Adrian's Nanki-Poo. Vocally, the role seemed low for Joseph, and at times he got drowned out by the orchestra. His aria about eugenics, "I've got a little list" was missing some oomph, some threat to it. I missed some of his text, too, however he had a knack for physicalizing his lines as much as he could, so I didn't miss much of the intention. As the old, scorned daughter-in-law-elect of the Mikado, Katisha, mezzo-soprano <a href="http://www.mialennoxwilliams.com/" target="_blank">Mia Lennox</a> sang with a rich and warm sound and an enviable low register. Katisha is a big sing, exposing plenty of technical prowess, and Mia filled out the role with a really lovely sound. I had trouble getting her text, too, taking away from the gravity of Katisha's story in the show.
</p>
<p>
	As Pooh-Bah, the Lord High Everything Else, 
	<a href="http://www.torontooperetta.com/artists.html" target="_blank">David Ludwig</a> was hilarious. He seemed the most at home with the G&amp;S style, both in how he sang, and in how he negotiated his complicated dialogue (that I bet was a bitch to memorize). Despite the writing for Pooh-Bah being mostly ensemble and patter work, David grew on me as a singer throughout the show. He kind of reminded me of the Tom Allen School of G&amp;S (<a href="http://www.youtube.com/watch?v=WlOb0XMxt84" target="_blank">watch and learn</a>). My man <a href="https://twitter.com/gregory_finney" target="_blank">Gregory Finney</a> was funny and sobering as Pish-Tush. He sang with that big, surprising voice of his, and kept the clarity throughout his patter with serious skill. Greg is always great for making sense of the nonsense that keeps popping up in operetta. I died when he won the onstage game and anachronistically raised both fists triumphantly. He also gets bonus points with Adrian Kramer for best handling of an onstage snafu that I've ever seen (Greg's fan broke, and Adrian didn't miss a beat passing him a new one). <a href="http://www.torontooperetta.com/artists.html" target="_blank">Brittany King</a> and<a href="http://www.torontooperetta.com/artists.html" target="_blank"> Daria Bukhman</a> were lovely as Pitti-Sing and Peep-Bo, two of the little maids from school.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428854929517/101-copy_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/X_4ZtMkKDglB0UoXo1leOF8x0jeF4rOncUX2Uu2pnu3NOI7drNGrsEKiaX8e-WQiRAa0wpNR4TGrtdJPKJxg8wIdENk" src="http://lh3.googleusercontent.com/X_4ZtMkKDglB0UoXo1leOF8x0jeF4rOncUX2Uu2pnu3NOI7drNGrsEKiaX8e-WQiRAa0wpNR4TGrtdJPKJxg8wIdENk=s1200"></a><figcaption>Joseph Angelo (Ko-Ko) and David Ludwing (Pooh-Bah)</figcaption></figure>
<p>
	The Ensemble was well-coached by music director and conductor 
	<a href="http://www.operabase.com/a/Derek_Bate" target="_blank">Derek Bate</a>; nice harmonic and textual clarity. I especially loved the ladies' entrance. The orchestra sounded great, tackling some tricky-sounding bits that I hadn't remembered before. The sets were suggestive of environment without being too vague; plenty of red and pretty parasols created the world of <em>The Mikado</em> clearly. I thought some of the choreography was a bit awkward and unmusical, and there were a few prop mishaps that amused me, although perhaps for the wrong reasons. I'd say that the skill of the cast carries the production, which had the feeling of a remount.
</p>
<p>
	<em>The Mikado</em> plays until January 4th, including a fancy-schmancy New Year's Eve performance, complete with pre-show food and drink and midnight champagne. For more info and to purchase tickets, click <a href="http://www.torontooperetta.com/tickets.html" target="_blank">right here</a>.
</p>
<p>
	Bravi, guys! Have a great run.
</p>
