+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-05-13T11:39:00+01:00"
lastmod = "2016-05-13T15:12:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463136125511/2016-05-13---AGAINST-NATURE-Laurence-Lemieux-Geoffrey-Sirett_W0A3159_against-nature.jpg.jpg"
primary_image_credit = "Goeffrey Sirett and Laurence Lemieux in Coleman Lemieux & Compagnie's Against Nature. Photo: Jeremy Mimnagh."
publishDate = "2016-05-13T11:46:00+01:00"
related_articles = ["articles/dont-miss-against-nature.md"]
related_companies = ["scene/companies/coleman-lemieux-compagnie.md","scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/geoffrey-sirett.md","scene/people/alexander-dobson.md","scene/people/steven-philcox.md"]
short_description = "The overall effect of the piece was enchanting. A moving piece of lyrical theatre that is a perfect fit for this time of year. Beautiful music with entrancing movement in a charming space that tells a nuanced and layered story. Toronto has had a great spring so far with regards to performing arts and events, and Against Nature is one of the reasons."
slug = "in-review-against-nature"
title = "In review: Against Nature"
+++

On the southern tip of Cabbagetown in Toronto's east end is a beautiful yet unassuming brick building called The Citadel, which is the home to [Coleman Lemieux & Co](/scene/companies/coleman-lemieux-compagnie/). I had never noticed this space before and I'm glad I was able to see it for the first time during such an amazing and cool show. We were greeted and ushered into a small mirrored studio (with a cash bar - I DO love this trend) to wait to be escorted into the mainspace. It's not a huge house, but the seats are full and it has a nice and roomy stage. Off the the corner sat a trio of musicians (piano, violin, cello) in full costume. Then the show began. 

In the world premiere of *Against Nature* by composer [James Rolfe](/scene/people/james-rolfe/) and librettist Alex Poch-Godin, baritone [Alexander Dobson](/scene/people/alexander-dobson/) plays the role of Jean des Esseintes from the novel *À rebours* by Paris author Joris-Karl Huysmans. Esseintes is an aristocrat who exiles himself to the countryside to live among his art and books and contemplate them on an aesthetic level. More and more disenchanted with the 18th Bourgeois class, we follow him as his reclusiveness contributes to his downfall - both physically and mentally. 

Dobson sings the role of "The Master" gracefully, magnificently and tenderly all at the same time. His mastery of various colours really painted the scene clearly. Rolfe's score flowed effortlessly as he traversed a remarkable vocal range demanded by the part. The score was very tuneful and romantic at points, with occasional leanings toward folk and pop tunes. It was a delight to listen to. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463136196563/2016-05-13---AGAINST-NATURE-Laurence-Lemieux-Alexander-Dobson-Geoffrey-Sirett-Still004.jpg.jpg)<figcaption>l-r: Laurence Lemieux, Alexander Dobson, and Geoffrey Sirett in Coleman Lemieux & Compagnie's *Against Nature*. Photo by Jeremy Mimnagh.</figcaption>
</figure>

As the servants, [Geoffrey Sirett](/scene/people/geoffrey-sirett/) and Laurence Lemieux were incredible. Sirett sang with his full, warm bass-baritone and sounded so delightful when singing with Dobson. There's just something magical about hearing two amazing lower voices sing together making such beautiful music. Sirett takes his work from *AtG's Messiah* (2013) to the next level in this piece in a much more demanding set of choreography - proving yet again that one can produce a beautiful lyric tone while fully engaging one's body and physicality. Lemieux danced with an earthy grace that told us not only that she is a sensual creature in this household, but also a force to be reckoned with in this environment. The two moved in and around Dobson with extreme precision and power. There was a freneticism to the dancing that was an excellent foil to Dobson's portrayal of the stiff, aristocratic nature of Esseintes. 

[James Kudelka](http://colemanlemieux.com/company/james_kudelka/), director and choreographer, does a fantastic job infusing the story with subtext and drama, at points the servants acting almost as a physicalization of his subconscious. There was a definite expression of the suppression of sexuality. With Esseintes regularly noting how "sex disgusts him" (paraphrased - obviously), we see him battle with the demon of innate sexuality rearing its ugly head (portrayed by Sirrett and Lemieux) only to see him physically stop it - several times, once including a puppet. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463136301320/2016-05-13---AGAINST-NATURE-front-Alexander-Dobson-back-Laurence-Lemieux-Geoffrey-Sirett-Still006.jpg.jpg)<figcaption>l-r: Laurence Lemieux, Alexander Dobson, and Geoffrey Sirett in Coleman Lemieux & Compagnie's *Against Nature*. Photo by Jeremy Mimnagh.</figcaption>
</figure>

Rolfe's score was both sensitive to the needs of the singer while creating a beautiful sonority in the trio of Music Director [Steven Philcox](/scene/people/steven-philcox/) on piano, Parmela Attariwala on violin and Carina Reeves on cello. There were moments where they blended so well with the singers that it was hard to tell which instrument onstage was actually producing the pitch. The effect was mesmerizing. Bravi tutti.

The overall effect of the piece was enchanting. A moving piece of lyrical theatre that is a perfect fit for this time of year. Beautiful music with entrancing movement in a charming space that tells a nuanced and layered story. Toronto has had a great spring so far with regards to performing arts and events, and *Against Nature* is one of the reasons. 

The show runs until May 15 at the Citadel Theatre, and you can get your [tickets here](http://colemanlemieux.com/portfolio/againstnature/).

PS: Shout-out to the #TragicGildedTurtle 
