+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-08-19T09:45:00+01:00"
lastmod = "2016-08-19T10:58:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471596933823/2016-08-19---Dream-Square.jpg.jpg"
primary_image_credit = "A Midsummer Night’s Dream, Glyndebourne Festival 2016. Puck (David Evans). Photo by Robert Workman."
publishDate = "2016-08-19T10:52:00+01:00"
related_articles = ["articles/in-review-beatrice-et-benedict-at-glyndebourne.md","articles/in-review-hipermestra-at-glyndebourne.md","articles/too-much-magic-a-midsummer-nights-dream-at-eno.md"]
related_companies = ["scene/companies/glyndebourne.md"]
related_people = ["scene/people/kate-royal.md","scene/people/kathleen-kim.md","scene/people/benjamin-hulett.md","scene/people/duncan-rock.md"]
short_description = "The royal fairy pair were delightfully complemented by David Evans as Puck, who was one part eerie, and one part utterly charming. He brought the audience to roaring applause at the finale, after an evening of chuckles and smitten murmuring from the crowd."
slug = "in-review-a-midsummer-nights-dream-at-glyndebourne"
title = "In review: A Midsummer Night&#039;s Dream at Glyndebourne"
+++

Beyond the train full of folks in fancy dress, the packed bus that swerved through the impossibly narrow streets of Lewes and out to the broad countryside of Glyndebourne, the intoxicating gardens, and charming distant sounds of bleating sheep, was Peter Hall's production of *A Midsummer Night's Dream*. Aptly programmed alongside Berlioz's *Béatrice et Bénédict* in the 400th year since the death of William Shakespeare, Britten's opera is unabashedly a favourite of ours. The pages of the score are brimming over with magic, with novel sounds that still seem otherworldly, decades after its premiere in 1958.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471597895322/2016-08-19---Dream-Bottom.jpg.jpg)<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Quince (David Soar), Bottom (Matthew Rose) and Snug (Sion Goronwy). Photographer: Robert Workman.</figcaption>
</figure>

Hall's 1981 production was revived this summer by Lynne Hockney, and in a recent [interview with mezzo Elizabeth DeShong](/magic-high-standards-midsummer-at-glyndebourne/), singing Hermia, she pointed out that it was a rare bit of "traditional" staging of Britten's opera. The opportunity for comedy, tragedy, love, and the supernatural, all wrapped in one show with fab music, has to be a "dream" of sorts for any director's imagination. Yet with the enormous palette of colour in this story, Hall seems to focus on what's dreary and dank.

It's hard to argue that a show is too accurate, but that's what seemed to be stubbornly in the way of a feast for the eye as well as the ears. The woods would indeed be dark, sure, and the final act brought some refreshing morning green to the bleak stage; yet Shakespeare and Britten write three stories in one with *Midsummer*, and the deep forest means something different to the lovers, the mechanicals, and to the fairies. John Bury's sets seems to keep us in the lovers' woods, full of confusion and fear, letting Liz Bury's costumes and delightful wigs do the work of showing us the difference between poor humans, rich humans, and fairies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471597693583/2016-08-19---Dream-Fairies.jpg.jpg)
<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Oberon (Tim Mead) and Tytania (Kathleen Kim). Photographer: Robert Workman.</figcaption>
</figure>

If the production felt dreary, it had nothing in common with the exciting singing from the cast. [Tim Mead](/scene/people/tim-mead/) was incredible as Oberon; his sound was constantly beautiful and rich, and he kept the regal quality to the Fairy King, even in his outbursts of rage. Oberon is a role noted for its low tessitura, and Mead was a total expert at handling his instrument, while making it mean something. He had an equally beautiful partner (or foe?) in [Kathleem Kim](/scene/people/kathleem-kim/) as Tytania, whose bell-like sound was prim and shiny, and under clean control. Kim's dramatic performance seemed somewhat dampened by Hall's production, and we're curious to hear her as a Tytania with a bit more personality. 

The royal fairy pair were delightfully complemented by David Evans as Puck, who was one part eerie, and one part utterly charming. He brought the audience to roaring applause at the finale, after an evening of chuckles and smitten murmuring from the crowd.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471597775587/2016-08-19---Dream-Lovers.jpg.jpg)<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Lysander (Benjamin Hulett), Demetrius (Duncan Rock), Helena (Kate Royal) and Hermia (Elizabeth DeShong). Photographer: Robert Workman.</figcaption>
</figure>

The lovers were beautifully cast, falling somewhere between real human beings and archetypes of yearning youths. As Hermia, [Elizabeth DeShong](/scene/people/elizabeth-deshong/) reminded us why we love her with her first notes; the richness in her sound is always surprising, and it's entirely satisfying to hear her clean approach to her text. [Kate Royal](/scene/people/kate-royal/) was a lovely foil as Helena, looking appropriately frazzled and with an urgency in her sound as she hopelessly chases Demetrius through the woods. Her soprano sound had warmth, and perhaps a bit of muddiness with language, but she showed off her comic chops in that fantastic lovers' scene in Act II. [Benjamin Hulett](/scene/people/benjamin-hulett/) and [Duncan Rock](/scene/people/duncan-rock/) shared strapping youthfulness and straightforward sounds as Lysander and Demetrius. The good-looking men took advantage of the lyric moments in Britten's writing, almost making an exaggerated meal of straightforward lines.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471597833479/2016-08-19---Dream-Hermia.jpg.jpg)
<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Lysander (Benjamin Hulett), Demetrius (Duncan Rock), and Hermia (Elizabeth DeShong). Photographer: Robert Workman.</figcaption>
</figure>

Though they don't get those famous lines like, "What fools these mortals be!" or "The course of true love never did run smooth," any honest *Midsummer* fan will admit that the mechanicals are the best part. [Matthew Rose](/scene/people/matthew-rose/) was pompous and blustering as Bottom, dragging the spotlight towards him at any point in a way that made think, "I know a guy like that." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471598045563/2016-08-19---Dream-Play.jpg.jpg)<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Flute (Anthony Gregory) and Snug (Sion Goronwy). Photographer: Robert Workman.</figcaption>
</figure>

[David Soar](/scene/people/david-soar/) sang with a gorgeous, authoritarian sound as Peter Quince, taking on the role of straight-man with perfection. [Anthony Gregory](/scene/people/anthony-gregory/) as Flute, William Dazeley as Starveling, Colin Judson as Snout, and Sion Goronwy as Snug were the charming simple folk that add up to timeless comedy, and each time they left the stage, we wished they'd come back soon. Peter Quince's play goes swimmingly in the final act, particularly Judson's winning looks of sheer boredom during his "wall aria".

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471597990994/2016-08-19---Wall.jpg.jpg)<figcaption>*A Midsummer Night's Dream*, Glyndebourne Festival 2016. Snout (Colin Judson). Photographer: Robert Workman.</figcaption>
</figure>

Under maestro Jakub Hrůša, the Glyndebourne orchestra made beautiful work of the technicolour score, and it was clear that the players were listening to each other and to the singers. The maestro's tempi seemed to drag unnecessarily at times, just shy of an organic pace for the text. Still, the cast delivered great clarity of text and purposeful singing; perhaps the maestro enjoyed Britten's colour more than Shakespeare's words.

It's a special thing to see *A Midsummer Night's Dream* on a midsummer night at the Glyndebourne Festival. Our first visit to the famed countryside experience was a lovely one, and we can't wait for round two, with *Béatrice et Bénédict*.

>*A Midsummer Night's Dream* runs until August 28, with limited availability. For details and ticket information, [click right here](http://www.glyndebourne.com/tickets-and-whats-on/events/2016/f16dream/).
