+++
author = ["authors/greg.md"]
date = "2016-05-13T17:55:00+01:00"
lastmod = "2016-05-14T12:21:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463158501614/2016-05-13---CozySquare.jpg.jpg"
primary_image_credit = "Cast members of Against the Grain Theatre’s A Little Too Cozy. Photo: Darryl Block"
publishDate = "2016-05-14T12:21:00+01:00"
related_articles = ["articles/banff-diaries-the-midway-report.md"]
short_description = "The show has a longer run than most AtG shows (running from now until May 21) so now even more people get a chance to experience the magic. This group keeps turning out hit, after hit, after hit, and the shows will no doubt sell out. They keep changing up the game with their many-pronged media attack, and I think A Little Too Cozy succeeded moreso than the other DaPontes. "
slug = "in-review-a-little-too-cozy"
title = "In review: A Little Too Cozy"
+++

Indie opera superstars [Against The Grain Theatre](/scene/companies/against-the-grain-theatre/), led by the fearless [Joel Ivany](/scene/people/joel-ivany/) have wowed Toronto yet again. Following on the successes of such performances as [*AtG's Messiah*](/atgs-messiah-a-preview/), [*Death/Desire*](/in-review-death-desire/), and [*Pelléas et Mélisande*](/in-review-pelléas-et-mélisande/) we find ourselves with these kooky upstarts somewhere where you haven't seen opera performed in a long time - a television studio. 

The third of Ivany's DaPonte "transladaptations" (after the Dora Award-winning *Figaro's Wedding* and the publicly and critically acclaimed [*#UncleJohn*](/unclejohn-the-toronto-story/)), *A Little Too Cozy* reimagines Mozart's masterpiece, *Così fan tutte*, for a 21st-century audience. 

Ivany set the action as the season finale of a reality TV show, where couples compete in challenges in the hopes of falling in love and finding their match. The "Finale" shows Felicity (Fiordiligi), Dora (Dorabella), Elmo (Guglielmo) and Fernando (Ferrando) as the four finalists gunning for the $100,000 grand prize (which hilariously keeps getting referred to as "a nice down payment"). The updating of the classic actually took care of quite a few issues I had with *Cosí* in its original form. Namely the testing of the girls (and not the men), and also the fact that the girls, who've been courted via text by the gents for so long, in a matter of minutes are completely fooled by their disguises. In this transladaptation, we learn that they couples have never actually seen each other's faces, which makes the switcheroo a lot more credible. 

We were ushered through security and up to the 10th floor of the CBC (anyone attending the show should note you need to enter at the 25 John Street entrance) and into Studio 42 - surrounded by the studios where the CBC shoots *Dragon's Den* and *Hockey Night In Canada*. We walk into a fully realized television set, complete with furniture, working flies, intense lighting (thanks again to the brilliant work of [Jason Hand](http://www.jasonhandlighting.com/)), monitors, floor/stage managers, greeters and cameramen. Rather than having a lobby bell ring to let you know it's time to take your places, one of the hands comes out and just starts a-sweeping the stage as the TV show's theme music is slowly piped into the space. 

You will all LOVE the treatment of the overture. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463219579084/2016-05-13---Cozy-1.jpg.jpg)<figcaption>l-r: Shantelle Przybylo (Felicity), Rihab Chaieb (Dora), Clarence Frazer (Elmo), Aaron Sheppard (Fernando), in Against the Grain Theatre's *A Little Too Cozy*. Photo: Darryl Block.</figcaption>
</figure>

As the gentleman lovers, [Clarence Frazer](/scene/people/clarence-frazer/) and [Aaron Sheppard](/scene/people/aaron-sheppard/) were, for the most part, charming and well-sung. I think the space could have used a little more doctoring as all the sound from all three men seemed to get swallowed up into the ceiling and not project to the audience. Frazer's baritone has quite a heroic tinge to it so it was a shame to see him lose some of that chutzpah due to the real estate he was singing in. I found that his Guglielmo was a little hard to follow. His arias and ensembles were cleanly sung and his choices of embellishments tasteful and well-executed; I just found the characterization a little less layered than I've come to expect from an AtG production. Elmo came off rather demonstrative, and some choices in the physicalization could have been stronger - but that's just the opinion of a lowly reviewer. 

Sheppard's voice was a lot lighter and more delicate than I had recalled and even seemed to hearken towards a bit of a musical theatre tone - which is not a bad thing! The new treatment of "Un aura amorosa" was tender, and earnest. His wholesome tone had the audience eating from the palm of his hand. Sheppard's Fernando was a bit more fleshed out, but - as is often the case with opera singers - I found the gents did have some issues conveying spoken text. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463220125875/2016-05-14---AtG-Cozy-Darryl-Block-6.jpg.jpg)<figcption>Rihab Chaieb (Dora) and Clarence Frazer (Elmo) in AtG's *A Little Too Cozy*. Photo: Darryl Block.</figcaption>
</figure>

As Felicity and Dora ([Shantelle Przybylo](/scene/people/shantelle-przybylo/) and [Rihab Chaieb](/scene/people/rihab-chaieb/), respectively), I feel the girls had a bit better luck navigating both the material and the space. Felicity's meekness and prudish behaviour was a great foil for the uber-21st-century firecracker that was Chaieb's Dora. Honestly I think Chaieb did make me laugh the most. Her edgy, I-need-a-drink persona spoke to me on some very real levels. Vocally, the girls were on the top of their game. I feel their sound was better suited to the space and had less of a difficult time making out the new English diction. "Come Scoglio" and "Smanie implacabili" were highlights of the night in their own right. Actually pretty much any time the two sang together was magic. Their voices were made to make music together. The only issue I had was that the space could sometimes eat up the coloratura, but that was environmental, not technical. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463220220186/2016-05-14---AtG-Cozy-Darryl-Block-3.jpg.jpg)<figcaption>Aaron Sheppard (Fernando), Cairan Ryan (Don L. Fonzo), Clarence Frazer (Elmo) in AtG's *A Little Too Cozy*.</figcaption>
</figure>

As host of *A Little Too Cozy*, [Cairan Ryan](/scene/people/cairan-ryan/) plays Donald L. Fonzo (Don Alfonso) to great success. A very "Don Pardo" kind of archetype, he was equal parts charming and smarmy - think Stanley Tucci in *The Hunger Games* movies. The fashionista in me wants to declare his suits the high point of this show, which were expertly designed by Snezana Pesnic, but that would be selfish. Ryan's voice has an amiable quality that draws you in. I really enjoyed how the music didn't have to suffer for him to produce such a fully fleshed-out character. His handling of the wordy dialogue was deft and clean, and out of the men, I found he filled the space the most. I think my real favourite part here though would be the fact that even though you knew he was toying with these people's lives, you were still on his side. He never once alienated the audience. 

<figure data-type="image">{{% md %}}</figure>

As the Production Manager/Assistant, Despina, [Caitlin Wood](/scene/people/caitlin-wood/) was a delight. As is often the case, Despina was the highlight of the show for me, but it was Caitlin's [no-holds-barred, modern woman](https://www.youtube.com/watch?v=y3MjxWn5W9M) approach to her that drew me in. She used her sex and sexuality as a weapon of manipulation, but never to the point of maliciousness. She was playful, and edgy, and though the envelope was pushed in her hands, she never let it drop. I only have one question regarding Caitlin Wood. Why the hell is she NOT an international superstar yet? Her voice covers an astounding range with an even, clean, well-produced tone and the timbre is just perfect for coloratura fireworks. I want to hear her Lucia. I was excited from the get-go to see her do this role, but she exceeded any possible expectations I had ever had. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463219910275/2016-05-13---Cozy-2.jpg.jpg)<figcaption>Rihab Chaieb (Dora), Catlin Wood (Despina), Shantelle Przybylo (Felicity) in AtG's *A Little Too Cozy*. Photo: Darryl Block.
</figure>

[Christopher Mokrzewski](/scene/people/christopher-mokrzewski/) led a beautiful string quartet and from the moment they started the overture we knew we were in for a ride. With his trademark energy and style, Mokrzewski guided the cast and pit through the incredibly dense score that is *Così* as only he can - and you understand in one moment why he's so in demand as a Musical Director across the country.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463220390267/2016-05-14---AtG-Cozy-Darryl-Block-8.jpg.jpg)
<figcaption>The cast of Against the Grain Theatre's *A Little Too Cozy*. Photo: Darryl Block.</figcaption>
</figure>

The show has a longer run than most AtG shows (running from now until May 21) so now even more people get a chance to experience the magic. This group keeps turning out hit, after hit, after hit, and the shows will no doubt sell out. They keep changing up the game with their many-pronged media attack, and I think *A Little Too Cozy* succeeded moreso than the other DaPontes. Check out their accompanying [videos here](https://www.youtube.com/user/AtGtheatre). Do yourself and 3 friends a favour, [get some tickets](http://againstthegraintheatre.ticketleap.com/a-little-too-cozy/), head downtown to the Entertainment District and do just that - be entertained from start to finish - tell them [Bartolo](http://againstthegraintheatre.com/figaros-wedding/) sent you. 

\#TeamDora #TeamDespina
