+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2014-04-22T08:09:00-06:00"
lastmod = "2017-06-28T21:32:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475768157084/2016-10-06---Defence.jpg.jpg"
primary_image_credit = "Photo by MyEyeSees on Flickr."
publishDate = "2014-04-22T08:09:00-06:00"
related_articles = ["articles/schmopera-is-one.md", "articles/in-defence-of-pianists.md", "articles/what-to-wear-to-an-audition-via-the-red-carpet.md", "articles/breaking-into-the-industry-a-vicious-cycle.md", "articles/catty-commentary-or-whats-not-useful-for-opera.md", "articles/public-practicing-pet-peeves.md", "articles/helpful-singers-opera-does-house-calls.md", "articles/power-plays-and-crossing-lines-.md", "articles/one-more-reason-we-dont-envy-singers.md", "articles/how-was-it-and-other-dangerous-questions.md", "articles/what-else-are-singers-great-at.md", "articles/audition-season-or-the-annual-festival-of-shattered-dreams.md", "articles/in-defense-of-the-day-job-.md", "articles/when-singers-call-in-sick.md", "articles/sick-singers-when-its-best-to-shut-up-about-it.md", "articles/a-singer-and-her-ego.md"]
short_description = "I remember playing some auditions as part of a &quot;mock&quot; audition panel where the singers would get feedback about their audition presentation. I played for a soprano (who’s doing very well for herself lately) who started smart with some Mozart. One of the auditioners then said to her, “Not that it’s at all appropriate, but I’d love to hear the Lodoletta.” Sigh."
slug = "in-defence-of-singers"
title = "In defence of singers"

+++
I remember playing some auditions as part of a "mock" audition panel where the singers would get feedback about their audition presentation. I played for a soprano (who’s doing _very well_ for herself lately) who started smart with some Mozart. One of the auditioners then said to her, “Not that it’s _at all_ appropriate, but I’d love to hear the Lodoletta.” Sigh.

It struck me that opera singers just can't win. No matter how they sound or what they do, someone will have an opinion. Such is life, no doubt; but there's something unique about this trend within the opera world. The habit of giving unsolicited advice to singers has grown into an industry.

> Young singers are getting frightfully used to assuming their opinions are worth the least, which is just tragic when you consider that the singer's job is to pull the whole damn thing off.

I've been privy to plenty of Q&A sessions, coachings, masterclasses, etc., where a group of young potential opera singers learn the difference between good and bad audition behaviour. It starts with making sure you have things like a nice headshot and a clear CV, and takes a rather harsh turn at proper audition attire. By the time you get to what arias or roles are allowed, it's like an abyss of reverse psychology insanity that makes you question your own existence in the universe. It's like a really serious Buzzfeed quiz, "What Should Your Starting Aria _Really_ Be?"

Along the road that is a singer's development, there are checkpoints at which a number of aspiring singers are filtered out of the race. Auditions for undergraduate and graduate schools are two big checkpoints, but the filtering really just comes when young singers are presented with a hurdle. By the time singers are working professionally, they have braved stage fright, foreign language skills, and the struggle for a consistent and workable vocal technique. It seems like the last of these hurdles is learning to "adapt to the business", which means "read people's minds". And I think that's sort of lame.

Like I said, there's an industry focused on telling singers what they're doing wrong, and it's targeting singers who haven't yet had a chance to really see the industry from within. Even I, a mere pianist, fell for it. Say the experts: your audition dress should be below the knee but not floor-length, with closed-toe pumps that aren't hookery, and with your hair out of your face but not in a ballerina-bun. You should wear contacts, not your glasses. You should start with Mozart or Handel, otherwise the auditioners assume you can't sing. You must be malleable and agreeable with the ideas and wishes of any director and conductor, because you won't get hired again if you're not. Oh, but be unique.

> I suppose singers do indeed sign up for criticism; they _feel_, naked (figuratively, mostly), in front of thousands of people for a living.

The result is a bunch of singers who a) all sing the same audition arias, b) are so used to criticism that they're self-flagellating martyrs who can't take a compliment when they hear one. It's a sad thing to see singers who can do truly remarkable things onstage, unwilling to commit to a creative opinion for fear of it being "wrong". It's like they're human oxymorons. It's a shame, because they're not _really_ the ones with the fragile egos.

So, this little mind-game is another stage in the filtering process of potential opera singers, and it works well. But who's left in the race?

The irony is this: if a singer plays the game, listening to advice from others (assumed to be smarter) about what to sing, how to sing it, and how they should present themselves to the industry, they actually end up ill-equipped for the job. It's an epidemic among young professional singers, this assumption that they know nothing, that they're still an opera outsider, and that all this criticism is what they signed up for.

> Singers only need to mold themselves into this constricted box of "acceptable" because some of the same people who preach about this also work at opera companies and hire singers.

I suppose singers do indeed sign up for criticism; they _feel_, naked (figuratively, mostly), in front of thousands of people for a living. But it's a chicken-and-egg thing, with these so-called experts offering advice; singers only need to mold themselves into this constricted box of "acceptable" because some of the same people who preach about this also work at opera companies and hire singers.

It's really a shame, because of course there are great directors and conductors (and companies!) who _don't want_ this sort of cookie-cutter singer who does everything "right". And I know that professional hierarchy and delegation help get things done. But young singers are getting frightfully used to assuming their opinions are worth the least, which is just tragic when you consider that the singer's job is to pull the whole damn thing off.

What do you think? Am I being idealistic? Too tender? Right on the money? Let us know in the comments below!