+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-03-20T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1679000308/media/2023/03/sq_Il_tabarro_521_jgl1u0.jpg"
primary_image_credit = "Daewon Seo (Michele) and Gillian Watson (Giorgetta) in Il tabarro, Regina Opera, 2023. Photo: Steven Pisano."
related_articles = []
related_companies = []
related_people = []
short_description = "To this reviewer, Il Tabarro most certainly sounds like a Puccini opera – right from the opening chords which become a recurring motif – and there are several stand-alone solos that aren’t as famous as those from his other operas, but in the hands (or throat) of the right performer they can stop the show."
slug = "il-trittico-slices-of-puccini"
title = "Il trittico: slices of Puccini"
youtube_url = ""

+++
It's a well-known fact that opera is an expensive endeavor – both for production companies and, often, for audiences. And it's also a given that there are fewer and fewer dollars supporting the arts in general. But there are small companies out there that manage to be great music-makers on mini- and micro-budgets. Such is the case with [Regina Opera](http://www.reginaopera.org/) and the [SAS Performing Arts Company](https://www.sasperformingarts.com/) in New York City.

Puccini wrote three one-act operas (_Il trittico_) to be performed as one program. He was quite vehement that they should not be split up, but they do work on their own, and doing only one in these lean times offers a chance for companies with stretched resources to present a full cast or full orchestra or both.

Regina Opera, which produced full productions of two Menotti one-acts ([see review here](/calls-from-two-worlds/)) has chosen to do the same thing with one slice of the Puccini triptych - _Il tabarro_ - and the company continues to impress.

When Puccini's _Il tabarro_ debuted at the Met in 1918 it was criticized for not being very "Puccini-like," and indeed you won't find any of his "greatest hits" here. In his final four operas (of which _Il trittico_ is second to last) Puccini was trying to move away from the lush Romantic music of his greatest works such as _La bohème_ and _Madama Butterfly_, and he was writing more complex music, fully integrated into the text à-la-Wagner. But he couldn't help himself in these late compositions, and he wound up writing some of his most beautiful stand-alone arias: "O mio babbino caro" from _Gianni Schicchi_, "Chi il bel sogno di Doretta" from _La rondine_, "Nessun dorma" from _Turandot_, etc.

To this reviewer, _Il tabarro_ most certainly sounds like a Puccini opera – right from the opening chords which become a recurring motif – and there are several stand-alone solos that aren't as famous as those from his other operas, but in the hands (or throat) of the right performer they can stop the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679002683/media/2023/03/Il_tabarro-ReginaOpera_20230305-DSC09408_y4fpjc.jpg){{% /md %}}

<figcaption>Daewon Seo (Michele) and Peter Hakjoon Kim (Luigi) in Il tabarro, Regina Opera, 2023. Photo: Steven Pisano.</figcaption>  
</figure>

The story of _Il tabarro_ is a familiar love-triangle – unhappy wife (Giorgetta) finds young lover (Luigi) and enrages her jealous husband (Michele). The action takes place on a houseboat docked on the river Seine. Michele and Giorgetta own the boat, while Luigi and others are struggling sailors or the poor denizens of the small port. All of the characters are intimately drawn and we get to know their very individual personalities and dreams even though the opera runs less than an hour.

Luigi (tenor Peter Hakjoon Kim) tells us that he is being worked to death and we feel his agonized frustrations in a stirring rendition of "Hai ben agione." Equally frustrated, but by love rather than labor is Michele (baritone Daewon Seo) who builds to a convincing, visceral madness in "Nulla…silenzio." Both Mr. Hakjoon Kim and Mr. Seo have superlative performance skills as do their fellow mariners Hyong Sik Jo (as Il Talpa) and Adam Inyong Goldstein (as Il Tinca.) Josh Avant, with his sparkling tenor, makes the most of his brief and amusing appearance as the Song seller. Also offering some comic relief to librettist Giuseppe Adami's dark story, is mezzo Galina Ivannikova (as La Frugola, the rag-picker), who delivers a silly staccato aria about her wares. Unfortunately, we don’t get the lusty passion from Giorgetta, as soprano Gillian Watson offers us her pretty voice but seems to be holding back physically and spends most of her performance with her hands clasped in front of or behind her body.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679002706/media/2023/03/Il_tabarro_ReginaOpera_20230305-DSC09172_ezopqm.jpg){{% /md %}}

<figcaption>Peter Hakjoon Kim (Luigi) and Gillian Watson (Giorgetta) in Il tabarro, Regina Opera, 2023. Photo: Steven Pisano.</figcaption>  
</figure>

There are only four men listed as ensemble members and one wonders if some of the principals were doubling when they were backstage, because the men's chorus managed to make a rich and resonant noise from the wings, sounding well beyond their numbers.

Super-pro Gregory Ortega led a flawless 31-piece orchestra, which is always one of the highlights at Regina Opera.

In these difficult economic times, Regina Opera's decision to hire this level of professionalism (both on stage and in the pit) is a welcome joy. Now if they could just figure out how to pay for a set that doesn't look like the reject from a Vaudeville stage (or a middle school musical) the show would be complete.

***

SAS Performing Arts Company has no such problem with a set because they only use a set of music stands. And music director Stephen Scovasso has choreographed his singers to smoothly raise or lower the stands as they stand or sit, so the stands become part of action and, therefore, virtually disappear.

No set is needed when you have singers of this caliber. Neither is an orchestra needed – the three different pianists (Susan Morton, Jonathan Parks and David Fraley,) who played on each of the three _Il trittico_ operas proved to be perfect "one-person bands."

Mr. Scovasso decided to bite into the entire _Trittico_ sandwich – the curtain-raising _Il tabarro_, the big finale of _Gianni Schicchi_ and the squishy center of _Suor Angelica_.

> The venerable Tichina Vaughn is not only a welcome presence, as she was in _Il tabarro_ but also a welcome relief. Her sternum-shaking denunciation sets the stage for what is supposed to be the devastating "Senza Mamma".

He offered a synopsis before each opera and also some interesting back stories. (His curtain speeches were informative as was the lengthy, detailed program.) He shared with his audience his take on what Puccini was up to, writing the three operas in three completely different styles, each a tribute to a popular form of Italian opera. _Il tabarro_ is the composer's nod to the _verismo_ school, which he himself was part of but not married to. _Suor Angelica_ is an _opera seria_ written in a romantic form and _Gianni Schicchi_ is _opera buffa_. Mr. Scovasso informed us that Puccini was saying farewell to all three forms as he headed for other musical horizons. (Where he was going was cut short; his next work proved to be his last – the mostly-finished but unfinished _Turandot_.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679148323/media/2023/03/SAS_Performing_Arts_Il_Tabarro_1_bp5bxf.jpg){{% /md %}}

<figcaption>SAS performing Arts Concert Opera's production of Il Trittico, 2023.</figcaption>  
</figure>

Mr. Scovasso revealed that this was a Herculean endeavor for SAS with only seven days of rehearsal.

It did not sound like it, and the seven days resulted in – for the most part - over three hours of superlative music.

For _Il tabarro_, a star was born and two other established celestial bodies made a reappearance. Young tenor Samuel White (as Luigi) sounded like a young Domingo for the entirety of the opera, but particularly on "Hai ben agione." The intimacy of the St. Stephen's church and the timidity of the audience – perhaps because it was a concert format? – robbed Mr. White of what would have been a long, thunderous ovation in any other venue. He is off to work at Santa Fe Opera this summer and this reviewer believes that this is the nebula of a great career.

Veteran baritone Geoffrey Di Giorgio commanded the stage as Michele and the wooden rafters literally resonated (it's that kind of church) with his "Nulla…silenzio." You also can't take your eyes off of him when he's at his perch, because he continues to stay in character – pained, thinking, seething.

Mezzo Tichina Vaughn, another veteran vocalist, who recently appeared in three roles at the Met, made La Frugola's difficult rapid-fire aria look easy. It's no wonder that SAS has Ms. Vaughn teach master classes to other members of the company.

> His switch back and forth from deep baritone (as Gianni Schicchi) to his grating falsetto (when he imitates the dead Donati) was uproarious.

Soprano Rebecca S. Kidnie was an effective Giorgetta, using all her tools – voice, face, body - to express the character’s internal pain. Kudos to all the singers who were truly acting and never appeared to be “stuck” behind their scores.

Mr. Scovasso described Gianni Schicchi as the most difficult portion of _Il trittico_ but _Suor Angelica_ proves to be the most difficult for the audience. One of the few all-female operas, _Suor Angelica_ takes place in a convent and most of the action (or lack thereof) can only be described as a prolonged "How Do You Solve a Problem Like Maria?" We learn a little about each sister, and individually, the singers have nice moments, most notably Rebecca Grady Rucker as the First Novice and Shanley Horvitz as The Monitor. (Unfortunately, the unison singing by all the nuns is never exactly right.) We learn that Suor Angelica has a big secret, but it's all an endurance test until La Zia Principessa (her aunt) arrives and the drama begins. The venerable Tichina Vaughn is not only a welcome presence, as she was in _Il tabarro_ but also a welcome relief. Her sternum-shaking denunciation sets the stage for what is supposed to be the devastating "Senza Mamma," where Suor Angelica mourns the short life of her illegitimate child whom she never got to know. Rebecca S. Kidnie, in the title role here, did not display the subtlety she found in _Il tabarro_, and works a little too hard - we feel more like she's climbing Mount Everest then reaching out to the Virgin Mary.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679148374/media/2023/03/SAS_Performing_Arts_Gianni_Schicchi_eotuqj.jpg){{% /md %}}

<figcaption>SAS performing Arts Concert Opera production of Il Trittico, 2023.</figcaption>  
</figure>

It was all worth the wait for the third and final slice of Puccini, _Gianni Schicchi_. There is nothing un-funnier sometimes than so-called "comic opera" but _Gianni Schicchi_ is truly hilarious. Puccini's only foray into funny, it's a well-crafted farce with a number of good roles and a surprising twist. It’s the story of the self-centered members of the Donati family (think of the Roy Family in _Succession_ set to music). Buoso Donati has died, and all his relatives have gathered for some fake mourning and, they hope, some real monetary gain. They're all angling to get a piece of Donati's greatest assets – "the mule, the house and the mills" – but they don't know what's in Donati's will. They've heard that he’s leaving all his money to a monastery and so they frantically search for the will to find out if the rumor is true. (What is normally a riotous staging at this point in the plot, was effectively conveyed by the SAS company at their music stands just using some prop papers.)

When they find the scroll with the bad news, they turn to Gianni Schicchi for help. Geoffrey Di Giorgio, who had a good rest outside the convent during _Suor Angelica_, is wildly entertaining as he lets it rip vocally and comically. His switch back and forth from deep baritone (as Gianni Schicchi) to his grating falsetto (when he imitates the dead Donati) was uproarious. He also was able to play the buffoonery of the man when we first meet him, and then adroitly show us the slow reveal of what was waiting underneath it all – much to the chagrin of the double-crossed Donati family.

Mr. Scovasso announced before the first opera that "O mio babbino caro" would happen around 5:30 because "that's what you're all waiting for." It was more like 6:00 p.m. but Juyong Ma (as Lauretta) gave us a pleasant rendition. Other members of the family who shined were Virdell Williams as Simone (who also was great as Il Talpa in _Il tabarro_), Shanley Horvitz as Zita, and tenor Eric Sebek as Rinuccio who nailed the heraldic declarations of "Firenze e come un albero fiorito."

Even with libretti and Mr. Scovasso's summations, SRS could really benefit from an investment in supertitles. The wacky twists and turns of _Gianni Schicchi_, in particular, get lost in translation, no matter how hard the talented group works to interpret it all for us.