+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = 2019-11-17T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Virginia Opera's production of [_Il Postino_](https://vaopera.org/experience/il-postino/) has performances in Richmond, VA, [Nov 22-24](https://www.etix.com/ticket/v/8084/virginia-opera-dominion-energy-center-carpenter-theatre?performance_id=3281149&country=US&language=en)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574135863/media/2019/11/sqVAOperaIlPostino-5177_ndcnc1.jpg"
primary_image_credit = "Daniel Montenegro (Mario) in Il Postino, Virginia Opera, 2019. Ben Schill Photography courtesy of Virginia Opera."
related_articles = []
related_companies = ["scene/companies/virginia-opera.md"]
related_people = []
short_description = "It's a sour and tragic ending for an otherwise delightful love story. Moreover, the political subplot of the opera has a vagueness to it that leaves you wondering what its point of view is."
slug = "grand-opera-cloudy-politics-in-il-postino"
title = "Grand opera & cloudy politics in Il Postino"
youtube_url = ""

+++
As a writer, I'm all too familiar with the struggle to find exactly the right words to express what I'm thinking, or feeling. Was that soprano's voice "crystalline," or "silvery," or "bell-like?" Is this melody "haunting," or is it "dreamlike?" If only I had my own master poet mentor to guide me to just the right metaphors to express myself the way that Pablo Neruda guides his earnest young postman, Mario, and shows him how using words to explore the nature of a thing, be it the sea, the stars, or the woman you love, can make you see it and understand it more clearly.

Having premiered at LA Opera in 2010, [_Il Postino_](https://vaopera.org/experience/il-postino/) is still in its operatic infancy, but fans of the 1994 film will find it pleasantly familiar, if a bit awkwardly paced in its drama. Daniel Catán, who composed his own libretto for his third opera, made the obvious but very wise choice to pepper the text liberally with the words of the Nobel Prize-winning Chilean poet who is central to the story.

> Their voices wind around each other, climbing ever higher in a Straussian climax.

Indeed, the highlights of Catán's score are those arias and duets which consist entirely of Neruda's poems set lavishly by the Mexican composer, most notably in Neruda's first aria, a setting of the poem "Desnuda," sung lustily and full throatedly by tenor Raúl Melo (in spite of the fact that he was under the weather Saturday evening, as noted in the curtain speech) which is the first of many times throughout the opera where the orchestration swirls and churns and rises to the heights of the Grandest of Grand Opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574136735/media/2019/11/VAOperaIlPostino-0137_n4xpp4.jpg){{% /md %}}

<figcaption>Daniel Montenegro (Mario) in Il Postino, Virginia Opera, 2019. Ben Schill Photography courtesy of Virginia Opera.</figcaption>  
</figure>

A less obvious, but equally wise choice made by the composer is to cast his two leading roles, Neruda, and the titular Postman, as tenors. The effect, emphasized by the similarity in timbre of Melo's voice as Neruda and that of Daniel Montenegro in the role of Mario, is one of a man and his clone. Montenegro's voice is a slightly brighter, slightly more youthful version of Melo's. In their sublime Act I duet, where Neruda is teaching Mario the power of metaphor, their voices wind around each other, climbing ever higher in a Straussian climax.

The role of Mario's love interest, Beatrice, is masterfully sung by soprano Danielle Talamantes. She is in fine voice, and the role sits perfectly in her vocal sweet spot, gleaming and soaring - not a single sound escapes her throat which isn't beautiful. Her singing is perfect, and it allows the audience to see her as Mario does, as an idealized woman, at once beautiful, kind, and virtuous.

> The role sits perfectly in her vocal sweet spot, gleaming and soaring - not a single sound escapes her throat which isn't beautiful.

This brings me around to the treatment of women in Catán's opera. They are alternately objects of affection and sources of comfort for the men, as is the case with Beatrice and Neruda's wife, Matilde (sung thinly and with some strain in the voice by soprano Inna Dukach). Or they're a nagging killjoy, as exemplified by Beatrice's overprotective mother Donna Rosa, sung by mezzo soprano Dana Beth Miller, whose magnificent, Wagner-sized voice is wasted on this manic caricature of a virginity-obsessed Catholic nanna.

Are these kinds of tropes really acceptable in a theatrical work which premiered within the last decade? Donna Rosa especially, whose antics find her knocking on Neruda's door, comically wielding a shotgun, and raving that her daughter's mind has been "poisoned by poetry!" - all played for laughs - feel garishly out of place in this lyrical romance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574136785/media/2019/11/VAOperaIlPostino-0483_ophosy.jpg){{% /md %}}

<figcaption>Il Postino, Virginia Opera, 2019. Ben Schill Photography courtesy of Virginia Opera.</figcaption>  
</figure>

The staging is embellished with three additional women, appearing first during Beatrice's first aria, who move silently about the set, weaving in and out of the (all-male) chorus, their movements often follow the steps of a sensual tango, and as the opera goes on their purpose becomes increasingly unclear. Are they lines of poetry? Or perhaps muses to inspire the young postman? Are they the spirits of his island home?

Only later after leaving the theater did I find an explanation in Director Crystal Manich's program notes that they are meant to represent "the emotional awakening of female desire." It seems that this staging decision was Manich's attempt to resolve the opera's woman problem, which, however well-intentioned, just didn't work.

What did work was the production design, centered on an enormous, revolving, spiral staircase to create a graphic impression of a mediterranean cliffside emerging from the sea. Projections are used to wondrous effect to show Neruda's handwriting scrawling across the backdrop as he sings. A bicycle is situated downstage, and when Mario jumps on it and begins furiously pedalling, he stays in place while the set rotates to give the impression that he is traversing the island to consult with his mentor or to woo his Beatrice with a poem.

> Is Mario's death a heroic martyrdom, or a senseless tragedy?

Of course, Mario gets the girl and in the finale to the second act, they marry as Neruda receives a telegram to notify him that the Chilean government has changed hands and he is free to return to his home country from which he had been exiled for his communist politics.

What follows in the third act is more epilogue than story conclusion, and feels superfluous to the overall plot. Neruda leaves the island and is absent several years, and Mario misses his old friend, while becoming active in communist politics locally. Finally Neruda returns to find Beatrice alone with her son "Pablito," and she sings a glorious aria telling the poet the story of how Mario was killed when he was invited to read one of his own poems at a communist rally which turned violent.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574136868/media/2019/11/VAOperaIlPostino-5765_bm88d5.jpg){{% /md %}}

<figcaption>Inna Dukach (Matilde Neruda) and Raúl Melo (Pablo Neruda) in Il Postino, Virginia Opera, 2019. Ben Schill Photography courtesy of Virginia Opera.</figcaption>  
</figure>

It's a sour and tragic ending for an otherwise delightful love story. Moreover, the political subplot of the opera has a vagueness to it that leaves you wondering what its point of view is. Neruda speaks of fighting for justice and the common man, while a local politician Di Cosimo (sung admirably by baritone Efraín Solís) of the Christian Democrat party is portrayed as a villain who fails to fulfill the promise of providing running water to the island, and Mario is sneered at by Di Cosimo's followers for being a "Communista."

But the libretto fails to interrogate the politics more deeply than that. Is Mario's death a heroic martyrdom, or a senseless tragedy? Is this opera pro-communist or just pro-Neruda? The libretto, and Manich's staging, leave it unclear.