+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2019-04-05T16:14:46+00:00"
disclaimer = ""
image_gallery = []
postamble = "Opera Atelier's production of _Idomeneo_ runs at the Ed Mirvish Theatre through April 13. For details and ticket information, [click here](https://www.operaatelier.com/idomeneo)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554486385/media/2019/04/sqOAIdomeneo-DouglasWilliams-BruceZinger.jpg"
primary_image_credit = "Douglas Williams as Neptune in Opera Atelier's production of Idomeneo, 2019. Photo: Bruce Zinger."
related_articles = ["articles/a-daring-desirous-doublebill-at-opera-atelier.md", "articles/glamour-fury-idomeneo-in-chicago.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/measha-brueggergosman.md", "scene/people/wallis-giunta.md", "scene/people/meghan-lindsay.md", "scene/people/colin-ainsworth.md"]
short_description = "The end result of all these disconnects: it was difficult to care about the people in this opera. There seemed too little trust placed in Mozart to help us emote alongside his characters, instead encumbered by a style that seems to dig in its heels against the piece itself."
slug = "beautiful-people-vague-torment-idomeneo"
title = "Beautiful people & vague torment: Idomeneo"
youtube_url = ""

+++
I figure Mozart's _Idomeneo_, his 1780 _opera seria_ rooted in Greek mythology, is one of those operas that make directors skittish. _Idomeneo_, filled with mature, breathtaking music, can so easily keep an audience at arm's length. Much of the opera is a string of substantial arias, a form that seems slightly archaic in the hands of Mozart, which continuously puts the plot on pause.

If you're not up on your Greek/Trojan history, there's little to save you in the pages of Mozart's score. We are not introduced to these characters - rather, dropped into a window in the lives of large mythological figures, with personal histories that are assumed to be familiar. That assumption was likely a stretch in the 18th century, let alone today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554486532/media/2019/04/OAIdomeneo-ColinAinsworth-BruceZinger.jpg){{% /md %}}

<figcaption>Colin Ainsworth as Idomeneo in Opera Atelier's production of Idomeneo, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

My curiosity was piqued for this revival of Opera Atelier's production of _Idomeneo_, first put up in 2008. Mozart is on the late end of the 17th- and 18th-century works that are Atelier's focus, making it an interesting test of the tried-and-true aesthetic of Co-Artistic Directors Marshall Pynkoski and Jeannette Lajeunesse Zingg.

"There's a serious storm brewing," said Pynkoski in his pre-show audience address, "and I predict major turbulence ahead." He was referring to the the storm that the sea god Neptune churns up, hurling Idomeneo and his sailors onto the shores of Crete. But there was turbulence too, as this production resounded into the Ed Mirvish Theatre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554486562/media/2019/04/OAIdomeneo-GiuntaLindsay-BruceZinger.jpg){{% /md %}}

<figcaption>Wallis Giunta as Idamante and Meghan Lindsay as Ilia in Opera Atelier's production of Idomeneo, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

If turbulence is too exaggerated at term, perhaps one could instead say that there was disconnect in this production. The singing was a veritable mixed bag. [Meghan Lindsay](/scene/people/meghan-lindsay/) sounded her best yet as Ilia, sending gathered, rich sounds out into the hall; [Wallis Giunta](/scene/people/wallis-giunta/) was an athletic Idamante, her physicality dominating her singing, and at times keeping her from finding her most grounded sound; [Colin Ainsworth](/scene/people/colin-ainsworth/) is an open, honest Idomeneo, almost bordering on wild.

>More than beautiful people or stylistic precision, I instead craved some hints of real humanity.

And [Measha Brueggergosman](/scene/people/measha-brueggergosman/) as Elettra, the literal poster child for this production, seemed to pair lovely, inspired moments of singing with a few pervasive rookie mistakes. She stood out onstage, moving heavily and without the taut precision of everyone else onstage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554486592/media/2019/04/OAIdomeneo-MeashaBrueggergosman-BruceZinger.jpg){{% /md %}}

<figcaption>Measha Brueggergosman as Elettra in Opera Atelier's production of Idomeneo, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

There was disconnect in the production, too, flashes of elements that run parallel instead of together. There was random sexiness - nearly nude, heaving male forms, breathless bosoms in corsets, Giunta's signature long red hair flowing freely as Idamante - that seemed like toppings rather than substance. There was the use of [rhetorical gesture](https://en.wikipedia.org/wiki/Chironomia) - one of the most notorious through-lines  of Opera Atelier's productions - which is meant to tell and enhance a story; in this _Idomeneo_, the gestures seemed particularly canned, belittling the emotional crises and bleeding into similarly meaningless wanderings across the stage - denoting general torment, I gather.

>There seemed too little trust placed in Mozart to help us emote alongside his characters.

More than beautiful people or stylistic precision, I instead craved some hints of real humanity in these archetypal figures. Once-removed as they seem from their places in history books, there are still traits of mere mortals to pull out of these characters. Idomeneo is a parent, Idamante and Ilia are young and in love, and Elettra is rejected; if these aren't universal qualities, I'm not sure what is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554486616/media/2019/04/OAIdomeneo-DouglasWilliams-BruceZinger.jpg){{% /md %}}

<figcaption>Douglas Williams as Neptune in Opera Atelier's production of Idomeneo, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

The end result of all these disconnects: it was difficult to care about the people in this opera. There seemed too little trust placed in Mozart to help us emote alongside his characters, instead encumbered by a style that seems to dig in its heels against the piece itself.

What makes it a worthy night out: Meghan Lindsay's stunning Ilia, and the climactic moment in Act III as the panting, well-formed Neptune (bass-baritone [Douglas Williams](/scene/people/douglas-williams/)) strode downstage and sang his small-but-mighty phrases with a gorgeous, reedy sound. To quote my seat neighbour upon hearing Williams: "It sings!"