+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2018-11-21T10:41:00-05:00"
lastmod = "2018-11-21T10:41:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814650600/sq181112_0366CarlosA%CC%81lvarezasSimonBoccanegraROH2018.jpg.jpg"
primary_image_credit = "Carlos Álvarez as Simon Boccanegra in Simon Boccanegra, Royal Opera House, 2018. Photo: Clive Barda."
publishDate = "2018-11-21T10:41:00-05:00"
related_companies = ["scene/companies/royal-opera-house.md"]
short_description = "But I was completely captivated by Ferruccio Furlanetto&#039;s Fiesco. He was the aged, revenge-hungry villain whilst still being able to inspire pity. And though it was a voice approaching the end of a long career, he had such a commanding and assured presence on stage that one couldn&#039;t help but be carried along with him."
slug = "idealistic-lavish-simon-boccanegra-at-roh"
title = "Idealistic &amp; lavish: Simon Boccanegra at ROH"
+++

I have a confession to make: I enjoy a good remount. And it was this revival of Elijah Moshinsky's 1991 production of *Simon Boccanegra* that convinced me of it. As someone who often goes into a Verdi opera with a slight sense of trepidation (no, he's not my favourite composer), I have to admit, I was completely taken with it. From the very opening of the prologue the scale of this piece is definitively established. 

Michael Yeargan's Genoese courtyard set looms large. Massive columns flank the far right side, bringing a sense of depth to the stage and beyond them, the purple-blue light of early morning reflected on the mountains of the rolling countryside. Every moment of this production made me feel as though I was looking at a Renaissance painting brought to life. Raphael's *School of Athens* comes to mind with the play of perspective, the imposing architecture, and the richness in colour and texture of the fabrics. There is a comforting sense of familiarity about recognising immediately where and when you are in history. This production expertly created a complete image of 16th-century life in the north of Italy and, I imagine, was also a nod to the 1881 premiere at La Scala in Verdi's time which would have looked quite similar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814670223/181112_0072SimonBoccanegraProductionImageROH2018.jpg.jpg)
<figcaption>A scene from *Simon Boccanegra*, Royal Opera House, 2018. Photo: Clive Barda.</figcaption>
</figure>

I particularly liked the way the music and this visual spectacle on stage lent themselves to each other. Verdi's operas tend to carry a certain amount of weight and this was honoured by the towering expansive set. What was clever about this set was its ability to draw me into the sound world Verdi created. He was quoted to have been inspired by the sea when writing the opera with a view from his apartment window of the Genoa harbour below, and elements of this can certainly be heard in the score. It is sometimes light and playful before suddenly crescendoing to an absolute swell that wave-like, comes crashing over you. I particularly enjoyed the sensitivity with which the orchestra played the transitional music from the prologue into act one; shimmering and crystalline it evoked a calm, morning sea and the heart wrenching passing of time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814710166/181112_007HrachuhiBassenzasAmeliaGrimaldiROH2018.jpg.jpg)
<figcaption>Hrachuhi Bassenz as Amelia Grimaldi in *Simon Boccanegra*, Royal Opera House, 2018. Photo: Clive Barda.</figcaption>
</figure>

This production also featured some of the most robust and healthy singing I've heard in a long time. Carlos Álvarez carried the show as Simon Boccanegra. With his warm, dark baritone he soared over the dense orchestration, and built a thoughtful and engaging story arch throughout. Armenian soprano Hrachuhi Bassenz sang a beautiful Amelia. Sometimes light and fleeting, sometimes stormy and authoritative, it was proud and graceful performance filled with emotion. Tenor Francesco Meli's strident Adorno seemed to have more raw power of sound than he knew what to do with. Though it wasn't the most refined singing on that stage, I eventually warmed to him particularly in his beautiful, emotionally fraught act two aria.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814734274/181112_0354A%CC%81lvarezasBoccanegraBassenzasAmeliaROH2018.jpg.jpg)
<figcaption>Carlos Álvarez as Boccanegra in *Simon Boccanegra*, Royal Opera House, 2018. Photo: Clive Barda.</figcaption>
</figure>

But I was completely captivated by Ferruccio Furlanetto's Fiesco. He was the aged, revenge-hungry villain whilst still being able to inspire pity. And though it was a voice approaching the end of a long career, he had such a commanding and assured presence on stage that one couldn't help but be carried along with him.

I was especially impressed with the naturalistic interaction and genuine chemistry between the singers. Moshinsky's staging was threadbare to say the least. This allowed for the drama to be in the music and in the intensity of emotion in the singing. There was quite a lot of focused stillness from the singers but in crucial moments of interaction, the chemistry was quite electric. This served as an important reminder to me that sometimes simply feeling and expressing the emotion of the music with intention is captivating enough as it is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814749270/181112_0432FurlanettoasFiescoRuckerasPaoloROH2018.jpg.jpg)
<figcaption>Ferruccio Furlanetto as Fiesco and Mark Rucker as Paolo in *Simon Boccanegra*, Royal Opera House, 2018. Photo: Clive Barda.</figcaption>
</figure>

It is through this interaction that the heart of the piece shone through. This is a work about relationships. One could say Verdi wrote his own suffering into the music of this opera, having lost and infant daughter and wife. This heartfelt message of unconditional familial love is shown in relationship between father and daughter, father and son, and most touchingly, through the characters of Boccanegra and Fiesco. The two characters who begin as bitter enemies, share a tender moment of reconciliation over their love for Amelia. How interesting for the central love story of an opera to in the end not be about the two young lovers but between two old rivals who part as friends. And in a piece that could have ended in so much death and violence, in the final moments there is only reconciliation and love.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542814757759/181112_0146CarlosA%CC%81lvarezasSimonBoccanegraROH2018.jpg.jpg)
<figcaption>Carlos Álvarez as Simon Boccanegra in *Simon Boccanegra*, Royal Opera House, 2018. Photo: Clive Barda.</figcaption>
</figure>

Moshinsky's vintage production offered no true innovation. It was inoffensive and ruffled no feathers but it remains a classic for a reason; it offers an accessible, lavish, idealistic dream of what opera can be. This *Simon Boccanegra* was a gilded portrait of Renaissance life and ideals with larger than life characters who allow their passions to control their actions. It was opera turned up to an eleven. And who doesn't need a bit of that every now and then?

>The Royal Opera's production of *Simon Boccanegra* runs through December 10. For details and tickets, [click here.](https://www.roh.org.uk/productions/simon-boccanegra-by-elijah-moshinsky)
