+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-07-22T13:08:00-04:00"
lastmod = "2015-07-24T08:11:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437699999002/elephants.jpg.jpg"
publishDate = "2015-07-24T08:00:00-04:00"
related_articles = ["articles/what-comes-first-the-union-or-the-gig.md","articles/mutiny-at-the-met.md","articles/curiosity-and-the-met.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/canadian-opera-company.md","scene/companies/calgary-opera.md","scene/companies/vancouver-opera.md","scene/companies/edmonton-opera.md","scene/companies/opera-atelier.md","scene/companies/manitoba-opera.md","scene/companies/pacific-opera-victoria.md"]
short_description = "I&#039;ll never be quoted as saying that artists deserve to be paid less than they already do. They work incredibly hard in a specialized set of skills. I think it&#039;s important, though, to be self-aware in an industry that&#039;s ubiquitously almost out of money. Will the unions be the first to adapt to a contemporary opera economy, or should contemporary artists be the ones to take the bold steps for the sake of the industry (perhaps martyring themselves along the way)?"
slug = "idealism-questions-unions"
title = "Idealism &amp; questions about unions"
+++

About a year ago, when the Metropolitan Opera was in the middle of [nightmarish talks](http://www.wsj.com/articles/metropolitan-opera-general-manager-peter-gelb-warns-union-employees-of-august-1-of-lockout-1406144068) with its unions, spurred on by a proposed 17% wage cut for its artists (click [here](http://parterre.com/wp-content/uploads/2014/08/met-agma_memo_agreement.pdf) to read the final agreement between the American Guild of Musical Artists and The Metropolitan Opera, courtesy of [Parterre](http://parterre.com/)). 

At first, my ears perked up at the thought of artists taking a stand against agreement changes that could impact their livelihoods. The threat of a lockout (and no 2014/15 Met season) raised questions of how companies should be spending money. Members of the Met's artist unions took it upon themselves to provide [evidence](http://www.local802afm.org/MetMusicians/2014-07-25_802-Presentation_Gelb.pdf) of the Met's overspending on productions; on the other hand, a look into the union agreements (existing and potential) made me ask, "can opera companies really afford union artists?"

In Toronto alone, there are opera companies or large and small stature; since the Canadian Actor's Equity Association ensures for its artists, among plenty of things, minimum fees, it's no wonder that the proportion of Equity artists is directly related to the opera company's production budget. Small, independent companies will hire a mix of Equity and non-Equity artists, marrying their budgetary limitations with the decidedly stronger calibre of singing found in singers with union status.

At companies that hire this kind of mix of pros and "non-pros," the difference in fee structures can be pretty vast; a non-professional could easily earn half or even a quarter of what an Equity artist makes. It makes me think that there are two possible conclusions: either unions like Equity and AGMA and IATSE really are the only thing standing in the way of artists getting screwed over by their employers, or the structure of these union agreements are an unproportional strain on the realistic economy of the arts.

### Naïve questions

I've struggled with writing about this topic because I'm not a) a member of CAEA, or b) a lawyer. After reading several union agreements for opera & theatre, all I've really come up with are questions. They may be naïve questions, so please bear with me (or post your responses in the comment section).

- Is a union agreement the only thing holding arts employers back from maltreatment of its artists?

2. What if the next 10 years of young opera singers never joined a union?

3. Why are there clauses in IATSE unions that require time-and-a-half or double-time pay after midnight or on Sundays, when these are workers in the entertainment industry? 

4. Why is time infringement for AGMA and CAEA members not sympathetic to the varying length of different operas (Wagner, etc.)?

5. Why are minimum fees in the CAEA agreements rising generally with inflation, when the literal number of places to work in Canada is shrinking? Are these fees not meant to be representative of a realistic working environment for an entire industry of artists? 

6. Could CAEA regulations be instead a good guideline for gig-specific contracts between the artists and the employer? Could similar health & insurance benefits be a part of these contracts?

I'll touch on all of these *naïvetés*, but I'm mostly interested in the answer to #3. Right now, Equity status in Canada is a pretty good way to pigeon-hole someone's skill; in a chicken-and-egg sort of cycle, a singer with an Equity card suggests they're "better" than one who's non-Equity. No wonder this is the case; the singers you really want to hire have all joined a union because they've got the skills to make them busy enough for the annual union dues to be "worth" the benefits.

### A call for martyrs?

But really, what if the top 50 working singers in Canada left Equity next season? Would they get hired as frequently as before? Would companies like the COC be legally allowed to hire a full cast of professional-level, yet non-Equity singers? If these singers are already established, no one could claim that their non-Equity status is because they're not good enough to work. Could this be a way to squash the argument that Equity status = real artist status?

So, say these artists still get hired as frequently as when they were an Equity member. Would they get gouged with overtime and less pay? Again, established singers would have a history of fee structures, and they'd be free negotiate their pay; but would the companies respect it? With a private contract, would the company be willing to rival an Equity fee for an artist, for the luxury of less-strict hours, and less costly overtime/infringement/extra-whatever pay, etc.? Without union protection, would legal battles between artists and employers be a sad mess of no-money-to-sue-for-my-money?

### The role of the employer

Companies aren't obligated to hire only Equity artists, but often non-Equity artists need to be approved by Equity, and in some cases, there's an extra fee (or the cost of a permit) required for the hiring of a non-union artist (payable to Equity). Here's a quick list of links if you're interested in the details:

- [2013-2016 Canadian Opera Agreement, between CAEA and the Canadian Opera Company](http://www.caea.com/EquityWeb/EquityLibrary/Agreements/Opera/COA/COA.pdf)
- [2013-2016 Opera Agreement, between CAEA and Calgary Opera, Edmonton Opera, Manitoba Opera, Opera Atelier, Pacific Opera Victoria](http://www.caea.com/EquityWeb/EquityLibrary/Agreements/Opera/OPA/OPA.pdf)
- [2010-2013 Opera Agreement, between CAEA and Independent Opera Producers](http://caea.com/EquityWeb/EquityLibrary/Agreements/Opera/IOPA/IOPASearchable.pdf)

I'll never be quoted as saying that artists deserve to be paid less than they already do. They work incredibly hard in a specialized set of skills. I think it's important, though, to be self-aware in an industry that's ubiquitously almost out of money. So, perhaps it comes down to a more important question: will the unions be the first to adapt to a contemporary opera economy, or should contemporary artists be the ones to take the bold steps for the sake of the industry (perhaps martyring themselves along the way)?

If artists take 80% of their usual fee, will that balance out the fact that opera is generally expensive to produce? Will this create more places for artists to work, or will it just mean everyone makes less money? Are artists today willing to try an experiment by working without a union, risking monetary loss and no legal protection beyond their contract with the company? How long would it take before contracts were the "new union"? Would health benefits ever make it into short-term contracts for artists? More naïvetés, I feel.

### Inconclusive

I don't actually want singers to leave their union; the protection of Equity, etc., are a source of security in an insecure industry. It's not worth it at all to lose one's health benefits or insurance over my imaginings about unions. My last question: is it the responsibility of arts unions to adapt to the industry's changing economy? Unions are a business of their own, and they don't necessarily owe anything to "The Industry." Yet, if it's difficult for an artist to get a decent amount of work, especially as a pricey Equity member, how long will it be before a majority doesn't find the annual union dues worth the benefits of joining? Will Equity adapt its fee structure then, when they're running lower on revenue, and will that be good or bad for artists? 

> This is no small issue, of course, and I'm genuinely interested in hearing your insight and responses to perhaps some idealistic questions. Use the comment section below to pose your thoughts.


