+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-11T09:50:00+01:00"
lastmod = "2016-04-11T11:25:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460366000491/2016-04-11---rsz_ml_rosenblatt_0013.jpg.jpg"
publishDate = "2016-04-11T11:05:00+01:00"
related_articles = ["articles/in-review-juan-diego-florezs-rosenblatt-recital.md","articles/in-review-sondra-radvanovsky-at-koerner-hall.md","articles/in-review-paul-appleby-at-wigmore-hall.md","articles/in-review-javier-camarena-at-wigmore-hall.md","articles/in-review-alek-shrader-at-wigmore-hall.md","articles/in-review-la-colla-katzarava-in-recital.md","articles/dont-miss-radvanovsky-in-recital-at-cadogan-hall.md"]
related_people = ["scene/people/javier-camarena.md"]
short_description = "Out of his recital series have come several close relationships with the singers. &quot;I spend a lot of time with all the artists. A number of them have become friends.&quot; Often the singers stay at with him while they&#039;re in town for a recital, or they&#039;ll use his piano to rehearse. &quot;There&#039;s nothing like having the second act of Bohème being sung to you in the kitchen while you&#039;re cooking.&quot;"
slug = "ian-rosenblatt-its-all-about-the-voice"
title = "Ian Rosenblatt: &quot;It&#039;s all about the voice.&quot;"
+++

"I come from a family that loved singers," says [Ian Rosenblatt](http://rosenblatt-law.co.uk/people/ian-rosenblatt/), founder of the [Rosenblatt Recitals](http://www.rosenblattrecitals.com/) series. "My father used to put on a record of *Traviata* every morning. He used to go to work very early in the morning, so 5:00 in the morning, the same record went on, which was [*La traviata*](http://www.amazon.co.uk/Verdi-La-Traviata-Giuseppe/dp/B00000I92Y) with Bergonzi, Sutherland, and Merrill." That's not a bad way to get exposed to top-notch singing at an early age, and Rosenblatt's love of voices has continued throughout his adult life.

Originally from Liverpool, Rosenblatt arrived in London to attend university; one of the first things he did in the city was to queue up for tickets to the Royal Opera. "You could get £1 tickets in the slips," he remembers. To go with his father's stellar choice of *La traviata* recordings, Rosenblatt had a great introduction to live opera on the big stage. "The first opera I saw there was *Un ballo in maschera* with Pavarotti."

## The recital series

Rosenblatt Recitals was officially established in 2000 with a [duo recital](http://www.rosenblattrecitals.com/archive_recitals.aspx?year=2000) by tenor José Cura and baritone Carlos Alvarez. Now, it's grown to between eight and ten concerts a year, and the series has been a common stop for some of today's most notable singers, including Javier Camarena, [Ailyn Pérez](/scene/people/ailyn-perez/), [Nicole Cabell](/talking-with-singers-nicole-cabell/), [Joseph Calleja](/scene/people/joseph-calleja/), and [Quinn Kelsey](/talking-with-singers-quinn-kelsey/). Star tenor [Juan Diego Flórez](/in-review-juan-diego-florezs-rosenblatt-recital/) has been a regular of the Rosenblatt series, starting with his 2001 recital with pianist Vincenzo Scalera. "Between 2001 and 2002, he became huge," says Rosenblatt. "So, literally a year later, we put him on at the Festival Hall with an orchestra, and sold out." The series is currently based primarily out of London's Wigmore Hall, but "occasionally we do the odd one-off," like Flórez's performances at the Royal Albert Hall, or Leo Nucci at Cadogan Hall in October 2015.

"A lot of people think that I'm only interested in tenors," laughs Rosenblatt, "but it's actually not true. My favourite voice is the baritone voice." Each year, he tries to populate the recital series with singers of every voice type. Yet he admits, "it doesn't always work out that way. Sometimes there tends to be a bias towards tenors rather than anything else, because there are more of them around." For Rosenblatt and the series' audience, these concerts are about showing off singers in a pure form. "But the reality is, that basses don't sell very much. It's hard to get an audience for a bass. It's much easier to get an audience for a tenor. It's easier to get an audience for a soprano than it is for a mezzo."

Rosenblatt is interested in providing "popular entertainment", and that comes with a keen awareness of what listeners want to hear. "If we try to put on a bass singing songs of love and death and mourning and God knows what by some Russian composer, we wouldn't have a big crowd. So, we need to have a few show-stoppers in there, for voice types that don't naturally sell very well." He agrees that repertoire is important, and it certainly helps when the artist has some notoreity of their own. 

Like Flórez, there has been a good number of singers whose careers have taken off following their performances in the recital series. "I wouldn't want to take credit for it, I'm just saying it's happened that way," says Rosenblatt. He insists he's "not some svengali", and not an enabler of singers' careers. "These people will have made it in any event, because they are great singers." He remembers a season at Covent Carden which was full of debuts by singers who had been a partof the series. "I think it was something like twelve singers, across various casts, who were having a Covent Garden debut, and who had previously been at a Rosenblatt Recital."

"It might have been coincidental, I have no idea. But it makes me feel good."

## Opera singers on the recital stage

Just how much input does Ian Rosenblatt have in what audiences hear at his recital series? When it comes to what goes into each singer's programme, he offers some "tweaking", but generally stays out of the artists' way. "Often [the programme is] too short, so we have to persuade them to add a few things." When a recital features younger singers, their choice of repertoire can often come out of a slimmer range of options. "If you are of a certain age, of a certain voice type, you might just be doing *Traviata*, *Bohème*, and a *bel canto* piece. That might be your repertoire, that might be what you're focusing on for the next five years. And therefore they don't have a big range of repertoire, certainly for a concert."

Yet Rosenblatt has also been surprised by what many opera-focused singers bring to the recital stage. "There was an Italian mezzo who really surprised me, because in the first half she sang, basically, *bel canto* mezzo repertoire, and in the second half it was all Lieder," he recalls. "I thought, this will be interesting; she was absolutely wonderful as a Lieder singer."

Recitals can be significantly more stressful for a singer than performing a role in an opera, yet more often than not, Rosenblatt encounters artists "who just love the opportunity to sing all these sorts of things they wouldn't otherwise get the chance to sing."

## Sponsorship and relationships

Sponsorship of singers' performances, be it by individuals or corporations, is not a new idea. Yet it's still rare to find something like Rosenblatt Recitals, facilitated by someone who's simply a true lover of singers. So, what does it take to get more people, with the means to do so, to direct their generosity towards this type of entertainment? "It depends what turns them on," says Rosenblatt. "It happens to just make me happy. It's my thing, and it's created something that, obviously there's an audience for, which is a good start. It's taken a long time."

Out of his recital series have come several close relationships with the singers. "I spend a lot of time with all the artists. A number of them have become friends." Often the singers stay with him while they're in town for a recital, or they'll use his piano to rehearse. "There's nothing like having the second act of *Bohème* being sung to you in the kitchen while you're cooking."

Admittedly, his recital series isn't entirely altruistic. "I wouldn't want anybody to think I'm that insane," laughs Rosenblatt. "I'm quite insane, but I'm not that insane." He runs a [London-based law firm](http://rosenblatt-law.co.uk/), and he's able to extend invitations to the recital series to clients. "It's amazing how many people, who are connected to the law firm, just love coming." In many cases, he is able to introduce them to something entirely new. "We had a couple hundred people as guests at the Albert Hall, for example. There was a significant majority who had never been to the Albert Hall, who'd never been to a classical concert, who certainly had never been to hear a classical singer, and who were completely and utterly blown away."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460366571011/2016-04-11---Javier-Camarena-c-Jonathan-Rose.jpg.jpg)<figcaption>Tenor Javier Camarena at his Rosenblatt Recital, 2014.</figcaption>
</figure>

## What's to come

Though he says there is "no shortage" of singers who want to appear in the recital series, Rosenblatt has a few items on his own wish list. "I would love to get Joseph Calleja, who has sung for me a couple of times, to do a Lieder recital. That's the sort of thing that would be different." Though he couldn't offer concrete details, he adds, "We have talked about it."

He looks to the new and unique to fulfill his wish list, and he's interested not only in notorious artists, but what he could offer to audiences that they wouldn't easily find from an artist elsewhere. "I would like to have a Spanish singer, not doing either opera or traditional repertoire, but doing Zarzuela."

Next up for Rosenblatt Recitals is Mexican tenor [Javier Camarena's performance](http://www.rosenblattrecitals.com/recital.aspx?key=165) with pianist Angel Rodriguez, at Wigmore Hall on April 14th. Camarena has sung in the series before; "we managed to get Camarena on a day's notice, and it was a sensation. I mean, it was unbelievable."

The calibre of voices is high, and Rosenblatt prefers to declutter the concept of The Recital. If listeners go to hear the cerebral, the ultra-philosophical, they may be disappointed. "It's old-fashioned entertainment. It's a good night out, you get to hear great singers, doing their thing."

All about the voice, indeed. "If that bores you, you won't come."

>For full details and ticket information for the next Rosenblatt Recital on April 14th, follow our box office links below.
