+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-07T15:29:00+01:00"
lastmod = "2016-04-08T15:31:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460039298378/2016-04-08---Ian-Page-c-Sheila-Rock.jpg.jpg"
primary_image_credit = "Photo by Sheila Rock."
publishDate = "2016-04-08T15:10:00+01:00"
related_articles = ["articles/cecilia-bartoli-atonal-music-creates-a-barrier-between-composer-and-singer.md","articles/alexander-neef-listening-to-music.md","articles/from-don-juan-to-unclejohn.md","articles/talking-with-singers-alessandro-fisher.md","articles/a-warm-introduction-the-mozartists-at-wigmore-hall.md","articles/littleknown-gems-ariane-et-bachus.md","articles/a-very-happy-20th-birthday-for-classical-opera.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/ian-page.md"]
short_description = "&quot;I love the way things have changed in the last generation or two. There are people who behave stupidly and tyrannically, there will always be. But it&#039;s more and more of a minority now, and I think it&#039;s so clear that when people feel enabled and bring themselves to their work, it&#039;s bound to be better. It&#039;s so obvious.&quot;"
slug = "ian-page-mozart-imagination"
title = "Ian Page: Mozart &amp; imagination"
+++

It's a real treat to talk with an artist as in love with his work as [Ian Page](/scene/people/ian-page/), founder, conductor, and artistic director of London's [Classical Opera](/scene/companies/classical-opera/). Since 1997, the company of singers and period-instrument orchestra has focused on presenting opera and orchestral works by Mozart and his contemporaries. Though the music is old, Page himself is averse to the concept of putting up what can be called, with negative connotations, "museum pieces". "The reason I love period instruments is that to me, they sound more modern," he says of the company's musical aesthetic, which has deep roots in storytelling and conveying drama.

Classical Opera began as a repertoire-first company, and it has a strong history of offering performance opportunities to emerging artists. While these are still important mandates, CO's audience has responded the most to their unique approach to presenting a season's worth of work. Page loves the idea of "taking them on a journey, across a whole season, or across a number of years." The company's evolution has landed less as a repertoire-led vision, and more about responding to and connecting with returning audience members. 

"It feels to me that if we suddenly decided to do *Rake's Progress* one year and became Neo-Classical Opera, it wouldn't really matter. The storytelling and the programming and the connecting with the audience are the most important things now." Listeners have responded in a positive way to this approach. "We're really lucky," says Page, "we've got an incredibly loyal following." 

## Mozart250

Classical Opera has embarked on an extraordinarily ambitious musical project, called MOZART 250. The project spans 27 years, beginning with the 250th anniversary of Mozart's arrival in London in 1765, to the 250th anniversary of his death in 1791. By presenting the composer's works in order of their composition, an incredible arc of context will emerge, not only around Mozart himself, but with the music being written in those same years.

Next year will mark the first staged work of Mozart's, a so-called "sacred *Singspiel*", called *Die Schuldigkeit des ersten Gebots*, or *The Obligation of the First and Foremost Commandment*. "It's a comedy," says Page. "It's basically about a lapsed Christian, who is partying instead of going to church. He's found at the beginning of the piece, asleep on a park bench." There are allegorical characters representing Christianity, Divine Justice, and Divine Compassion, who discuss how to redeem the fallen Christian, and encourage him to live a better life. "And then there's the spirit of Worldliness, who tells him to party."

Page acknowledges that, "easily and lazily", people can distill Mozart's staged works into a short list of *Le nozze di Figaro*, *Don Giovanni*, *Die Entführung aus dem Serail*, and other major hits. MOZART 250 also includes programming works by the composer's contemporaries, like Beck, Guglielmi, and Jommelli (whose opera [*Il Vologeso*](http://www.classicalopera.co.uk/performances/jommelli-il-vologeso/) will be presented by CO at the end of this month). CO hopes to make a distinction between works that Mozart definitely heard himself, and those he didn't. "There are some things that you can't prove that he heard - but somehow things are in the air, different composers trying different things. And he was such a magpie, I think, in that respect. He could just pick out what people were doing."

Pieces that inspired Mozart are as important to Page as works he criticised, when it comes to contextualizing the composer's aesthetic. "The things that [Mozart] does criticise are so interesting. Like, he had the temerity to criticise [Shakespeare's] *Hamlet*," he laughs. "I love *Hamlet* to bits, but he's sort of right. He said that the ghost spoke too often, and actually it would be much more menacing and frightening if he were to say fewer words." As anyone who's sung a Mozart opera knows, criticism of this scale is indicative of the composer's innate sense of dramatic timing and storytelling. "He was so practical; he was always thinking about how to create an effect."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460124586045/2016-04-08---Full-orchestra-and-Ian-Page-c-Benjamin-Ealovega.jpg.jpg)<figcaption>Ian Page conducting the Classical Opera orchestra. Photo by Benjamin Ealovega.</figcaption>
</figure>

## Fostering great rehearsals

Although their belts are quite as tight as they may have been in the beginning, Classical Opera is a shining example of what it means to work within perceived limitations. In their early years, the engagement of emerging singers freshly out of school was as much a financially strategic move as it was an extension of opportunity to young singers. Now, Page reaps the rewards of an established working vocabulary with many singers who return to the company, after having worked with them at the initial stages of their career.

"We get used to each other so quickly, and when they come back five years later, we have that shared language, we know what we're trying to do with the music." Page sees this as a predictable result of what happens when respect and attention are a part of working with young artists. "If you invest the time in the beginning, the payback comes later on."

It seems a simple case of foresight, and Page is pleased that the classical music industry as a whole is moving away from the dictatorship-like approach, and towards one that's more communal. "I love the way things have changed in the last generation or two. There are people who behave stupidly and tyrannically, there will always be. But it's more and more of a minority now, and I think it's so clear that when people feel enabled and bring themselves to their work, it's bound to be better. It's so obvious."

A respectful approach is directly connected to the audience's experience, something Page has placed at the top of his aesthetic priorities. "It's much better to come offstage thinking, 'Oh my God, I was so immersed in that, I don't have a clue how that went' rather than, 'I really nailed that top C'."

The terms "Early Music" and "traditionalist" can sound like "museum piece" and "irrelevant"; yet for Page and his CO team, the difference can lie in intention. Like with music of any age, a rehearsal needs constant injections of humour and play. "As musicians, it's so easy to take ourselves too seriously," he insists. A father of three, Page gains some of his much-needed perspective from the young people in his life. "When my eldest was about two and a half, I came home after a really long, exhaustive day of rehearsals, and she was standing on the other side of the front door, and she just looked at me and said, 'Have you been waving your stick again?'"

Trying things out, and allowing oneself to be delighted by (if not sold on) the results, are the practices that distinguish between tradition and rigidity. "I think it's really important that in an opera rehearsal, it's full of trying things out, having fun." 

Classical Opera's aesthetic, when it comes to staged work, orchestral music, or anything in between, comes right from a desire to tell stories. "I've always really resented the fact that actors get to do plays, which sounds fun, and opera means 'work'," laughs Page. "We have to re-learn allowing ourselves to have imagination," he says, referring to anything from Handel to the next world premiere. "Have you ever met a child who didn't have an imagination?"

>Next up from Classical Opera: Jommelli's Il Vologeso, April 28th, 7:30pm at London's Cadogan Hall. For details and tickets, follow our box office links below.
