+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-12-22T09:16:00-05:00"
lastmod = "2015-04-12T18:24:00-04:00"
preamble = "Ivars Taurins in character as George Friedrich Handel at Tafelmusik's 28th annual Sing-Along Messiah."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428876123686/Ivars_Taurins_Handel1.jpg.jpg"
primary_image_credit = "Photo: Gary Beechey."
publishDate = "2014-12-22T09:16:00-05:00"
related_articles = ["articles/all-about-the-tafelmusik-baroque-summer-institute.md","articles/thank-you-for-the-music.md","articles/he-saidshe-said-a-tale-of-two-messiahs.md","articles/dont-miss-haus-musik.md","articles/dont-miss-the-drama-devotion-of-agostino-steffani.md"]
related_companies = ["scene/companies/tafelmusik-baroque-orchestra-chamber-choir.md"]
related_people = ["scene/people/brett-polegato.md","scene/people/lydia-teuscher.md"]
short_description = "Sunday, December 21st was 2014’s Winter Soltice, and it was an apt day to head over to Massey Hall and hear Tafelmusik’s 28th annual Sing-Along Messiah. I had actually never been to a Sing-Along Messiah, save for the obligatory singing-along of the Hallelujah Chorus at all the other Messiahs I’ve seen. "
slug = "i-sang-along-at-tafelmusiks-messiah"
title = "I sang along at Tafelmusik&#039;s Messiah"
+++

Sunday, December 21st was 2014's Winter Soltice, and it was an apt day to head over to Massey Hall and hear [Tafelmusik's 28th annual Sing-Along _Messiah_](http://www.tafelmusik.org/concert-calendar/concert/sing-along-messiah-massey-hall). I had actually never been to a Sing-Along _Messiah_, save for the obligatory singing-along of the Hallelujah Chorus at all the other _Messiahs_ I've seen. So it was really neat for me to turn off of Yonge St. and see a crowd of people outside the theatre, plenty of them clutching a Novello edition of Handel's _Messiah_ under their arm. Toronto _Messiah_-goers come prepared. I opted for trusting my memory with the choruses instead, although I'll admit to sneaking a glance at my neighbour's score on a few occasions.

Tafelmusik's Sing-Along _Messiah_ is like a show about the _Messiah_. It's great. [Ivars Taurins](http://www.tafelmusik.org/about/choir/bios/ivars-taurins), director of the Tafelmusik Chamber Choir, donned a powdered wig and some Baroque apparel (see photo above!) to embody George Friedrich Handel himself. In beloved and unwavering character, "George" acted as conductor, emcee, historian, and cheerleader, both for the extraordinary Tafelmusik [Baroque Orchestra](http://www.tafelmusik.org/about/orchestra) and [Chamber Choir](http://www.tafelmusik.org/about/choir), and for the packed house of amateur choristers. His thick German accent made quotable quotes, like "I'm so hip it hurts!", extra hilarious ("I'm zo heep it hooertz!"). He conducted with wild flails and oversized jabs in the general direction of the next entry; it was fantastic, and it reminded me of [this](http://www.youtube.com/watch?v=BX1ljYx3g3k&t=0m50s). Amid the exaggerated show of it all, there were true musicians onstage to make it all work. Ivars conducted with an abandon that spoke of a deep understanding of the score of Handel's _Messiah_; it was clear to me that he and the Tafelmusik ensemble were absolute pros, having fun with a piece they know inside and out. Frankly, Ivars-als-Handel emanated a love for the piece that was infectious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428876519301/TeuscherFeb2014.jpg.jpg)
<figcaption>Soprano Lydia Teuscher.</figcaption>
</figure>

Four great soloists joined Tafelmusik for this _Messiah_: soprano [Lydia Teuscher](http://www.askonasholt.co.uk/artists/singers/soprano/lydia-teuscher), countertenor [James Laing](http://jamesblackmanagement.com/artists/category/countertenors/james-laing), tenor [Colin Balzer](http://www.maierartists.de/colin-balzer-en.html), and baritone [Brett Polegato](http://www.brettpolegato.com/). Their sounds were complementary, keeping a cohesive sound palate throughout the night. Colin's "Comfort Ye" was sweet and strong, and I think he liked singing the aria as much as I like to hear it. I thought he got a bit shy up top, and wondered if he was feeling 100%. I was glad they didn't cut his aria, "But thou didst not leave", because it's one of my favourite bits.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428876552778/James-Laing.jpg.jpg)
<figcaption>Countertenor James Laing.</figcaption>
</figure>

James Laing sang with clean beauty and lots of soul; his (long) aria "He was despised" got cut short, but I loved what he was doing and could have heard the whole thing. Lydia Teuscher had a bright, gentle sound and lots of speed for those famously tricky melismas in "Rejoice greatly". Brett Polegato was my favourite, I think. He had tons of energy, and took huge bites out of the great text in those bass arias, delivering his performance more operatically than oratorio-esque. His "The trumpet shall sound" was wicked, albeit a little wild, but props go to the baritone who can keep focus on himself with Handel himself waving along a few feet away. Bravo, Brett!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428876627204/Brett_Polegato_portrait.jpg.jpg)
<figcaption>Baritone Brett Polegato.</figcaption>
</figure>

_Messiah_ was a great musical experience, with tons of expertise up onstage. I'll tell you a bit about the moments of novelty and laughs I had from my spot amongst the Singers-Along. There were _so many_ Christmas sweaters, and more Santa hats than I expected. Behind me and to my right was an enthusiastic tenor, whom I later overheard had just done a performance of _Messiah_ himself last week, confirming my suspicions. There was the lady directly to my right who struggled first with opening a bag of Miss Vickie's chips, and then an apparently child-proof tin of breathmints. It struck me that the Sing-Along concept brings out the worst in audiences. You give an audience an inch (like getting them all to stand up for every chorus), and they take a mile (like unusual amounts of mob-like chatter between numbers and too much applause for my Puritan liking). Audiences are animals. But as Handel, conductor Ivars Taurins got the best out of us all. In quasi-Deutsch, he scolded our sloppy score-reading "It's zwei 'shall be's'! Zwei!!", and motivated our repeated text "Hallelujah! Was??? HALLELUJAH!!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428876721825/Colin-Balzer-Feb-2014_Fotor.jpg.jpg)
<figcaption>Baritone Brett Polegato.</figcaption>
</figure>

Personal note: I also brought my dad to this _Messiah_, partly because he sang bass in the chorus for it when he was younger, and partly because he laughs when I softly "bahhh" in the "All we like sheep" chorus (thanks, [Against the Grain Theatre](http://www.againstthegraintheatre.com/shows/messiah)).

It struck me that the mood in Massey Hall on Sunday was one that Handel hoped would come with his _Messiah_. Tafelmusik, Handel, and the whole audience joined forces to remind me of the real joy that comes out of the music and the message. I say bravo to Tafelmusik's long-standing tradition of the[ Sing-Along _Messiah_](http://www.tafelmusik.org/concert-calendar/concert/sing-along-messiah-massey-hall); 10/10, would Sing-Along again.
