+++
author = ["authors/esme-allencreighton.md"]
categories = "Op-ed"
date = "2017-01-11T13:12:00+00:00"
lastmod = "2017-01-14T17:13:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484161781982/2017-01-11---Viola.jpg.jpg"
primary_image_credit = "Photo: Evan Schaaf via Flickr."
publishDate = "2017-01-14T17:13:00+00:00"
related_articles = ["articles/how-did-we-do-second-movement-presents-rough-for-opera-16.md","articles/leaning-into-the-discomfort.md"]
short_description = "My viola: you were with me for a thousand mornings. How do you greet an empty room? With Bach of course. Or as time went on, with improv, as your magic worked in me and I felt freer and freer to sing anything from the heart, trusting what would come from you."
slug = "how-to-throw-a-funeral-for-a-viola"
title = "How to throw a funeral for a viola"
+++

To all those who've loved and lost a loaner...

Have you ever walked dangerously close to an open instrument case? Its owner will rush to the rescue, a zero-second swoop from any corner of the room to save their helpless "baby". Maybe you've watched a cellist friend on the subway, arms draped lovingly around their case, supporting and supported by an "inanimate object" that's so much more. 

Musicians tend to form extraordinary bonds with their instruments. Choosing a new instrument is one of the great thrills in a young musician's life.  Imagine walking into a store and being handed boxes full of personalities to try on, mouthpiece portals to alternate existences.   A mismatch and you might feel you're trying to declare passionate love after a helium swig, a serendipitous choice and suddenly you've stepped into omnipotent seven-league boots of expressive freedom. Sounds you've dreamed of and sweated after suddenly flow from you with ease and power. 

It can trigger deliciously manic practice sessions, self-abandon to hours roaming the winding streets of musical yore, this time armed with superhuman power.  Of course, as with many love affairs, the musician-instrument relationship can get off to a bumpy start.

My "baby" showed up an orphan at my doorstep.  I had been invited to join the string quartet in residence at the University where I taught. The invitation was a thrill on many levels. My greatest goal as a musician had been to delve deeply into the quartet rep with a committed, regular group, but perhaps the greatest thrill, was that the quartet was in possession of a set of instruments, all 18th century Italian beauties made by Testore and Serafin.  Their most recent violist had been practicing for a number of big competitions on either side of her time with the quartet. Reluctant to switch instruments around those deadlines, she'd forgone the instrumental perk.  Meaning, the viola had been alone, lying immobile in the box the better part of a year, a cryogenic freezing of sorts for a stringed instrument born to move.  

I met the neglected soul in the fluorescently lit, hygienic, pedagogically decorated play/rehearsal room of the state's local children's conservatory where the quartet met each week.  Not the most flattering acoustic or aesthetic.  There it was, a priceless 1752 Testore. Iits rich, dark and deeply grained wood formed a full body with a long, swan-necked scroll; its power, mystery and beauty unceremoniously flanked by chunky Fischer-price wall projections of musical concepts and characters.  

It sat expectantly in a greenish-brown, undecorated dart-shaped case. Expectation pervaded the room as I too, was flanked by my new quartet members, the air electric with their unspoken question: "So…do you like it?"

Let's take a moment to make fun of the viola. Perhaps a few jokes at our expense have already come to mind? We tend to trigger these things.  Of all the string instruments, violists work hardest to justify their existence.  We have promotional societies, we have elaborate support networks, we feel a need to band together and continually define what makes us special, lest those violinist/cellist elephants in the bedroom drown us out with their grunting and twitching.   

Perhaps tone? At our premiere international competition for example, you can win an award for having the most beautiful tone. Separate from phrase, character or musical idea, if the raw material of a "golden tone" (award’s name) flows in abstract beauty from your instrument, we will celebrate you.   

It reminds me of my favourite viola joke: "When the other orchestra musicians teased the violist, saying he couldn't play sixteenth-notes, he fiercely objected, whipped out his out his instrument, and played one!" Ha! 

I admit a weakness for basking in aimless, violistic vibration. There I stood, about to pick up the new instrument, and I confess my imagination wasn’t shaping exquisite melodic utterances, I just wanted to run my fingers through every little grain of the instrument's sonority, delight in texture, in colour, in tone!  Shoulder rest on, bow tightened, deep breath and my arm swings up and over in a broad circle launched to land in the darkest, juiciest, sweet spot of the instrument.  I'm falling, trusting warm strong arms to catch me, rock me in a flood of glorious sound. 
Ahem…

Somewhere in the room, a stuffed-up, sniffly goblin from long-island starts complaining in long, relentless bleats.  What?  My ears search for the culprit from their fetal position across the room, but they cannot cling to innocence, they must circle closer and closer to face the unmistakable truth.  Is that you, Testore mine? Oh god.  My new voice? My new me?  Life: over.  

But I'm still in the room. There are still people here and I’m a friendly, sociable woman.  They all seem to think this is a wonderful opportunity.  I should probably smile and say "Interesting" or "Wow!  That's so different" or something like that.  All I manage is a slow, hissing "ooooooh".  I need time to think, but can’t hold it in.

"ummmmm, hunh…I don't know…"

It was a rocky beginning.  I made an inner commitment to give it my best for a year, certain by then I would be leaping back into the caring arms of my trusty high-school, college viola.  Heck, it had gotten me thus far hadn't it? OUR first meeting had fallen into the serendipity category.  I'd scarcely put it down our first few weeks of union.  In contrast, I looked with dismay at the parasite changeling viola which seemed to be sucking the musical life out of me, channeling the most energetic impulses into a void of suffocation.  I wanted to fight back.  This thing simply could not smother me completely.  Hadn't a bankrupt Charlie Parker performed an entire concert at Massey Hall on a plastic saxophone when he pawned his Conn 6M for heroin?

At least I wasn't bankrupt, and addicted to heroin.  I wasn't Charlie Parker, either, but I had lots of resources. First line of attack? Retail therapy.  Change the strings!  Try every kind!  I got rid of all metal (fine tuners) on the tailpiece; every microvibration was precious, it all needed to be rich and wooden.  Next line of attack: a little elbow grease.  Instruments abandoned too long in their cases need to be played.  They can always open up, so I honked and honked away, trying every combination of speed, weight, contact, sense of touch I could think of, hour after hour to coax a little life out of the instrument. 

Nope, it sounded to me like an American Idol reject with a botched rhinoplasty job.  I called in the experts: string instruments are finicky things and a simple tap to realign the bridge or soundpost from a talented luthier can be a miracle cure. But still, my souped-up, decked out, spa-treated viola seemed trapped in a fishbowl.

I'd exhausted all personal resources, and with my first concert with the Testore in a few days, began to panic.  These were the early days of "professional independence".  I was a proud ex-student, wanting to solve my own problems as a musical adult. But in the end, I needed help, hope, and a musical "it's all gonna be ok" from someone I actually trusted to make such pronouncements. 

I was living in Philadelphia at the time and though I wasn't an alumn, my old teacher was on faculty at the Curtis Institute, a few blocks from my apartment.  He urged me to bring the viola to the hall there.  He would listen, play it for me, and I could relax a bit in the comfort of his advice and support.  

It was evening, classes had adjourned and we were alone in the peaceful, spacious elegance of the old hall.  There we fell back into the rhythm of a hundred lessons, opening cases, tightening bows, placing shoulder rests in tandem.   Back and forth, we played for each other, trading violas, talking and listening.  In my teacher's hands, within the hall's rich, ornate wooden canopy, a spell seemed to be cast over the testore, or maybe me: shock and fear dissolved enough to listen just a bit further.  

I began to hear the hints of something special.  A kind of tug in the sound lent a yearning quality, like it was asking me something.  There were more layers too. I started to hear different grains of after-ring.  It still sounded muffled to me (or was it unusually focused?) and it resisted any muscle, honking in objection if too much weight was applied.  

On the contrary, its budding offerings seemed to reside in the region of horizontal motion. It was immeasurably sensitive to quickenings and softenings of touch from side to side. It was a world I hadn't really explored on my modern instrument.  My dear, wise teacher had a knack for distilling such poetic technical discoveries into more succinct advice: "In the concert, if you're worried about sound, open from the elbow." Got it. 

Walking on stage I was still terrified. I simply couldn't unleash sound the way I was used to and wondered if  I would even be heard? But I drew strength from my secret-weapon fallback: If in doubt, open from the elbow. That night my elbow was a galaxy of creativity, the channel for every tender intention or burst of spirit. Clap, clap, bow, more smiling, drinks and even more smiles. I"d survived the night and woke up the next morning to face a recording of what actually went on.  I poured a cup of coffee bracing for the worst, but in an instant, everything changed. What was that sound?  Richness, complexity, and mysterious beauty like that had never come from me before, despite hours of work reaching for it.  It was as though for the first time, "someone" understood the most intimate intentions of my musical heart. 

If you're wondering how such strikingly different experiences of the same instrument are possible, you're not alone. The mysterious, complex properties of older instruments have inspired countless CAT scan analyses of wood and varnish composition. Nobody really knows why, but for some reason, certain instruments can sound completely different under the ear than they do in a concert hall.  I have heard theories that cleaner air made higher quality wood in the 18th century, or that certain varnishes created more porous wood, yielding resonances of more powerful, spacious projection.  I find none of these theories ultimately convincing.  

I believe the power comes from the emotional and physical investments of past owners. As I started to explore the instrument more and more, it felt like it already knew how to play certain things.  It was like certain gestures already had their path carved into them. The instrument was home to a host of characters and opinions, the voices of generations etched into its form.  Maybe such a crowd of musical ideas could only fit in a big hall?  I’m not sure, but as time passed, I learned to understand the connection between what I heard a few inches away with what resounded in the hall.  Listening grew in dimension and intensity, contributing to the sense that I was an actor and an audience to the viola’s own personality. The viola was alive, active in every artistic decision and a true companion.

My viola: you were with me for a thousand mornings.  How do you greet an empty room?  With Bach of course.  Or as time went on, with improv, as your magic worked in me and I felt freer and freer to sing anything from the heart, trusting what would come from you.  It was this freedom that grew the most: Free to imagine the wildest, crazy expressions of sound, and let em’ rip in public. 

You were there when we psychotically tore through the perilous streets of Shosti's 3rd quartet, clanging the bells of fate and waking the dead. We talked to the still, starry night in Debussy.  We held time hostage with Beethoven. You gave freedom, but also strength when I most needed it. I'll be eternally grateful for the time we stood up together in a church full of family and friends, to say goodbye to Grandmum in the way she loved best. I could not have done that alone.  

However, I was alone when I decided to move back to Canada.  I'm sorry Testore, but it had nothing to do with you.  Life outside sound and its own particular beauty had been pulling me in different directions for a while, but finally I'd inched across the threshold of decision and would be leaving the quartet, the country, and you.  There were teary goodbyes with students, with final quartet concerts, with places and spaces, but the scariest goodbye came when my old quartet colleague gave me the call mid-summer to arrange "the pick-up", and pass you along to the next owner.  

I hadn’t been playing much.  It made me sad and I had been busy making other preparations for the future in Canada.  But as the pick-up drew nearer, visions of the most sublime, exhilarating, touching pieces would come to me, anywhere and everywhere.  The feelings were visceral, tangible, the emotions surprised me with their intensity. I became completely possessed by the desire to play them together, one more time. The viola was not letting me leave it quietly. I needed a concert and I needed it fast.    

This is how you throw a viola funeral:  

Invite your dearest friends over for a summer's evening of music, drinks, and dancing to say goodbye to your viola.  Make sure they understand your psychological state with a crazed, emotional and apocalyptic invitation.  Without their enthusiasm, sympathy and emotional support, you might feel rather lonely. 

One day before they arrive, desperately call every pianist you know in case they feel like dropping everything with no warning to perform an unrehearsed medley of 20-odd viola pieces.  Give up, when you receive kind messages explaining why they don’t and assemble a playlist on your iphone for the karaoke version.  

Three hours before they arrive, splurge on food and drink.  Nothing is too good for your viola! 

Two hours before they arrive, get the wind knocked out of you by the all-too-familiar sensation "oh god, why didn't I use every free moment before now to practice? Must practice". Play the first few measures of everything you love, remember, you do indeed know how to play.  Cry a little, then do an hour and a half of slow, spacey yoga. 

Fifteen minutes before they arrive, cradle your viola in your arms and stare out the window. 

The guests started to trickle in with offerings for the table.  I realized later one friend had baked tiny viola shaped cookies.  I had no headspace for such details pre-concert, instead nervously flitting around the room half-listening to their jolly banter, half-responding with awkward, disconnected comments, mostly wanting them to all be quiet and sit down so I could stop waiting to play.  

Finally, the whole gang was assembled in a ring around me.  Their faces dotted the room from chairs, couches, footstools, the floor.  What did I play?  Everything I knew!  Everything I loved and cared about.  If it came to mind, it came out the viola.  Nothing mattered but the unity of emotion, vision and sound that was possible with this viola.  If I forgot how something went, I just trailed off.  My guests and I chatted between works. It was a greatest hits, a history of, even an all request hour.  Some fiddle music came out, and I recall at one moment rocking out to Europe's "The Final Countdown" amidst the Bartok and the Brahms.  

As the evening passed, the musical moments that had possessed me from recent weeks were expressed, one by one.  The urgent need drained away leaving an openness and strange calm.  I hadn't planned an order beyond "start with Bach", but I had always known how to end.  Robert Schumann wrote his *Märchenbilder*, "Fairy Tale Pieces" shortly before leaving his family for the asylum where he'd remain until death.  The last movement is a low, rich lullaby of sorts, undulating through gentle phrases that feel reassuringly timeless.  A *pianissimo* veil blankets the melody, eventually dissipating further inwards for the second section, a poignantly simple variation in the piano with a rush of even softer gestures in the viola, waving up and down as though caught by a moment's breeze.  

My old viola teacher had always said this was the piece Schumann wrote to say goodbye to his children. At first he soothes them, gently delighting, almost teasing at play, when from deep within the piece, a set of low triplets ushers in a different message.  Throbbing, rich pulses break through the quiet veil and the viola calls out at once giving, but reaching for love, with a pang, unsure in longing. But the will to give is victorious. The pain of doubt gives way to immeasurable tenderness, smoothing away all fear, lulling and rocking us back to the quiet of a lullaby.  We swing from each gentle phrase to the next, until there is no more, and with a tender pizzicato kiss, we are released from sound.  

I had no more music, and so the viola drifted down my shoulder.  I looked up to see I was alive in the world beyond that soothing universe of the imagination, and I stood, crying like a baby, until a friend leapt up and held me gently.  I ended up tackled with hugs and through love, care, a few nicely timed jokes and the reality that I had been ready for this change for a long time, I was able to carefully pack up the viola.  I wiped off the last traces of rosin dust, enclosed a little letter to the future owner, zipped it up, took a massive swig of sangria, and cranked some Motown to get the celebration started.
***
Feature photo: [Evan Schaaf](https://www.flickr.com/photos/e_schaaf/6808698732/in/photolist-bnEmVs-iLpCLL-iLmV3X-5mSoVV-8RSQ7A-rjsWJH-9crguw-nCdDND-iLmVcp-65z6zQ-s8Yxxd-mi3ySw-sb7YwE-bxHui4-jddcP-9M3xxf-dyQe6f-6y1LqS-7p1npR-6JjhK7-cZaQPG-5FMvrk-cEEmCo-p9cRHh-eA4gbr-91kJYQ-n9UBNJ-nrNATw-f3Y3eq-nDGdup-rRWvtK-dX5cXy-9gz9gQ-hNjWku-9pFrxC-cEEmzo-9pFs9f-eA7rcY-9pCp7c-7agjjg-eA4gM6-dQGFcE-eA4f3Z-eA7pY7-eA4e64-dWtcip-afFCCd-eA7rFf-gvwT7G-eA4ikK) via [Flickr.](https://creativecommons.org/licenses/by-sa/2.0/legalcode)
