+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-06-07T14:44:00-04:00"
lastmod = "2017-11-22T16:51:00-05:00"
preamble = "The universal steps to learning a song, I know you've all got them down. You can read music, count rhythms, learn language, and tell stories. A lot of the music I work with involves a pianist and singer, and duetting is all about communication. In the process of \"learning your part,\" it's easy to forget to look up (or down) at some of the other musical lines happening in tandem with your own. Pianists are often guilty of getting micro-focused on what they're playing, forgetting to read the singers' words. Conversely, singers often learn their songs without fully taking advantage of the information in the piano part. Here are a few ways to do that, and improve your song-learning system."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433720099034/SongScore.jpg.jpg"
publishDate = "2015-06-08T08:00:00-04:00"
related_articles = ["articles/how-to-lead-your-pianist.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/5-tips-for-university-auditionees.md","articles/music-school-auditions-4-tips-for-parents.md","articles/4-secrets-for-better-high-notes.md","articles/quick-tips-the-rolled-r-test.md","articles/4-traits-of-a-great-cadenza.md","articles/organizing-your-scores-a-serious-business.md","articles/4-ways-to-test-your-memory.md","articles/dont-miss-songfest-alumni-in-recital.md"]
short_description = "The universal steps to learning a song, I know you&#039;ve all got them down. You can read music, count rhythms, learn language, and tell stories. A lot of the music I work with involves a pianist and singer, and duetting is all about communication. In the process of &quot;learning your part,&quot; it&#039;s easy to forget to look up (or down) at some of the other musical lines happening in tandem with your own. "
slug = "how-to-really-learn-a-song"
title = "How to really learn a song"
+++

### Know your rhythm, know everyone's rhythm

Of course, it's important to be rhythmically accurate for both the singer and pianist; ultimately, they're responsible for their respective parts. Just as singers practice coloratura slowly so that they learn it correctly before committing the pitches to memory, the same goes for the collective rhythm of a song, both in the piano and the voice. For singers, it's about taking their rhythms, and cross-referencing them with those of the piano, giving them clearer context.

This part of the learning process is one to start with. A singer learning this Hugo Wolf song has a way better chance of coming in correctly if he or she knows the piano's low notes are downbeats:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701687425/Wolf2.png)
</figure>

In the second system, the rhythmic change in the pianist's right hand should help the singer count and make music while on that long note above "kam ich her."

A singer needs to know the piano's rhythm when it comes to tempo adjustment. In the Bellini example below, the rallentando marked above "Come riedi tu nel..." should take into account the piano's eighth notes versus the singer's quarters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701782280/Bellini.png)
</figure>

The pianist is instructed to follow the singer in this bar, but there's no reason the singer can't subdivide in order to slow down gradually, in the full sense of the word.

### Know who has the melody

Spoiler: it's not always the singer. Great songs trade tunes back and forth between the voice and piano. Great songs, like Strauss' *Morgen*, over which pianists collectively salivate. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433703494856/Screen%20Shot%202015-06-07%20at%202.57.38%20PM.png)
</figure>

The whole opening of this song is a song in itself, and I think it ends/starts again while the singer says the word, "scheinen." This should tell the singer that when they come in, they're joining an ongoing song, like a descant added to a second verse. The piano continues its sustained tune, and the singer, I think, should find flexibility and expression within it. *Morgen* continues:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433703666794/Screen%20Shot%202015-06-07%20at%203.00.09%20PM.png)
</figure>

The tempo shouldn't get jigged around, and everything the singer does should make rhythmic sense with the pianist's continued tune in their right hand.

Singers should also know when they actually take over a tune (or at least join in). In this Debussy excerpt, look at the last bar of the first system:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433703269071/Screen%20Shot%202015-06-07%20at%201.49.38%20PM.png)
</figure>

The piano part has a triplet in beat one, and the singer holds a quarter note. We've heard this tune before in this song, and it's the version with the triplets. This means that while that singer is holding the word "et," they should mentally fill in the stretch and expression of the moving part. It sounds subtle, but it changes what a singer would do with that bar, compared to looking solely at the voice part.

### Know who starts the phrase

In this section from Mahler's stunning *Rückert Lieder*, the voice and piano start and end each phrase together. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701335409/Screen%20Shot%202015-06-07%20at%202.16.36%20PM.png)
</figure>

The first "Liebe" ends with a diminuendo and a comma, and then both singer and pianist move on in tandem. I think this tells the singer that there's room between "Liebe" and "o ja," and that they can take the time to finish one idea and start another. There's nothing rhythmic or harmonic that changes in the rest, and it's a beautiful opportunity for intuitive ensemble.

Conversely, the piano in the Wolf excerpt below has a series of small phrases, which they initiate. The voice part comes in after the downbeat, in a reactive way. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701376380/Screen%20Shot%202015-06-07%20at%202.12.06%20PM.png)
</figure>

The singer should be humming this tune in his or her head while adding their part. The piano part asks that the voice anticipates those syncopated entries in the third and fourth bars; if there's a lag from the singer, the pianist's phrasing is compromised.

### Know your harmonic context

While a singer is holding a long note, a good composer will make something happen underneath it. It's more in the singer's mind than in the voice, but there's a huge difference between a held note and a developing note. Here's a perfect example, at the end of Liszt's "Oh! quand je dors:"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433704829932/Screen%20Shot%202015-06-07%20at%203.16.41%20PM.png)
</figure>

Under "Laura," the piano has a major chord, then a minor chord. It's tiny-yet-huge difference, and if the singer knows it's there, there's a noticeable difference in sound and meaning. Here's a more subtle example, again from the *Rückert Lieder*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433705359680/Mahler.jpg.jpg)
</figure>

The harmony clears out slightly between the second and third bars, under the word "Welt." I think there's huge tension in that tied note at the end of the word, and it coincides with the change in chord. Like with the Liszt example, you can hear when a singer knows about that moment of tension.

### Leave time for everyone to make music

This last one seems obvious, but it's a detail that I find singers wait too long to notice. Most of the time, pianists are listening to a singer's sound, how it vibrates and spins; they give you space to breathe and add a *portamento*. In the spirit of giving back (not to mention being fully informed), singers should take stock of potentially time-consuming moments in the piano part. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701645743/Poulenc.png)
</figure>

This is a line from Poulenc's *5 Poèmes de Max Jacob*. In the third measure, there's a tiny grace note in the pianist's left hand. It's a decent distance to span, and although the pianist may play it early so as not to upset the tempo, a singer should know that extra note is there. The bigger red flag is in the next bar, that broken chord in the bass. The singer is on the word "ivrogne," which has plenty of opportunity for stretch; this will compensate for the time this piano figure takes, while still making it work for the text.

Rolled chords can dictate tempo, too:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433701907045/Wolf.png)
</figure>

In this Wolf excerpt, the time spent on each of those rolled chords should indicate a slower pace, with lots of room for the left hand sixteenth notes. This is a case where the piano part simply has more information in it than the voice alone. It's not a good use of time for a singer to practice at a "wrong" tempo, considering all the information available to them on the page.

> What have I missed? Leave your tips on score de-crypting in the comment section below!
