+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-05-20T20:46:00-04:00"
lastmod = "2015-05-23T23:00:00-04:00"
preamble = "Pianists, you're a busy bunch. So how do you learn all that music, and prioritize like a pro? When it comes to playing for singers, pianists are often in one of three situations:\n\n1. They have practice time to learn a song or aria.\n2. They know the song or aria, but they're playing for a new singer.\n3. They don't know the piece, and they don't know the singer.\n\nPianists have their generally great skills in sight-reading at their disposal, and the addition of a singer can easily throw a wrench in your musical plans. Here's a condensed guide to adapting your sight-reading to these three scenarios; singers notice this kind of thing, and they tend to call you back for the next gig."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432313196607/LegoPianoSquare.jpg.jpg"
publishDate = "2015-05-22T13:02:00-04:00"
related_articles = ["articles/on-pianists-those-vicarious-opera-singers.md","articles/in-defence-of-pianists.md","articles/pianists-plights-and-opera-fights.md","articles/the-pianists-tech-week-plight.md","articles/how-to-lead-your-pianist.md","articles/5-ways-to-build-your-rhythmic-chops.md","articles/quick-tips-the-rolled-r-test.md","articles/4-steps-to-taking-fixing-notes.md","articles/coaches-voice-teachers-and-the-grey-area-in-between.md","articles/3-life-lessons-that-practice-rooms-can-teach-you.md","articles/how-to-empathize-with-singers.md","articles/what-do-singers-want-in-a-pianist.md","articles/leonard-bernstein-nyfos-i-think-hed-be-pretty-proud-of-it.md","articles/playing-bel-canto-4-tips-for-pianists.md","articles/talking-with-pianists-james-cheung.md"]
short_description = "Pianists, you&#039;re a busy bunch. So how do you learn all that music, and prioritize like a pro? When it comes to playing for singers, pianists are often in one of three situations:"
slug = "how-to-play-for-singers"
title = "How to play for singers"
+++

### When you've got practice time

For a pianist, learning a song or aria to perform with a singer feels like we're learning something twice. Our focus is automatically drawn to what we have to play, and it's easy to forget about all those words. Pianists (thankfully) don't have to sing well, but they do have to *really know* the text of a song. Translations, pronunciation, the rhythm and pitch inflections that come with each unique language; if you're playing a song worth singing, these elements of language inform the notes.

Starting with the text can save unnecessary headaches when you start learning the notes. Singers have the sacred three-fold process: 

1. Speak the text until you're comfy with it.
2. Speak the text in rhythm until it feels as natural as possible.
3. Add the melody.

It's kind of a cool experience to go from step 1 to step 3, especially in your native language. It's really illuminating to start with an unfamiliar poem, get to know it, and then find out what a composer thought of it. Plus, with a good grasp on the words, you can get a better handle on what really happens with the music.

Finally, take the breaths the singer will take. Really take them, so that you can feel how much space there will or should be; in a lot of cases, a composer will factor in a breath in their writing, so it becomes part of the musical line. You'll be able to more accurately decide on a tempo or the pacing of cadenzas.

### When you know the song, but don't know the singer

Pianists in this situation get to become readers of minds. You have some knowledge on your side; you know the aria, you (hopefully) know the spots that everybody sings differently, and you know a reasonable tempo to set. To find out the rest, it's just about listening. 

The first point of entry is the singer's breath; it can set a tempo for the piece, and establish the weight, if you will, of the voice. Language, too, is a great indicator; a good singer will sing through consonants, so in languages like Russian or German, you should have a fair amount of heads-up before the vowel you're listening for.

### When you're sight-reading

For starters, be a diva. Take 30 seconds or so to yourself, so that you can have a quick but detailed look at the piece you're sight-reading. It can make a world of difference to simply have spotted tempo or key changes that come up, and find any cuts or repeats.

Assuming they're sight-reading for some performance or audition, pianists know that the basic tenets of their job is to listen like crazy and stay out of the way. The best way to do this is to minimize what you're playing, so you can give more brain space to following your singer. 

I find Handel arias particularly treacherous to sight-read, but fortunately they often support themselves with a confident left hand and a few indicative chords in the right. In Handel and plenty of others, prioritizing the bass and soprano lines of the orchestra gives a good amount of information to the singer, and you'll not get weighed down by scales and filler.

> Pianists, what have I missed? Leave your tips in the comments below!


