+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-04-22T21:14:00+01:00"
lastmod = "2016-08-20T12:17:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471691859607/2016-08-20---Leader.jpg.jpg"
publishDate = "2015-04-25T20:05:00+01:00"
related_articles = ["articles/on-pianists-those-vicarious-opera-singers.md","articles/in-defence-of-pianists.md","articles/how-to-play-for-singers.md","articles/how-to-really-learn-a-song.md","articles/4-secrets-for-better-high-notes.md","articles/star-repetiteur-there-is-such-a-thing.md","articles/putting-on-show-instrumentalists.md","articles/quick-tips-the-rolled-r-test.md","articles/4-steps-to-taking-fixing-notes.md","articles/how-to-empathize-with-singers.md","articles/new-opera-repetiteur.md","articles/what-do-singers-want-in-a-pianist.md","articles/leonard-bernstein-nyfos-i-think-hed-be-pretty-proud-of-it.md","articles/playing-bel-canto-4-tips-for-pianists.md","articles/talking-with-pianists-james-cheung.md","articles/dont-miss-songfest-alumni-in-recital.md"]
short_description = "Singers, how much do you love auditions? I know you&#039;re all troopers, experts at the art of wowing someone in two arias or less. It&#039;s really all about making your way through the huge list of Things You Can&#039;t Control. Often, one of those things is the prowess of your audition accompanist."
slug = "how-to-lead-your-pianist"
title = "How to lead your pianist"
+++

Singers, how much do you love auditions? I know you're all troopers, experts at the art of wowing someone in two arias or less. It's really all about making your way through the huge list of Things You Can't Control. Often, one of those things is the prowess of your audition pianist.

I've played a few auditions myself, and I've heard from my singer friends many glorious stories of pianist-related adventures. Singers often haven't met their audition pianist ahead of time, so they may only have a few moments to tell them what they'll start with, how their cadenza goes, what tempo they like, etc., if that. Singing with a new pianist can be a fair factor in how an audition goes, but the goal is to sing your arias the way you sing them best, and let the pianist take care of him or herself. Here are a few tips for singers to show a new pianist exactly what you need in your (yes, *your*) audition.

### Breathe in your tempo

Most good singers do this without giving it much thought. It's worth paying some attention to how you breathe during your arias, because it can the first line of communication between you and a new pianist. A good pianist will pay attention to the breath you take before your first phrase, and adjust their tempo accordingly. Think of arias like "Casta diva," which starts with a long, sustained note from the singer; that long note can feel like a punishment if the pianist is playing slower than you can comfortably sing the phrase. Or that corner in the Count's aria from *Le nozze di Figaro* ("Ah no! lasciarti in pace..."); the baritone has to set a new tempo for the pianist, and it's super easy to do with an indicative breath. I personally prefer when he breathes a half-bar's worth in the new tempo.

### Lead with language

Leading with language really just means using a single word to dictate a tempo. This is simpler to do in languages that have more consonants; German and English are easy-peasy, and French and Italian are a little less indicative (although at least Italian can have some great double consonants). A German word like "Freude" has three opportunities to inform a new pianist: a fast or slow letter **F**, the pace of the rolled **R**, and the proportion of vowel time in that "eu" diphthong. 

A good pianist will wait until they hear a rolled **R** before they even think about putting that chord down for "Freude," and so if you spend time on the **F**, it's like giving an extra heads-up about tempo. While you're singing the vowels in "Freude," a pianist is listening to when you go from [ɔ] to [i] or [e], to get a sense of how long the word really is.

Conversely, if a pianist hears a singer who makes quick work of consonant clusters and diphthongs, it's a clear indication that the tempo should be quicker, probably more speech-like.

### Don't be afraid to be "not together"

This is really a conversation about being brave. If your aria starts with a piano introduction, and it's too fast or too slow, you can either a) breathe and hope you make it, or b) change the tempo. I vote for option B. The only way you can change a tempo set by your pianist is, well, by singing at a different tempo. Sure, you might have a bar or two (hopefully less) of not-so-great ensemble, but it's absolutely preferable to singing your aria at someone else's pacing (especially since you put all that work into it).

Another bonus is that the auditioners will notice that you're taking charge of your music. They can tell the difference between ensemble problems, and a singer leading a pianist. Even if the pianist doesn't follow you at all, the auditioners will see that you know your stuff cold.

### You do you

In short, singers, auditions are where you show yourself and your work. This means that it's more than enough to simply sing the way you know you can, under *your* circumstances. I've never met a pianist who is unwilling to help you give a great audition, but in an audition, it's ultimately up to you to recreate the environment in which you *want* to sing. 

It's a hugely valuable thing to demonstrate that you are a singer who can do their job without getting rattled by surprises or unknowns. Directors and conductors want to know this about you, and it doesn't show that you're stubborn or inflexible to work with. Instead, it shows that you know what you want to say with your arias, and you're making that the first priority. 

And hey, if your pianist manages to make some music with you as you do that, consider hiring them again.
