+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-08-20T18:57:00+01:00"
lastmod = "2016-08-22T13:22:00+01:00"
preamble = "When you think about it, it's quite odd that singers and pianists work so closely together. They couldn't be more different with how they approach music and make sound with their instruments, yet the voice and the piano are the most traditional of duos.\n\nWhen pianists and singers work together, they're basically trying to connect to how the other approaches music, and combine their skills and ideas. For young pianists, it can be a huge learning curve to start to think like a singer. Fortunately (or unfortunately, for the shy), the fastest way to build your singer empathy is simply to become one. \n\nHere are three big ways that pianists can get a taste of what singers are trying to do, and become a better partner onstage as well as off."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471719698567/2016-08-21---Seagull.jpg.jpg"
publishDate = "2016-08-22T12:57:00+01:00"
related_articles = ["articles/how-to-lead-your-pianist.md","articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/how-to-play-for-singers.md"]
short_description = "When pianists and singers work together, they&#039;re basically trying to connect to how the other approaches music, and combine their skills and ideas. For young pianists, it can be a huge learning curve to start to think like a singer. Fortunately (or unfortunately, for the shy), the fastest way to build your singer empathy is simply to become one."
slug = "how-to-empathize-with-singers"
title = "How to empathize with singers"
+++

## Speak their text

When singers learn a song, they use the 3-step process of a) speaking the text out of rhythm, b) speaking the text in the rhythm of the song, and c) adding the music to the text.

Pianists, the same three steps apply to you when you learn a song. Since, in performance, we're not actually the ones singing the words, it can be easy for pianists to get a bit of tunnel-vision and forget the endless details in the language. Double consonants, rolled Rs, consonant clusters, diphthongs; they all call for some attention on the pianist's part, and the simplest way to figure out how to allow for the ebbs and flows of the text is to say it yourself.

You don't have to have a lovely singing voice to do this; just some air in your lungs and a good sense of rhythm. The point is hearing where the phrase needs to peak, what sort of rhythm exists in the text, where there needs to be more time, and where it should move ahead. If you have all this understanding of the piece at your disposal, you'll be a better pianist, and a better coach to your singer.

## Try it out for yourself

Pianists, we have the luxury of sitting in on about a gagillion voice lessons each year. It's a huge opportunity for young coaches to learn about how the voice works, and to understand the vocabulary singers use when they're at work. 

The hardest part of your job as a coach is to bridge that sympathetic gap between what you can do with your voice, versus what a singer can do with theirs. If you're a pianist with no singing background of your own, it's a great idea to take a few voice lessons with a teacher you trust.

At the very least, pianists who aspire to work with singers owe it to their future colleagues to spend some time in a practice room with their own voice. Step away from the piano, and try a few of the warm-ups that you hear in those lessons every day, or sing a few phrases of a song you really like. Take advantage of your privacy, and really try to put into practice the technical advice you hear from voice teachers; you'll notice where you're shy, what's more difficult than you imagined, and perhaps you'll even figure out what it feels like to have "forward placement."

## Breathe with them

This one is so huge that it almost makes the other two points redundant. Pianists, we are an anomaly of the musical world. Unlike most instruments, the piano doesn't have to work hard to create and sustain pitch; once a key is struck, we have no control over what happens to the sound, and we don't have to bow a string or blow a steady stream of air to keep it beautiful.

But just because pianists *can* make music without breath, it doesn't mean that's how the music should go. Everything imitates the human voice, and singing inevitably includes breathing. That doesn't mean that breathing is a "necessary evil" in any way - rather, breathing is part of the phrase structure of music, and it's part of how listeners consume what they hear.

All this is to say that breathing is vital to making music, especially with another person. You, the pianist, are responsible for taking every single breath that your singer will take. Really take them, and know the difference between small catch-breaths and a big moment of inhalation.

Pianists, it's unreal how much breathing changes your playing. Your muscles relax, and your colour palette grows larger, your rhythm gets better, and you're a better collaborator. That's where that cool telepathy between musicians starts, from that moment where you're breathing in sync with another person, and you start to become empathetic to each other. It's an experience that can't be beat, really, and it's almost silly how simple it can be to achieve it.
