+++
author = ["authors/kristen-seikaly.md"]
categories = "Op-ed"
date = "2016-08-04T10:47:00+01:00"
lastmod = "2016-08-13T09:33:00+01:00"
preamble = "This post was originally published by [Kristen Seikaly](/scene/people/kristen-seikaly) on [Operaversity](http://operaversity.com/teaching/how-much-tell-your-students-about-the-voice), a great resource for working singers and teachers. For more, follow Operaversity on [Twitter](https://twitter.com/Operaversity) and [Instagram](https://www.instagram.com/operaversity/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470489153440/2016-08-06---Rubiks-Cube.jpg.jpg"
publishDate = "2016-08-13T09:33:00+01:00"
related_articles = ["articles/quick-tips-the-rolled-r-test.md","articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md"]
related_people = ["scene/people/kristen-seikaly.md"]
short_description = "Our style of learning may not suit our student, so sometimes we over explain technical concepts not because we&#039;re wrong, but because it loses our student. If you ever find yourself wondering why one student seems to understand an explanation perfectly well and another doesn&#039;t, this might be why."
slug = "how-much-to-tell-your-students-about-the-voice"
title = "How much to tell your students about the voice"
+++

When it comes to teaching the voice, it can be difficult to explain certain concepts. Even though we *technically* have a physical instrument as singers, it ends up being so abstract. We can't see it. We can't really feel it. Instead, we must simply imagine the instrument and feel the sensations that come from using it.

As a result, many voice teachers (myself included) may find themselves rambling on about breath or resonance or some other topic in voice without even realizing we've lost our student. Or, on the other hand, we might give a student so much information about a subject that they get distracted by what you've said and have a harder time applying it to their own instrument.

So I'd like to (somewhat ironically) open up a dialogue here. Teachers, how much do you tell your students about the voice? Before you answer, here are some things to consider.

## Know Thy Student

Voice teachers tend to be a brainy bunch – we spend a lot of time studying the voice as both a scientific, physical object and as an instrument. We also spend a lot of time on subjects like theory, history, language, and other thought-heavy pursuits. As a result, detailed explanations of a technical function tend to come relatively naturally to us, either through our training or through our personalities.

This does not mean our students are the same way. We all know that there are different types of learners out there who prefer different methods of learning. Some students do better by watching and then doing. Some do better by doing and then processing. Still others do better by listening and then watching and then doing. So on and so forth. 

As a result, our style of learning may not suit our student, so sometimes we over explain technical concepts not because we're wrong, but because it loses our student. If you ever find yourself wondering why one student seems to understand an explanation perfectly well and another doesn't, this might be why.

## The Overthinker vs. The Overdoer

No matter what kind of learner your student is, it's inevitable that you will have to explain something to them. After all, singing is not a silent act. So when it comes to how far your explanation should go, I like to divide my students into two types: The Overthinker and The Overdoer.

The Overthinker is the one you probably relate to a bit more. They usually ask a lot of questions, always look really thoughtful, and perhaps get really frustrated with themselves when they can't get something right. Although it's so tempting to indulge their curiosity, less is really more with this student. This is because they are prone to thinking too much about what you said and spending less time understanding how it works within their own voice. Or even worse, they might believe that what you say about their voice is set in stone, and have a harder time developing later on. So I find that in my Overthinker students, saying exactly what they want or need to know and nothing more is most effective.

On the other hand, The Overdoer is the one who wants to jump in with singing right away, perhaps skipping some steps in the process. Furthermore, when you try to explain a concept to them, their focus visibly wanders. It’s not that this student isn’t listening – it’s just that your explanation needs to cater to them a little more specifically. Short and sweet responses are best here too, but perhaps not in the say way as The Overthinker. While you probably can give a more scientific or detailed response to The Overthinker, you might need to give a more conceptual response or a specific action to The Overdoer.

## How to Understand Your Student

While the difference between an Overthinker versus an Overdoer might be a little more straightforward, knowing how your student learns best may not be so obvious. Here are some things I look for in my students to know how they might learn best.

*If a student watches me with great focus, ask a lot of questions, and seem methodical in their process, they probably prefer an explanation of what they’re doing or to watch you do it first before trying it themselves.*

*If a student is always jumping in on the exercises, seems fidgety, or doesn’t seem to listen well, they might prefer to do an exercise and process the task later.*

*If a student is constantly adjusting their posture, their face, or moves their hands to the location you’re describing, they probably prefer to physically internalize and then do the task at hand.*

*If a student often repeats what you said in the form of a metaphor or reframing the scientific truth to make it more "relatable", they might prefer to listen and then internalize through imagination.*

There are certainly other clues to watch out for when determining how your student learns best, but these will hopefully get you started. Another route you could go (if the student is older or relatively self-aware) is [simply asking them how they learn best](http://operaversity.com/teaching/teaching-first-voice-lesson/%20). They might not have a direct answer, but their answer may give you clues as well to give them the most effective learning experience.

The voice is a unique and delicate instrument. We as teachers are all eager to make sure our students have the best technique possible. Therefore, it serves us well to consider our methods for how we get them there.

>How much do you tell your students when you're teaching? What kinds of things will you or won't you tell them?


