+++
author = ["authors/jenna.md","authors/christopher-enns.md"]
categories = "Op-ed"
date = "2015-04-11T20:35:00-04:00"
lastmod = "2015-04-11T20:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428798799143/LatteArt.jpg.jpg"
primary_image_credit = "Latte Art by Yeung Yiu-fai. Carlo Allegri/Reuters"
publishDate = "2015-02-06T09:34:00-05:00"
related_articles = ["articles/the-number-one-financial-thing-i-wish-everyone-would-know.md","articles/managing-the-unexpected.md","articles/tshirts-and-tender-artists.md"]
related_people = ["scene/people/christopher-enns.md"]
short_description = "In the last few weeks, a recurring topic has come up among my artist friends. The crux of the issue can actually be boiled down to one question: are you still an artist if you can’t survive on your artist income?"
slug = "how-much-money-makes-an-artist"
title = "How Much Money Makes an Artist?"
+++

<p>
	In the last few weeks, a recurring topic has come up among my artist friends. The crux of the issue can actually be boiled down to one question: are you still an artist if you can't survive on your artist income?
</p>
<p>
	The answer is easy: yes. I don't know any professional artists who would say that a singer with a serving job isn't a singer. The problem is, <em>some </em>artists would draw conclusions about the skill level of that singer with a part-time job. It might be an innocent, uninformed assumption, that it's safe to bet on the abilities of the fully employed singer than those of the partly employed, because if you're "good", you earn more money than those who aren't "good".
</p>
<p>
	If you're an artist, you're probably rolling your eyes at the leaps in logic I just made. Skill doesn't correlate to income, you argue, and you're right. If only I had a dime for all the singers I've seen onstage who a) thrill me and b) could use more work; they'd probably match the dimes I had for the singers with packed schedules and decent income who don't move me at all.
</p>
<p>
	That said, it's true that an artist who trains for years, only to find inspiration-sucking hurdles in the professional world, takes a bit of an ego hit. There's an assumption that if they had better technique or a better work ethic or more <em>je ne sais quoi</em>, it would be much easier to make a living from their art. These same artists are reasonably aware of the fact that auditions are subjective, companies have fluctuating funds, and the arts has rarely been known to be a lucrative industry in which to work. The reality of the situation doesn't help with that ego hit, though; I've seen this myself, in the current opera scene.
</p>
<p>
	When I interviewed Chris Enns about his new personal finance blog for artists, <a href="http://www.ragstoreasonable.com/" target="_blank">Rags To Reasonable</a>, he brought up a good point that I'll attempt to paraphrase. Like me, Chris started his musical studies with a piano teacher, an elderly lady who was teaching piano lessons for extra cash on the side. Wasn't she an artist? Did she make us artists? My first piano teacher was a retired high school math teacher (who actually taught my dad, believe it or not), who turned out to have incredible connections and foresight into this world of music. She earned an income from teaching, but her family hadn't lived on it exclusively by any means. At no time did I think of this fact and lose respect for her, or lose my will to learn from her. I think most of my pianist (and otherwise) friends would agree that she is an Artist.
</p>
<p>
	So, why don't younger artists apply this reasoning to themselves? I'll tell you. In the opera world, training typically happens in a university or conservatory, and we bridge the time between semesters by doing summer programs. This means that for four to six years or more, we're gifted performance opportunities; operas are produced by our school or The Banff Centre or Opera NUOVA. Some of us even get a few more years of (paid!) stage time and training, in a young artist programme at a professional company. Once we leave, the crickets happen. The enormous amount of work kicks in, and the income dwindles. Artists know this phase well; some look back on it with fond hindsight, and others are living it right now. For the latter group, they're all wondering, "shouldn't this part be over by now?"
</p>
<p>
	This takes us to the crisis moment, where things like stable income, less travel, predictable work hours, less rejection, and family start to look appealing, perhaps for the first time in an artist's life. Maybe they've met a person with whom they want to share their life. Maybe they really want kids. Another, more ubiquitous option: being a professional artist is really, really hard.
</p>
<p>
	Perhaps to someone who isn't an artist, this is all less of a crisis and more of an obvious decision. You want to get married? Get married! Have kids? Have kids! Your career isn't really working out? Try something new!
</p>
<p>
	But what of the loss? What if a soprano gets pregnant, and despite all her good post-baby intentions, doesn't ever quite make it back to singing? What if the new job you take to supplement your income doesn't let you take enough time off for auditions or gigs? What if everyone finds out you're not throwing your whole self into singing/playing/painting/photography, and realizes you're not a "professional"?
</p>
<p>
	Ah, so we've returned to the question. For your artist status to move (or remain) to that of "amateur", that belittles your hard work, and it can belittle you. The difference between professional and amateur artists is money earned, and, consciously or not, that can insinuate a difference between "work" and "hobby", between "good" and "not so good".
</p>
<p>
	Any time I write something about the arts that I'm convinced is unique to the arts, it never really is. I'm going to get into this topic a bit more in the future, because I think there's a responsibility amongst artists to recognize what the arts industry really looks like. I also think there's a responsibility to avoid artistic martyrdom, and to avoid stereotypes of starving artists. Just like that constant question of the relevance of art forms like opera, the solution is in the general public, not amongst the artists themselves. Think about it: if a singer works as a barista, he may be hesitant to admit that amongst a rehearsal rooms of "real professionals". But if a coffee-lover finds out his barista is an <em>opera singer</em>? How cool of a barista are you? They <em>wish</em> they could sing on the stage, let alone rock latte art.
</p>
<p>
	See the difference?
</p>
