+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-10T11:03:00-04:00"
lastmod = "2017-10-02T12:43:00-04:00"
preamble = "When young singers begin to look seriously at turning their passion into their career, one of the first major considerations is how the nomadic lifestyle will affect their family life. Weeks and months spent away from home often mean that the relationships they have with their family, partners, and and children will be cultivated differently from what many understand as \"the norm\". \n\nSingers respond to these challenges in a few ways. Some leave their loved ones at home while they travel for work, and spend the time between gigs focused on family and friends; some singers opt for a life that is child-free, or even partner-free. \n\nSoprano [Jackie Short](http://www.music.uwo.ca/faculty/bios/jackalyn-short.html) is one of the many singers who often brought her daughter, Amelia, along for the ride. We spoke with them about the extra work that comes with involving children in the singer's life, and the rare experiences of the career that can offer a rich and stimulating childhood."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499862754710/2017-07-12---AmeliaJackie.jpg.jpg"
primary_image_credit = "Photo (clockwise from top left): Amelia Pipher, Jackie Short, and Michael Cavanagh, Christmas, 2014; Jackie as Papagena with Opera Atelier, with Amelia, age 2; Jackie and Amelia singing together in a cabaret."
publishDate = "2017-07-11T23:37:00-04:00"
related_articles = ["articles/childfree-opera-singers-happiness.md","articles/real-talk-the-unspoken-realities-of-a-professional-artistic-life.md","articles/singers-its-time-to-expand-your-dating-pool.md"]
related_companies = ["scene/companies/opera-atelier.md","scene/companies/edmonton-opera.md"]
short_description = "&quot;When she was under 10 I would leave notes with little gifts for her to open and would call frequently. As she got older, these calls became more like interruptions to her and it was obvious that less was more. My husband [and stage director] Michael Cavanagh (her step father since age 3) was also travelling a lot so her normal was parentals coming and going.&quot;"
slug = "how-lucky-are-we-the-children-of-opera"
title = "&quot;How lucky are we, the children of opera?&quot;"
+++

## What was it like to travel with your daughter for work?

**Jackie**: Travelling with Amelia was of course extra work in the planning stage, and of course financially.  It was great to have her with me when she was a baby and toddler because I felt like I was able to keep our bond and really looked forward to her joy at the end of a day. She was a very easy baby and child. Let's not mention the teenage years though! One thing I found helpful was contacting someone in the chorus about possible babysitters. That was a cost effective way instead of having to fly someone out with me. I was lucky that my family also came a few times.

## When did you realize that your nomadic lifestyle was different from how many other kids were growing up?

**Amelia**: This may sound ridiculous, but I didn't truly realize it until adulthood. Growing up I went to school, had friends, did activities, and then happened to miss large stretches of those things to travel. It was just "my normal". Mom and Mike [Cavanagh] were either home or on a gig, and that was normal. It was only while getting to know my (now) husband and contrasting our upbringings that I realized how completely abnormal mine was!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499737088274/image8.jpg.jpg)
<figcaption>Amelia (right) with Daniel Belcher after *Armide*, Opera Atelier, 2016.</figcaption>
</figure>

## Why do you think some parents choose to bring their kids on gigs with them, and others opt to travel alone and come home to see their family as much as possible?

**Jackie**: That's an interesting question because I ended up doing both. A counsellor I saw made a good point to me when I was dealing with these very questions. He said that when a parent is away, the only thing that changes in the child's life is that that person is gone. Everything else in their routine stays constant - family, home, school, friends, etc. So although the parent may see being away as a huge hole, the child adapts rather quickly. 

With that in mind I tried to balance my separation anxiety with her sense of routine. When she was under 10 I would leave notes with little gifts for her to open and would call frequently. As she got older, these calls became more like interruptions to her and it was obvious that less was more. My husband [and stage director] Michael Cavanagh (her step father since age 3) was also travelling a lot so her normal was parentals coming and going. We had a big calendar board showing who was away when and where Amy was and where the dog was! All colour-coded.  

## Do you have any particularly strong memories of a specific place or gig of your parents'?

**Amelia**: One that stands out is Edmonton Opera's *The Rake's Progress*. (Mike directing and Mom as Anne Truelove).  I quite vividly remember doing homework on the floor in that rehearsal hall. The production design - swatches of primary colours - really stand out as well. I remember Mike showing me the maquette at home. And of course when mom's face was projected on the moon during the show! 

Another huge stand out is Opera Atelier's *Don Giovanni* in Seoul. Bumming along on that tour was amazing. One night Olivier Laquerre and Danny Belcher "kidnapped" me and took me to McDonald's. I thought I was the coolest kid on the planet! I was about 12 and had such a crush on Danny! I really was enamoured with that entire cast. I hung out in that hair and makeup room a lot too, trying to speak Korean with the makeup ladies and doing my oh-so-on-point [Marshall [Pynkoski]](https://operaatelier.com/about/creative-team/) impression. I could go on and on! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499737277889/image5-1.jpg.jpg)
<figcaption>Jackie and Amelia with the late Stuart Hamilton.</figcaption>
</figure>

## Did you have any expectations of how hard it would be to balance work, travel and parenthood, and were you surprised in any way with the reality of it? 

**Jackie**: I'm a big worrier so I anticipated it being hard and stressful and went through every terrible scenario. That I would get no sleep, that she would get sick, and then I would, and then the whole cast! Thankfully it never became that bad, and it was always easier than I anticipated.  I was also divorced from her dad so I had the added stress of custody schedules, and making sure he was OK with her travel. She actually never came for the whole gig because of that. I tried not to be away from her for more than two weeks at a stretch, which meant she either came with me at the beginning or flew out later with someone. How did I do it??

## How much of the rehearsal work did you see as a child? What sort of head-start do you think you got that prepared you for the work you to today? 

**Amelia**: I saw all of it. I think I had varying interests in different rehearsal aspects depending on my age. I have memories of doing homework on the floor behind the piano. Sitting at the crew table and drawing silly comics. Mostly the rehearsal process was background to me; I sound like a broken record, but it just normal. Then as I got older I took more of an interest in the music, watching the pianists, conductors, and of course Mike when he was directing. I never had the urge to be on stage - that was Mom's domain. It's funny now that I've worked as a music director; I guess I've never left those rehearsal halls! As an artist I generally enjoy the process more than the product, perhaps that was influenced by being involved in the rehearsal process so organically as a child. 

## How did you maintain a sense of routine for your daughter amid the constant change that comes with travel?

**Jackie**: Maintaining a sense of routine was fairly easy because as I mentioned before, Amelia was a very bright, easy and adaptable child. Maybe because she wass an only child, she was extremely content to play alone, or interact with adults or sit and watch. Also Mike and I are not strictly routine parents. We make plans as we want, sometimes in advance and sometimes spur of the moment! I think Amelia became adaptable. (Which maybe makes her husband a bit crazy, sorry Bram.) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499737320551/image10.jpg.jpg)
<figcaption>Amelia in 1992, and at her wedding in 2014.</figcaption>
</figure>

## What advice do you have for working singers who are unsure about how their careers will change if/when they have children?

**Jackie**: Life is life. If you want kids, have kids. It's only opera. You don't know what your future holds in this crazy career so live your life first. Get a dog. (Or in our case, two dogs, a bird, a succession of rats, two chinchillas and various short lived gold fish.) It will be difficult at times but family is primo. I think, and hope, that dragging Amelia around the world with us was an excellent AND highly unusual childhood. But you'll have to ask her!

## What advice do you have for working singers who are unsure about how traveling with their families will affect their kids' lives?

**Amelia**: Do it. Travel. Lug your kids around. Everything I learned in life I learned from my parents, from being exposed to the arts, from having a wide world-view from the start. And I must include my dad in that, who not only travelled extensively with me as well but also dealt with me being away with mom a lot of the time. I truly believe I got a unique education that has made me the person I am today.  Here's a fun anecdote: one time I was away from grade four so long that I missed the entire Roman numeral unit. Guess what? I know my Roman numerals as an adult. 

Once a colleague, who has a young son, was asking advice about taking a gig that would take him away from his son. I told him that being able to sit in a packed audience and watch your parent perform is not to be taken for granted. I actually got emotional as I talked to him. How special and empowering is it to watch your hero, your parent, making world-class art? How lucky are we, the children of opera, to grow up all over the world, in rehearsal halls, in packed houses, in music? Pretty darn lucky.
