+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-01T14:51:00-05:00"
lastmod = "2016-01-12T10:45:00-05:00"
preamble = "Opera and theatre are created by a huge number of people working together; on opening night, many of these people go unseen by the audience, especially if they do their job well. A fight director is one of those people; they join the rehearsal process as a specialist in staging duels, tussles, and brawls that looks like the real thing. Choreographing onstage combat can be a long and difficult task, resulting in a sequence that lasts minutes at most.\n\nWe spoke with two of these fight directors, both with experience working in opera. [Dr. John Lennox](http://www.artofcombat.org/art-of-combat---fight-directors.html) has worked as a fight director and teacher for the last 20 years, and he's the founder of [Art of Combat](http://www.artofcombat.org/), a company of fight directors that now has chapters in New York, Los Angeles, Edinburgh, and Sydney. [Meron Langsner, PhD,](http://www.meronlangsner.com/about-meron.html) works in theatre, film, and opera, as a fight director, movement specialist and educator; he's also a stage director, playwright, and author. Lennox and Langser offer up some fascinating details about what it takes to stage a fight, and how they keep everybody safe."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452480084898/2016-01-10---West-Side-Story.jpg.jpg"
publishDate = "2016-01-12T09:00:00-05:00"
related_articles = ["articles/the-pianists-tech-week-plight.md"]
short_description = "Like much of rehearsing live theatre and opera, stage combat direction is one of those elements that goes unnoticed until done poorly. Enter the fight director, who specializes in staging duels, tussles, and brawls that looks like the real thing. Choreographing onstage combat can be a long and difficult task, resulting in a sequence that lasts minutes at most."
slug = "how-its-made-stage-combat"
title = "How it&#039;s made: stage combat"
+++

## What do you think makes the difference between an onstage fight that is so-so, versus believable?
 
**Meron Langsner**: There are two factors at work here, one is aesthetic and one is procedural. In terms of procedure, precision and rehearsal are key.  If the performers are hesitant or unsure, they'll struggle with the choreography and you will end up with a so-so fight.  It is not just that the performers need to rehearse the fight and have regular fight calls, they need to be doing them properly and have any issues addressed early on so that the fight can evolve with the rest of the production.  That said, the sooner the fight director is brought on, the better.

**John Lennox**: I would say the two major points would be the illusion of the hits, and the acting of the fight. If I see air between the combatants and one acts as though the hit landed, it takes me out of the illusion and I can’t really maintain believability as an audience member. Likewise, even if all of the hits actually appear to land, or the misses are covered well and they use [knaps](http://www.erickwolfe.com/Document/Terminology_and_Definitions_for_Hand_to_hand.pdf) to make great sound effects of impacts, but the actors have dropped character and are not committed to the scene, then I again will no longer believe that this is a real fight.

**Langsner**: Aesthetically, the fight needs to mesh dramaturgically with the rest of the production elements and (of course) with the story itself.  In an ideal circumstance, the audience should have difficulty determining where the director's work ended and the fight director's began.

## How do you make sure everyone stays safe in onstage combat?

**Langsner**: Safety is the first priority in fight direction.  Every technique has built in safety procedures designed into it.  Also, remember that we create the illusion of violence, not actual violence.  I often say that stage combat is much more a combination of ballroom dance and sleight of hand than it does any actual combat discipline. Also, it's very important to choreograph to the ability of the actors in the time allotted. To use the analogy of gymnastics, it is far better to do a 7 routine flawlessly than to fall on one's face while attempting a 10. Nothing is gained by trying to get a performer to attempt a move that is beyond them, or that they do not have the time to learn to execute properly.

**Lennox**: Constant rehearsing. Practice makes perfect. The moves are rehearsed for as long as possible at slow speeds to get the properly executed moves well into the muscle memory. Once that is there, we pick up speed a bit. Once that is sound, we pick it up a bit more. Usually “Tai Chi” speed or “Walking” speed, then ¼, then ½, then ¾, then performance speed. By the time we reach performance speed, they should have done it scores of times.

If given enough time on a job, I will work for several days with the actors training them in combat with the style they will use in the production. After they are comfortable with the style, then we move to choreographing the scene. I will take as much time as I am allowed for this. I once trained the actors for nine months for a production. If I only have two days, so be it. Often though, we don’t even get that. We usually get “You’ve got two hours to create and rehearse the fight.” At that point, I do good sequences, but not overly complex ones.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452475239139/2016-01-10---Langsner-Teaching.jpg.jpg)<figcaption>Meron Langsner teaching a workshop on Dramaturgy to the Choreographer Track students at the 2015 Summer Sling NYC Regional Stage Combat Workshop. Photo by Theik Smith Photography.</figcaption>
</figure>

## What do you find are some common hurdles for artists when developing their stage combat skills?
 
**Lennox**: Everyone is different, and they all have some issue or other that cause hurdles in developing their skills. Some of them have a general fear of weapons. Others are devout pacifists and therefore have a mental block against learning anything that involved violence. I can generally work around those to a degree. It all depends on how deep seated the anxieties or convictions are. The worst ones to deal with are those who already know everything and can’t possibly be taught by you. They are unbelievably annoying and are the most unsafe people in the business. Any other hurdles, skill level, lack of being comfortable with their bodies, etc. are all relatively easy to overcome.

**Langsner**: I find that there is an attitude that stage combat training is supplemental, when in reality it is some of the best acting training available.  This makes many performers take too little combat training too late in their training, or leave it too low on their priority list to ever be addressed and then regret it when they need to do a fight scene.  I actually wrote an [article on *Backstage*](http://www.backstage.com/advice-for-actors/backstage-experts/6-ways-fight-training-will-make-you-better-actor/) about fight training improving acting, and a [piece in *HowlRound*](http://howlround.com/why-everyone-should-study-stage-combat) that was a bit more in-depth.

**Lennox**: I would say that for the artist themselves a serious hurdle is finding a qualified instructor with whom to train on a regular basis. There are a lot of qualified instructors, but there are a lot of areas in the world where none exist. Finding one in close proximity with whom you can regularly train can be a difficult hurdle.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452553638821/2016-01-11---John-Lennox.jpg.jpg)<figcaption>Dr. John Lennox. </figcaption>
</figure>

## What challenges are unique to working with opera singers?

**Langsner**: The largest challenge is often that their physical training has received nowhere near the priority of their vocal training, so there is often less familiarity and more discomfort with the work.  This is changing as more conservatories are giving physical performance techniques a greater focus, but we aren't quite there yet. Beyond that, there is the obvious additional (and welcome) challenge of matching the movement to the music and making the fights fit the exact time allotted in the score.  This seems obvious to an audience familiar with opera, but remember that it is not really something we have to do in straight plays or most films. 

**Lennox**: I’ve only worked on one opera. I was honored to be asked by Jacques Cappelle, the fight director for the National Opera of Brussels to create a fight for a production of Il Trovatore in 2012. He is a sword master and they needed a street fight. That is my specialty. I was in town for a workshop for Jacques’ academy, so I created that fight for him. The biggest challenge in working with opera singers in a street fight style combat scenario is that you cannot do anything that goes near the throat- for obvious reasons. Past that, I never had any more difficulty working with them than I have with other professional performers. They did what I asked and worked hard to make it look like I did when I showed them each move. I have heard plenty of stories about diva attitudes, but I personally never experienced that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452475005220/2016-01-10---Meron-Fight-2.jpg.jpg)<figcaption> Meron Langsner choreographing LOVE HURTS, Malarkey Films' entry to the 2013 Boston 48 Hour Film Project</figcaption></figure>

## What do you enjoy most about your work?
 
**Lennox**: The fact that at the end of the day, actors are still able to work after having executed a grueling, realistic fight. I’ve heard of many actors getting seriously injured by combat they have done on stage - some to the point of ending their careers. I love the fact that actors in my fights look great and can still work the next day. I keep them safe and tell an incredible story with my work.

**Langsner**: It is collaboration and problem solving with swords.  What is not to love?
