+++
author = ["authors/greg.md"]
categories = "Op-ed"
date = "2014-04-15T10:23:00-04:00"
lastmod = "2017-08-28T10:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503931309181/2017-08-28---Greg-Boheme.jpg.jpg"
primary_image_credit = "Greg Finney as Alcindoro in AtG's La bohème, 2017. Photo by Darryl Block."
publishDate = "2014-04-15T10:23:00-04:00"
related_articles = ["articles/and-i-know-things-now.md","articles/the-life-of-a-comprimario-or-oh-youre-that-guy.md","articles/risky-opinions-there-are-2-types-of-singers.md","articles/5-ways-being-a-background-actor-helps-your-singing.md"]
related_people = ["scene/people/gregory-finney.md"]
short_description = "I remember when I first told my parents I wanted to be an actor. I had just performed in our school district’s Speech and Drama Festival and scored a near perfect mark for my portrayal of the Big Bad Wolf (of “Three Little Pigs” fame) telling the true account of what happened with those mischievous swine."
slug = "how-i-acted-my-way-into-an-opera-career"
title = "How I acted my way into an opera career"
+++

I remember when I first told my parents I wanted to be an actor. I had just performed in our school district’s Speech and Drama Festival and scored a near perfect mark for my portrayal of the Big Bad Wolf (of "Three Little Pigs" fame) telling the true account of what happened with those mischievous swine.

"Are you sure that's what you want to do?" asked my mother. "Yup." replied a pretty self-satisfied eleven-year-old me. "Why don't you get a real job, and do that on the side?" she asked. "Acting IS a real job." I replied.

The next fall I was enrolled in drama lessons and the rest is history.

If you had told that eleven-year-old Gregory that he would one day grow up to be not just an opera singer, but a pretty damn busy one – he would have laughed at you, said he hated opera and then would ask you to play Nintendo. Well look at me now kiddo, I'm averaging twelve to fifteen shows a year, with no representation. I got here by way of theatre, then musical theatre. Summers were spent at theatre camps, and winters spent in classes and lessons and rehearsals. By the time I was 18 I was the quintessential black-clad, dark haired, pale faced theatre-snob. Thankfully I was funny as heck.

I moved to Toronto in 2005 and sang in my first chorus ([Toronto Mendelssohn Choir and Singers](http://tmchoir.org/)) in 2006\. I made my Toronto debut in *A Funny Thing Happened On The Way To The Forum* the next year at [Hart House](http://harthouse.ca/hart-house-theatre/). Since then, my voice has taken me on a roller-coaster of a career path, until it settled back home, where I started singing "classical" baritone. No, I'm not a household name. No, I haven't been profiled by [*Opera Canada*](http://www.operacanada.ca/) or [Barihunks](http://barihunks.blogspot.ca/) (although I'm now Facebook friends with the latter). But I have sung everything from Tallis' _Motet in Forty Parts_ and Mozart's [_Le nozze di Figaro_](http://www.againstthegraintheatre.com/shows/figaro) (a LOT), to the Canadian premiere of [_Jerry Springer: The Opera_](http://en.wikipedia.org/wiki/Jerry_Springer:_The_Opera) and the world premiere of _Kamouraska_ by Charles Wilson. I've been blessed that I've been able to have such a busy, fulfilling schedule with minimal auditioning. I'm a "repeat offender" with most companies I've worked with ([Toronto Operetta Theatre](http://www.torontooperetta.com/), [Against The Grain Theatre](http://againstthegraintheatre.com/), [Opera In Concert](http://www.operainconcert.com/), [Opera By Request](http://operabyrequest.ca/wordpress/) and [LooseTea Music Theatre](http://looseteamusictheatre.com/)) which has given me the chance to work with the best in the industry.

How? Acting.

The thing a lot of us get caught up in when presenting our beloved art is the fact that it is theatre first, but the music is the most important thing. Follow me? No? Good.

The definition I use when people ask me to talk about opera is this: an opera is a play set to music where the dialogue is completely sung. The key point being that, it is and always will be a play. In the case of Opera, the playwright is now more than one person. The playwright is both the composer and the librettist, and the proper interpretation involves the language of music and the employ of good vocal technique. Let's not forget the importance of good vocal technique for the theatre actor as well. Heightened speech, such as that needed for theatre acting or orating is just as physically demanding as singing. Believe it or not, it's actually quite difficult to sustain speech to "the back of the hall" and it's a challenge that a lot of singers presented with spoken dialogue struggle with.

I was once in a masterclass with Carrol Anne Curry who said that the four pillars of a great operatic voice are Truth, Beauty, Depth, and Grandeur. I thought that was effing brilliant! Truth – the story, Beauty – the voice, Depth – its artful manipulation, Grandeur – the "size" of a voice. Before we get up in arms, I put "size" in quotation marks for a reason. Even the lightest soprano or tenor can have a largesse that carries them over the pit to the back of the "[fifth ring](http://en.wikipedia.org/wiki/Four_Seasons_Centre)".

What I really wanted to point out, was that in my opinion – someone who works regularly in the field – and that of an expert who gives master classes on the subject believe that the Truth of the story will only enhance the musical experience for both performers and audience members alike. It's this Truth that has everyone leaving the house satisfied and lining up to buy tickets to the next production.

Composers wrote opera for the theatre. Even if it was to be performed in a court ballroom, it was still acted out, in costumes, with props, etc. For us to assume that they didn’t take all this into account in writing the score would be ludicrous. They knew the art form very well and wrote for it accordingly. You can feel Cio-Cio San's fidelity and longing in the underscoring as she waits for Pinkerton.

As artists we have a duty to our audiences who are coming to the opera to present them amazing theatre with scores written by the best composers there were and are. _Even if_ the scores aren't great, or the text blows, or any number of other rationalizations we as performers find to excuse why we think people don’t want to come to the opera anymore, _this is our profession_. We do this better than anyone else and it's part of the job to do the proper work on everything. Bad material and antiquated approaches aren't helping matters, but Opera audiences are waning and that’s not the reason. The reason is we're failing them. We're giving them beautiful music, without the theatre – and that's not what they paid to see. Trust me, I've felt the difference between an audience listening to you and an audience feeling with you – and it’s something that I wouldn't trade for anything.

Yes, all the performing arts are feeling the crunch. There are a few standout companies, across all platforms that are clearly bringing people in. A large part of their successes are subject matter for another discussion, but they're getting butts in the seats by delivering a consistently satisfying theatrical experience for their audiences. We all have to get back to that and with certain new, young companies driving that focus shift, we’re in good hands. We just need more hands. A lot more hands, and get on with presenting Truth, Beauty, Depth and Grandeur through music and text.

And always remember: "The play's the thing."
