+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2015-12-10T22:28:00Z
lastmod = "2017-03-25T12:23:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490444441747/2017-03-25---Scoop.jpg.jpg"
publishDate = "2015-12-12T14:00:00+00:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md", "articles/quick-tips-the-rolled-r-test.md", "articles/the-opera-olympics-its-time.md", "articles/stop-shaming-adele.md"]
related_people = ["scene/people/renee-fleming.md", "scene/people/wendy-nielsen.md", "scene/people/mark-joelson-daboll.md"]
short_description = "Recently, one of our readers posed a question about that particular vocal technique, commonly (and charmingly) known as &quot;scooping&quot;. When a singer scoops up to a note, it means they start making sound on a pitch that&#039;s below the one they mean to sing. Pop singers do a similar thing, but usually with less vibrato. It&#039;s a stylistic choice, and it&#039;s often on a conscious decision by the singer."
slug = "hot-topics-singers-who-scoop"
title = "Hot topics: singers who scoop"

+++
Recently, one of our [readers](https://twitter.com/DundasKeele) posed a question about that particular vocal technique, commonly (and charmingly) known as "scooping". When a singer scoops up to a note, it means they start making sound on a pitch that's below the one they mean to sing. Pop singers do a similar thing, but usually with less vibrato. It's a stylistic choice, and it's often on a conscious decision by the singer.

Singers like Renée Fleming (dubbed "La Scoopenda" by her [clever critics](http://parterre.com/)), are notorious for their use of sliding starts, and it often goes: the bigger the voice, the larger the range of said scoop. A classic example is this performance of Fleming singing Violetta's Act I aria from _La traviata_ (specifically, the third note she sings):

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/IGlugsYQZgg" frameborder="0" allowfullscreen></iframe>
</figure>

"It's interesting to note that Fleming herself has acknowledged that she scoops on occasion in performances and makes no apology for it," says [Mark Joelson Daboll](/scene/people/mark-joelson-daboll/), singer, voice teacher, and founder of the online singing tool [Please Judge Me](http://pleasejudgeme.com/). Fleming in particular has risen to an echelon of star-status that critique over her use of scooping could tarnish her reputation as a technically-sound singer. Daboll, a fan of Fleming himself, suspects that "if Fleming were only 5-10 years into her career, her propensity to scoop would have hurt her professionally."

[Wendy Nielsen](/scene/people/wendy-nielsen/), Canadian soprano and sought-after vocal technician, hears scooping as a symptom of good technical intentions. "I think a lot of times people are trying to create the ultimate in legato line with good breath connection. You can even hear almost a shadow octave below with some larger voiced singers as they try to stay connected to the foot of their sound as they go into their upper range." (At about 0:30 of the video above, you can hear a great example of those "shadow octaves".)

Fleming is one of many singers who do make a conscious choice to approach a note cleanly, or to add an affective scoop. [Sherrill Milnes](/scene/people/sherrill-milnes/) is of the same ilk, and you can hear it in his singing of Rigoletto's "Cortigiani, vil razza dannata":

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/hPa1HvsSnGE" frameborder="0" allowfullscreen></iframe>
</figure>

You can hear a slight scoop into the first note, but you can hear later on (around 0:25) that he attacks the same pitch cleanly. It's not a default, or a technical crutch, and therein lies an important factor. Listen to this clip from _Peter Grimes_, sung by Jon Vickers:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/swi4m9wQa4g" frameborder="0" allowfullscreen></iframe>
</figure>

Vickers intones the first few phrases on the same pitch, and you can hear that some attacks are clean, and some are slightly scooped. His technique in this clip is really specific, so it's not quite the same as the _Carmen_ example; yet, you can hear him choosing specific words to bring out with a slight bend in pitch. When a singer has the ability to choose between scooping and not, there's an audible difference in affect that becomes available. Another example: Roberto Alagna singing "La fleur que tu m'avais jetée" from _Carmen_.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/txIrDNOJcj8" frameborder="0" allowfullscreen></iframe>
</figure>

Alagna is someone who scoops more than most, and we're not always convinced that his are decisions based on style. Whether or not you like how he hooks into the first note, you can hear the difference between this and the way [Jonas Kaufmann](/scene/people/jonas-kaufmann/) sings the same aria:

<figure data-type="video">
<iframe width="1010" height="568" src="https://www.youtube.com/embed/V1dafrlt10w" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</figure>

It's true that scooping can be a result of striving for technical success, yet it's not the only road to legato. "I sometimes encourage sliding in technical work for the very reasons listed above, for singers to sense the connection to the bottom of the sound as they go up in their range," says Nielsen. "Ideally, we don’t want to be aware of intervals rather the melody as a whole and, in my experience, \[legato\] occurs when each pitch spins."

For young singers, scooping can give an impression of a technique lacking in attention to detail; as they begin to audition for professional gigs, young artists are wise to err on the side of clean, yet malleable. "The rule for successful young singers is to keep their technique clean, efficient, and easy in execution," agrees Daboll. "Scooping immediately suggests to a clinician or vocal judge's ear that the singing is neither clean, nor efficient." Like all habits, scooping is easier to avoid the sooner a singer starts to pay attention to when and why it happens. Daboll suggests, "A general way to prevent scooping is to rewire the singer's brain to focus on the upcoming vowel/syllable _first_ (as per the way the brain naturally hears that word spoken in life), and then sing with the vowel - not the voice - directly to the appointed pitch."

Sort of like straight-tone or really _sotto voce_ moments, scooping is one of those luxuries that singers can start to use for aesthetic reasons (and they can get away with it more easily after some level of professional establishment). And honestly, sometimes you do want a bit of a scoop. Moments in Verdi, Strauss, even Mozart, call for something a bit more imperfect, more human. For us, Joseph Calleja's "La donna è mobile" from _Rigoletto_ is a little bit too clean.

<figure data-type="video">
<iframe width="1010" height="568" src="https://www.youtube.com/embed/BvcGAph-85E" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</figure>

Ah, moderation, that ubiquitous beast.