+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-11-19T13:36:00-05:00"
lastmod = "2018-11-30T13:08:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652498125/sqTamaraWilson_ILTROVATORE_LyricOperaofChicago_CamA-12.jpg.jpg"
primary_image_credit = "Tamara Wilson as Leonora in Lyric Opera of Chicago's production of Il trovatore, 2018. Photo: Lyric Opera of Chicago."
publishDate = "2018-11-20T21:40:00-05:00"
related_articles = ["articles/talking-with-singers-artur-ruciski.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/tamara-wilson.md", "scene/people/russell-thomas.md", "scene/people/jamie-barton.md", "scene/people/artur-rucinski.md"]
short_description = "The performance was something truly special and memorable. Last night, I understood what it must have been like to have heard the likes of Pavarotti, Milnes, Horne, and Sutherland. Just as those artists had defined the canonic Verdi roles for their generation, the cast of this Trovatore at LOC is poised to set a new standard for this repertoire."
slug = "history-making-cast-in-chicagos-il-trovatore"
title = "History-making cast in Chicago&#039;s Il trovatore"

+++
As I sat in Chicago's Lyric Opera House this past Saturday evening, basking in the glorious sounds of LOC's [*Il Trovatore*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/il-trovatore-opera-tickets), I recalled Enrico Caruso's famous and oft-quoted quip: "all it takes for a successful performance of *Trovatore* is four of the greatest singers in the world." 
 
I'm too young to have heard live performances by the legends of the mid- to late-twentieth century, but listening to the voices currently on stage at LOC, I felt like I was glimpsing that storied operatic past. The performance was something truly special and memorable. Last night, I understood what it must have been like to have heard the likes of Pavarotti, Milnes, Horne, and Sutherland. Just as those artists had defined the canonic Verdi roles for their generation, the cast of this *Trovatore* at LOC is poised to set a new standard for this repertoire. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652240589/ILTROVATORE_LyricOperaofChicago_CamB32.jpg.jpg)
<figcaption>A scene from *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Lyric Opera of Chicago.</figcaption>
</figure>
 
First and foremost, the LOC orchestra deserves ardent ovations for their consummate and consistent artistry, virtuosity, and versatility. The night before, the LOC orchestra was playing the closing performance of [*Siegfried*](/inflatable-beasts-vocal-brilliance-locs-siegfried/): Germanic, meat-and-potatoes music. Not twenty-four hours later, this same orchestra sounded as refined and fervent as any of Italy's great operatic ensembles. 

Conductor Marco Armiliato leads this run of *Trovatore*. After last season's breathtaking *Rigoletto*, I was thrilled to see him among this year's returning maestros. Renowned for his interpretations of the Italian repertoire and beloved by singers worldwide, Armiliato draws the absolute best qualities from vocalists while crafting an overall performance that is musically incisive and dramatically engrossing. I always hear and learn something new in this music when Armiliato is at the helm.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652258172/JamieBarton_ILTROVATORE_LyricOperaofChicago_LYR181114_188.jpg.jpg)
<figcaption>Jamie Barton (Azucena) in *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

As for the cast, pride of place must go to the sensational mezzo-soprano [Jamie Barton](/talking-with-singers-jamie-barton/) in the role of Azucena. The daughter of a gypsy sentenced to death for witchcraft, Azucena is forced to witness her mother burn on a pyre. As revenge against her mother's accuser, the Count di Luna, Azucena was to throw the Count's child into that same flame, but in her delirium, she mistakenly shoved in her own son. When we first encounter Azucena in the gypsy camp at the top of Act 2, she is a woman utterly shaken by her past and possessed by vengeance against the Count. In her opening number "Stride la vampa," Barton was remarkable in how she captured her character's emotional volatility. From stridency, to trauma, to guilt, to fury, Barton's performance was a masterclass in affective singing-acting. You could have closed your eyes and known exactly what this character was going through.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652271141/ArturRucinnski_ILTROVATORE_LyricOperaofChicago_LYR181114_074.jpg.jpg)
<figcaption>Artur Ruciński (Conte di Luna) in *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
As the Count di Luna, we heard the phenomenal Polish baritone [Artur Ruciński](/scene/people/artur-rucinski/), making his Lyric debut. I confess that, prior to this performance, I had not heard Ruciński. Now, I cannot get enough of him and, judging by the sustained ecstatic ovation he received, the Chicago audience felt similarly. When it comes to Verdian roles, comparisons to past greats are inevitable and, to my ears, Ruciński’s voice combines Milnes' emotive intensity with Hvorostovsky's sensual dark timbre. No one in the auditorium dared breathe during the Count's staple Act II aria, "Il balen del suo sorriso" — so alluring was Ruciński's voice and so elegant his phrasing. The audience erupted into applause and Maestro Armiliato tapped his baton in acknowledgment. If you haven't already, you would do well to look up Ruciński's CD recordings or videos on YouTube. I wish him a speedy return to Chicago!   

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652301746/TamaraWilson_RussellThomas_ILTROVATORE_LyricOperaofChicago_LYR181114_403.jpg.jpg)
<figcaption>Tamara Wilson (Leonora) and Russell Thomas (Manrico) in *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Opposite Ruciński and also making her Lyric debut was American dramatic soprano [Tamara Wilson](/scene/people/tamara-wilson/) as Leonora. As the doomed heroine, Wilson was a vision of vulnerability and heartbreak. One the one hand, one's heart was pulled hither and thither in sympathy as she herself was thrown around emotionally (and physically) on stage. On the other hand, vocally, Wilson more than stood up to her male colleagues. It would be meaningless to speak of vocal pyrotechnics because Wilson handled the role's myriad technical challenges with aplomb, artfully negotiating the corners of phrases and polishing any edges into a fine sheen. Hers was simply singing on an entirely other level even as far as A-house sopranos are concerned — indeed, the kind of singing to which others will be compared in the future.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542652392590/RussellThomas_TamaraWilson_ArturRucin%CC%81ski_ILTROVATORE_LyricOperaofChicago_LYR181114_094.jpg.jpg)
<figcaption>Russell Thomas (Manrico), Tamara Wilson (Leonora), Artur Ruciński (Conte di Luna) in *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Having previously sung Pollione in LOC's 2016/17 production of *Norma*, American tenor Russell Thomas returns to Chicago as Manrico in this *Trovatore*. Although there were moments when his tone bordered on barky, there’s no denying that Russell is a brilliant tenor with star power and a stage presence to match. Especially gripping was his Act III aria-cabaletta "Ah, si ben mio…di quella pira." 
 
Yes, *Trovatore* is canonic opera repertoire, and, yes, it has its notorious plot holes, but for the sheer quality of the singing, I would happily hear this opera again and again — I can't recall a production with a more awesome across-the-board cast. This is a must-hear show! Director Roy Rallo spearheads this revival of the now-classic Sir David McVicar production, which [runs at LOC until December 9](https://www.lyricopera.org/concertstickets/calendar/2018-2019/il-trovatore-opera-tickets).