+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2023-06-04T02:00:00+00:00"
lastmod = "2023-06-04T02:00:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1685916500/sqLOTNY_Am.jpg"
publishDate = "2023-06-03T01:00:00+00:00"
related_articles = ["articles/trade-mary-motorhead-music-in-the-background.md"]
related_companies = ["scene/companies/little-opera-theatre-of-ny.md"]
short_description = "The relationship between Bob, Mary and Nate is completely convincing thanks to the outstanding performances of Mr. McNichols Jr., Ms. Crump and Mr. Morgans, respectively. Their voices are ascendant; they master both the height and width necessary for composer Still's score."
slug = "highway-1-usa-and-down-in-the-valley-unearthing-americana"
title = "Highway 1, U.S.A and Down in the Valley: Unearthing Americana"
+++
[the little OPERA theatre of ny](/scene/companies/little-opera-theatre-of-ny/), in association with Harlem Opera Theater and National Black Theatre brought _American One Acts, a double bill_, to the Baruch Performing Arts Center and while both operas were dated pieces of Americana, one was certainly worth the effort.

One of the goals, no doubt, was to expose audiences to the unfamiliar work of William Grant Still (1895-1978,) who wrote close to two hundred classical compositions, including _Highway 1, U.S.A._ and some eight other operas. He is the first black composer whose work was performed by a major American opera company (New York City Opera.) Considered part of the Harlem Renaissance of black artists who thrived during the 1920s and 1930s, Grant wrote _Highway 1, U.S.A._ in the 1940s, but it wasn't performed until the 1960's. It seems to be finding a new life with performances here in New York and next season with the [LA Opera](/scene/companies/los-angeles-opera/).
 
The works of Copland, Barber, Bernstein, Gershwin and the assimilated Kurt Weill are all instantly recognizable as American composers, infused as they are with the home-grown sounds of folk music and jazz. So, too, is William Grant Still with his jazzy score for _Highway 1, U.S.A._ which advertises its origins right there in the title.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1685916502/LOTNY_Am_1.jpg){{% /md %}}

<figcaption>Mary (Lynnesha Crump) with Bob (Robert McNichols, Jr.) in Highway 1, U.S.A. / American One Acts, a double bill, little OPERA theatre of ny, 2023. Photo: Tina Buckman.</figcaption>
</figure>

His frequent collaborator (and wife) Verna Arvey, wrote the libretto and it proves to be very moving in its simple story (brought to life by music that is at once simple and complex.) Mary and Bob (soprano Lynnesha Crump and baritone Robert McNichols Jr.) run a gas station and they believe that their hard work is propelling them toward the comforts of "the American dream". They're a highly devoted couple, completely dependent on one another and their feelings are clearly expressed in their opening duet and arias. Their love is the perfect set-up for the near tragedy that's about to unfold.

The third wheel here is Bob's brother Nate (tenor David Morgans,) a ne'er do well who thinks he's smarter than everyone but, in fact, he's a lech and a leech who can't do anything without Bob's money. Mary is wary that Nate will ruin things, but Bob had promised his deceased mother that he would take care of Nate no matter what.

Nate doesn't even appear until the story moves to "one year later" and the well-crafted story builds up the anticipation of seeing him. Nate tells Mary that there is a clear line between himself and Bob – "What does he know of dreams?" he sings. Nate also sings of his superiority, telling Mary that he thinks of more "lofty" things than those around him. Nate puts the moves on Mary, convinced that she will run away with him. But her passion for Bob proves to be unwavering and she angrily laughs off Nate's advances. Nate's narcissism won’t allow this, and he stabs her. When Bob returns, he begs Bob to take the rap for him and Bob, remembering the vow to his mother, agrees. The sheriff and the townspeople enter to hear Bob's "confession".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1685916502/LOTNY_Am_2.jpg){{% /md %}}

<figcaption>Aunt Lou (Isola Jones) with Mary (Lynnesha Crump) in Highway 1, U.S.A. / American One Acts, a double bill, little OPERA theatre of ny, 2023. Photo: Tina Buckman.</figcaption>
</figure>

The plot twist that follows is a little hard to believe. Mary, it turns out, isn't dead – no one bothered to take her pulse - they just assumed that her wound was fatal. She "wakes up" and indicts Nate as the real perpetrator. He's arrested and everyone clears the stage so that Mary, evidently not in need of a doctor or a single stitch, sings a moving final duet with Bob, a re-declaration of their love.

Though the plot gets a little silly, the relationship between Bob, Mary and Nate is completely convincing thanks to the outstanding performances of Mr. McNichols Jr., Ms. Crump and Mr. Morgans, respectively. Their voices are ascendant; they master both the height and width necessary for composer Still's score.

Unlike Mr. Still's composition, however, _Down in the Valley_ is an unearthed work that should go back into Mr. Weill's trunk. Startlingly similar in plot to _Oklahoma!_, which was written a couple of years prior, _Down in the Valley_ doesn't benefit from the tunes of Rodgers and Hammerstein. Mr. Weill, who is no stranger to a great melody, instead uses American folk songs here, albeit with unconventional arrangements. In addition to the famous song in the title, "Down in the Valley", Mr. Weill also interpolates the traditional folk songs "The Lonesome Dove", "The Little Black Train", "Hop Up, My Ladies", etc.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1685916500/LOTNY_Am_3.jpg){{% /md %}}

<figcaption>The ensemble in Down in the Valley / American One Acts, a double bill, little OPERA theatre of ny, 2023. Photo: Tina Buckman.</figcaption>
</figure>

We know from the opening strains of the minor key chosen for the melody of "Down in the Valley", that something terrible is going to happen. Even when the chorus switches into the well-known major key of the song, the orchestra remains threatening with its dissonance. We're introduced to Brack Weaver (baritone Kyle Oliver) who is awaiting execution for the murder of Thomas Bouché (bass-baritone Andrew Richardson.) He sings of his love for Jennie Parsons (mezzo Sarah Nelson Craft) and escapes to reunite with her.

From this point forward the show invokes _déjà vu_, although we instantly know why. Brack and Jennie reminisce about how they fell in love while going to a country dance. We then see in a flashback how a jealous Bouché starts a fight and Brack winds up stabbing him to death. Yes, "poor Jud is dead", and Brack winds up on death row. Not a Broadway musical ending, but the derivative plot by librettist Arnold Sundgaard and the pastiche score by Mr. Weill don't offer anything that we haven't seen or heard before.

Mr. Oliver is asked to hit a few high notes but his voice is efficacious when it remains in the baritone lane. Ms. Craft's creamy mezzo, on the other hand, is right where it belongs, and she is touching as she sings of Mary's yearning and heartbreak.

Mr. Richardson is quite good as Bouché, his voice perfect for the loud and boisterous villain. Baritone Ron Lloyd, who has a strong cameo as the Sheriff in _Highway 1, U.S.A_, is equally impressive here in the larger role as Jennie's Father.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1685916500/LOTNY_Am_4.jpg){{% /md %}}

<figcaption>Bouché (Andrew Richardson) fighting Brack (Kyle Oliver) in Down in the Valley / American One Acts, a double bill, little OPERA theatre of ny, 2023. Photo: Tina Buckman.</figcaption>
</figure>

Performed in true repertory fashion, the entire cast appears in both halves of the double bill. The principals and the ensemble change places, however, and the result is that the chorus in both shows has a powerful presence (except for when they're called upon to perform some anemic and under-rehearsed choreography.) _Down in the Valley_ showcases the chorus best in the gospel tune "The Little Black Train" (with a knockout solo by Karmesha Peake,) and in the final reprise of the title song: as Brack walks toward his execution and "into the light", the chorus sounds heavenly.

In both operas, the string section struggled a little with uncertain pitch on some entrances, but overall the seasoned baton of eminent maestro Gregory Hopkins was in command of the twenty-two piece orchestra.