+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-03-07T06:10:00-05:00"
lastmod = "2017-04-20T09:06:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492693535109/2017-04-20---Soubrette.jpg.jpg"
publishDate = "2016-03-07T08:06:00-05:00"
related_articles = ["articles/who-are-our-comprimarias-why-arent-they-funnier.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/taking-a-bow-curtain-calls-for-your-voice-type.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/tracy-dahl.md","scene/people/jane-archibald.md","scene/people/danielle-de-niese.md"]
short_description = "A soubrette is like a moving target, where casting depends on everything around her; in one house, a soprano may be a Nannetta, and elsewhere she&#039;s Alice Ford. The term &quot;soubrette&quot; is more of a convenient appendix tacked on to the larger context of what a singer can do. So, soubrettes, we hope you&#039;re taking these roles like the compliments they are."
slug = "hidden-secrets-of-the-soubrette"
title = "Hidden secrets of the soubrette"
+++

Recently we came across a [curious post](https://www.reddit.com/r/singing/) on Reddit, specifically in [r/singing](https://www.reddit.com/r/singing/), from someone who had learned a rather skewed idea of the soubrette:

>"I did some research and saw that mezzos and young sopranos are cast in these roles, that they're the ones that can't quite do the extensive coloratura, don't have the weight of the main characters, and don't have an extensive range. They seem so defined by what they CAN'T do that I can't help but wonder... are they the ones that are pretty but can't quite do the big stuff so you give them the side characters that other sopranos and even mezzos can cover without much problem??"

Now, who knows where the poster got her information about the soubrette *Fach*, and since we're advocates of all types of singers, our instinct is to find the positive version of these voice-type classifications.

"Soubrette", in its simplest definition, is a French term that means "maid". The definitive list of *Fachs*, from Rudolph Kloiber's [*Handbuch der Oper*](http://www.amazon.co.uk/Handbuch-Oper-Rudolf-Kloiber/dp/3423341327) includes the soubrette, or "Charactersopran", and voices of this nature are often young, bright, and agile. Acting chops are a must-have for soubrettes, too, since there's an interesting link between playing maids and general help, and being quick-witted and funny.

Here's a short list of roles that qualify as "soubrette":

<ul class="nospace">

<li> Zerlina (*Don Giovanni*)
<li> Blondchen (*Die Entführung aus dem Serail*)
<li> Ännchen (*Der Freischutz*)
<li> Adele (*Die Fledermaus*)
<li> Susanna (*Le nozze di Figaro*)
<li> Despina (*Così fan tutte*)
<li> Belinda (*Dido and Aeneas*)
<li> Marzellina (*Fidelio*)
<li> Papagena (*The Magic Flute*)
<li> Oscar (*Un ballo in maschera*)
<li> Nannetta (*Falstaff*)
<li> Sophie (*Der Rosenkavalier*)

</ul>

These ladies can certainly steal the show, yet with the exception of Susanna, these aren't leading roles. Yet some sources also include Norina in *Don Pasquale*, Adina in *L'elisir d'amore*, and even Musetta in *La bohème* as soubrette roles; for some reason, though, it would be slightly insulting to refer to these substantial roles as for a soubrette.

It's not difficult to imagine one singer being able to sing all of the roles listed above, perhaps with the exception of Blondchen (not everyone has a high E). Really, the only thing in common with these soubrette roles is the fact that their characters are of lower status, many of them actual maids.

Anyone casting a Zerlina or an Adele knows that they're not dealing with a pool of singers who "can't" do a lot of things; roles like Susanna and Despina need to have serious acting abilities, and tons of facility with Italian in order to wade through the pages and pages of recit. Adele and Blondchen are two roles that are now defined by their coloratura and high singing, and the arias for Zerlina and Marzellina are often in a slightly-in-the-cracks register for both sopranos and mezzo-sopranos.

When we're talking about young singers, the perceived "limitations" of the soubrette repertoire is a moot point. Perhaps it's true that the 21 year-old soprano was cast as Papagena and not Pamina, but there's a lot of sense in that hypothetical; it usually takes longer than one's early 20s to develop the stamina and technique needed for larger roles, not to mention facility with language and musical style. The only hitch in the system is the fact that many of these smaller, soubrette roles demand a high level of acting, and that's something that can take arguably longer to develop than even the voice. 

At the professional level, soubrette roles are all about the hidden secrets of the singers performing them. Supporting roles like Giannetta in *L'elisir* are often Adinas-in-training, and Oscar in *Un ballo* still needs to sing Verdi, over a Verdi orchestra. Sophie in *Der Rosenkavalier* is young, of course, but her singing takes a grown woman's skill and technique. A few years ago we heard [Tracy Dahl](/scene/people/tracy-dahl/) sing Despina in *Così fan tutte*, and anyone who knows her career has heard her vocal pyrotechnics in roles like Zerbinetta, Madame Mao, and Cunegonde. 

We say all of this to put some soubrette love out into the universe, and to illuminate the real demands when it comes to vocal *Fachs*. Soubrette roles ask a lot of the singers, and it's not a voice type of negatives. What a role demands is rarely the sum of a singer's skills. Zerlinas can sing Sesto as readily as they can sing Lucia di Lammermoor. Despinas sing Cleopatra, and Blondchens sing Olympia. Conversely, Zerbinettas sing Susanna, Rosinas sing Giannetta, and Musettas sing Barbarina.

A soubrette is like a moving target, where casting depends on everything around her; in one house, a soprano may be a Nannetta, and elsewhere she's Alice Ford. The term "soubrette" is more of a convenient appendix tacked on to the larger context of what a singer can do. So, soubrettes, we hope you're taking these roles like the compliments they are. You've been cast as the funny one, the smart one, the sensible maid to a mistress with serious problems.

Recently [we wrote about hypothetical "comprimarias"](/who-are-our-comprimarias-why-arent-they-funnier/), the feminine answer to the comprimario tenor and bass roles that are so beloved by audiences. Perhaps the answer is much simpler than we originally thought; since Kloiber's "soubrette" includes "Charactersopran", does that mean "comprimaria" is a better synonym? 

At least with that term, there's no mention of being a maid.
