+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2021-11-05T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1636122898/media/2021/11/sqHGOCarmen_LynnLane-103_rvklq6.jpg"
primary_image_credit = "Carolyn Sproule (Carmen) and Richard Trey Smagur (Don José) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane."
related_articles = ["articles/carmen-don-juan-and-gender-reversal-pants-roles-indeed.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/lidiya-yankovskaya.md", "scene/people/christian-pursell.md", "scene/people/blake-denson.md", "scene/people/sun-ly-pierce.md", "scene/people/raven-mcmillon.md", "scene/people/richard-trey-smagur.md", "scene/people/carolyn-sproule.md", "scene/people/heidi-stober.md"]
short_description = " Everything about this production went out of its way to imbue the whole with artistic cohesion and integrity, even the elements that might have seemed vaguely avant-garde out of context."
slug = "hgo-carmen-the-epitome-of-unity"
title = "HGO Carmen \"the epitome of unity\""
youtube_url = ""

+++
The [Houston Grand Opera](/scene/companies/houston-grand-opera/) has chosen a winner in [_Carmen_](https://www.houstongrandopera.org/events-tickets/2021-22-season/carmen/) for its return to the stage at a time when unity is definitely at a premium. For all this work's ubiquity and universal appeal, HGO made an excellent case in Rob Ashford's production for its renown being no mere _pro forma_ concession, not an honor bestowed upon "the French opera that everyone does to virtue-signal about French opera." Everything about this production went out of its way to imbue the whole with artistic cohesion and integrity, even the elements that might have seemed vaguely _avant-garde_ out of context.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636122967/media/2021/11/HGOCarmen_LynnLane-300_hdnhbg.jpg){{% /md %}}

<figcaption>Dancers in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

Conductor [Lidiya Yankovskaya](/scene/people/lidiya-yankovskaya/), making her debut with the HGO orchestra, gave them full rein to express their triumph at finally making live music again, yet always making everything in Bizet's score feel spontaneous, with even chamber-music levels of intricacy when required. I particularly felt that the Act III Intermezzo was exquisitely sculpted, with the instruments being deftly added in one at a time like organ stops. In short, I got the impression that the whole score was the perfect mix of Offenbach and Beethoven, and that Bizet, had he lived longer, would surely have written another symphony to rival even that of Franck. All the froth one could ask for, with absolutely no frivolity or complacency.

Notable in this production were a troupe of regularly-occupied dancers who were regularly engaged in many virtuosic interludes. Standing in for the chorus on many occasions, as the director was frequently content with having the latter "park and bark in unison" even in agitated moments where their individuality might better contribute to the tableau (more New York than naturalistic), they nevertheless helped the production feel quite energetic indeed. This did lead to the most delightfully eccentric changing of the guard that one might ever see outside of _La grande duchesse de Gérolstein_. If only these dancers were available for more operas with purely balletic episodes… Peter John Chursin particularly stood out for his portrayal of a large bull which appears at telltale moments representing destiny in a way that absolutely put the spotlight on this concept being as much a manifestation of the characters’ hostile projections as anything.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636122996/media/2021/11/HGOCarmen_LynnLane-57_en63el.jpg){{% /md %}}

<figcaption>Heidi Stober (Micaëla) and Richard Trey Smagur (Don José) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

The production's set design had an agreeable rusticity which absolutely screamed "French Savoy Opera", or at very least, projected a family-friendly veneer with absolutely no foreshadowing of any of the action to happen. Or so one might think if it were not for the fact that the walls were subtly arrayed in such a dread manner as to make cast members feel enclosed, vulnerable, entrapped. But it would be up to people with such malign intentions to thus employ the partitions anyway, hence building on this opera's multifaceted dichotomy of free will versus fate.

Such was the atmosphere at the start as the very lustful and even misogynistic soldiery assembled at the start, led by a very affable yet intimidating and lustful Moralès ([Blake Denson](/scene/people/blake-denson/)), who has clearly played this game before. Micaëla ([Heidi Stober](/scene/people/heidi-stober/)) was certainly in peril from the very start, any operatic fictions notwithstanding. Although such an angle could easily have overwhelmed the whole opera with a modern socio-political agenda, I am pleased to say that it was kept at a subtle undercurrent throughout, always implied, never denied, and this opening scene was all that was needed to make the point stick. Zuniga ([William Guanbo Su](/scene/people/william-guanbo-su/)) in particular kept this malign atmosphere pervasive, clearly showing this veteran officer having known one or two Carmens in his own day.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636123035/media/2021/11/HGOCarmen_LynnLane-50_kad2j3.jpg){{% /md %}}

<figcaption>Carolyn Sproule (Carmen) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

Carmen ([Carolyn Sproule](/scene/people/carolyn-sproule/)), for her part, was played as a somewhat wraith-like figure, moving ominously around the stage, at least from the viewpoint of her observers. The director enjoyed getting her to wander all around the stage to create a symbolist picture of her real role throughout the whole work, and we certainly enjoyed seeing her at her most profound, yet never expressing everything. For all we know, Carmen is just enjoying her existence, and Sproule was excellent at playing the role of someone who engages in the vocal equivalent of idle talk, ambling about and not meriting any blame for other people's overinterpreting her utterances. (Emblematically, when Carmen is arrested, Sproule is excellent at giving an impression of mumbling, speaking in two different voices, never being as direct as people are expecting.) This is definitely one of the reasons that the libretto can easily be compared to Strindberg for stereotypical misogyny, and yet Sproule imbued it with the requisite dignity that makes this opera a masterpiece open to interpretation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636123057/media/2021/11/HGOCarmen_LynnLane-142_aiskbn.jpg){{% /md %}}

<figcaption>Christian Pursell (Escamillo) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

Throughout this production, [Richard Trey Smagur](/scene/people/richard-trey-smagur/) excelled in his dramatic portrayal of Don José, and his appearance changed very effectively from one minute to the next to reflect his development. From upright rural soldier to demented obsessive, this was an intensely believable and theatrical process for anyone to witness. "La fleur que tu m’avais jetée", while evidencing a somewhat tenuous upper register in places, was nevertheless a perfect representation of this character's conflict, even though his problems are self-inflicted, so I could definitely read the emotional strain of the role into this aria in a very convincing manner. Certainly he comes across as a country boy who is lost in an urban environment and who was never educated in impulse control.

Micaëla would have been good for him, and Heidi Stober was very convincing in her portrayal of "village sweetheart lost in the big city not used to the attentions of all these urban males". Her acting was an effective complement to her character's self-sacrificial instincts, with her performance of "Je dis que rien ne m'épouvante" being superbly wrought and shaped with no trivializing inhibitions whatsoever.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636123081/media/2021/11/HGOCarmen_LynnLane-318_rhkzav.jpg){{% /md %}}

<figcaption>Christian Pursell (Escamillo) and Carolyn Sproule (Carmen) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

It should come as no surprise that Escamillo ([Christian Pursell](/scene/people/christian-pursell/)) was played up as the perfect contrast to the ideal of rustic domesticity, someone completely self-assured and dignified in the dangers of city life, even with a prepossessing exterior exuding politesse and refinement, but never wasting an opportunity to engage in some shameless marketing in the mountains. In other words, he was very much the equal of Carmen's shady smuggler companions, just with celebrity hustle and sparkle. With a resonant yet surgically precise baritone voice to match this conception, Pursell is assuredly someone I will be watching in future, as the one thing he definitely radiates is versatility!

(And as for those smugglers, Luke Sutliff (Dancaïro) and Ricardo Garcia (Remendado) were definitely wide-eyed enough, the former especially so, to execute any scheme with nimbleness of voice and limb!)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636123105/media/2021/11/HGOCarmen_LynnLane-242_atccvd.jpg){{% /md %}}

<figcaption>Carolyn Sproule (Carmen) in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

The Houston Grand Opera Chorus was clearly happy to be back, and they had many opportunities to shine, even if the pervasive myth that French can only ever be approximated _en masse_ was as ever difficult to evade. I particularly found the ladies' hairpieces very intriguing, serving as they do a dual representation: first, of the men's projections of "this is what cigarette girls look like, let us have our fun with them." They certainly have to be almost imaginary because such hairpieces would be quite dangerous around pre-regulation factories, although they were more eccentric hairpieces than the imitations of Louis XV wigs worn by the visibly extravagant Frasquita ([Raven McMillon](/scene/people/raven-mcmillon/)) and Mercédès ([Sun-Ly Pierce](/scene/people/sun-ly-pierce/)). Talk about projection! Second, these hairpieces were representational of the plot as a whole, wherein Don José projects so many of his frustrations onto Carmen, for all the musical themes that would have us believe that Fate is unavoidable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636123201/media/2021/11/HGOCarmen_LynnLane-81_gnriqb.jpg){{% /md %}}

<figcaption>William Guanbo Su (Zuniga) and the HGO Women's Chorus in Carmen, Houston Grand Opera, 2021. Photo: Lynn Lane.</figcaption>  
</figure>

I could easily go on, but this is the most perfectly encapsulated example of the numerous effective ways in which [this production](https://www.houstongrandopera.org/events-tickets/2021-22-season/carmen/) shines a light onto all the many perspectives it is possible for _Carmen_ to have, so as to appeal to people witnessing it from any conceivable angle and willing to engage with this masterwork on its own terms and not merely its most provocative stereotypes. Is not this the epitome of unity in these times?