+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-03-29T09:11:00+01:00"
lastmod = "2016-03-29T11:34:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459245328057/2016-03-29---Front-Door.jpg.jpg"
publishDate = "2016-03-29T11:09:00+01:00"
related_articles = ["articles/music-the-musicians-therapy-except-when-its-not.md","articles/the-heart-and-the-art.md","articles/in-defence-of-singers.md"]
short_description = "To singers and others immersed in opera, this may seem like a surprising way for people to seek therapy; our first reaction was to go through a mental list of arias, and imagine what operatic excerpts would serve to help people with their modern-day problems. It&#039;s an amazing test of time for the repertoire, and for the singers, who choose arias for people going through romantic troubles, problems with children or parents, bereavement, symptoms of depression, or the good old &quot;sick of being single&quot;."
slug = "helpful-singers-opera-does-house-calls"
title = "Helpful singers: opera does house calls"
+++

We recently caught [Tim Jonze's article](http://www.theguardian.com/music/2016/mar/27/home-therapy-opera-singers-anxious-stressed-ease-worries) for *The Guardian* about [Opera Helps](http://www.operahelps.com/), a UK-based project started by artist and opera enthusiast [Joshua Sofaer](http://www.joshuasofaer.com/2016/02/opera-helps-uk-tour/). The premise is beautifully succinct: if you're feeling down, stressed, or burdened by a problem, you can [fill out an application](http://www.operahelps.com/#apply), and Opera Helps will respond. "If we can meet their needs, a professional opera singer will visit their home and listen to the problem. Then the singer will select the aria that relates to the problem. The aria will be sung to the participant as they relax in their preferred room."

To singers and others immersed in opera, this may seem like a surprising way for people to seek therapy; our first reaction was to go through a mental list of arias, and imagine what operatic excerpts would serve to help people with their modern-day problems. It's an amazing test of time for the repertoire, and for the singers, who choose arias for people going through romantic troubles, problems with children or parents, bereavement, symptoms of depression, or the good old "sick of being single".

Sofaer is clear that the singers who make house calls on behalf of Opera Helps are not trained therapists, and they stick to empathy and asking questions instead of offering advice or judgement. On first hearing, it seems like a big ask for an opera singer, who arguably has a very different set of developed skills than a therapist or life coach. But actually, when it comes to empathy, listening, and just "being there" for someone in need, singers are more qualified than most.

## Singers know vulnerability

Professional singers have been trained in the art of public vulnerability. Some singers come by this quality more naturally than others, but all of them are well-versed in standing in front of an audience and spilling out their feelings. They spend hours in rehearsal trying, failing, and trying again. They get criticism from all angles and at all stages of their work: the audition, the rehearsal process, and the post-show reviews all come with opinions and demands, hurled in the direction of these singers.

So, they're an empathetic bunch. They know what it means to feel inadequate, frustrated, unappreciated. They also know that relief can come when there's someone around to listen, without offering feedback. (Note: perhaps that's why we're such big fans of [*Overthought: A Podcast*](http://www.overthoughtpodcast.com/).) 

## Singers are great listeners

It's part of a singer's most basic set of skills to be an excellent listener. They have great ears that help them sing in tune and on time, of course, but they're also well-versed in taking verbal notes at work. Their jobs require them to listen to what's being asked of them, and put it in context with what they know they can do. They also develop skills in asking questions, including knowing when to ask none at all.

When a singer is learning a role, they begin with the text. The primary layer of their character is revealed with their words, and singers learn to piece together a complete person from their lines, be they few or many. It's not quite the same as a therapist, unpacking patterns over hours of conversation with patients, but it's rooted in the same attention to detail.

## Singers know stress

Singers are presented with a lot of choices in their lives, choices that often stress people out. They have a demanding career that can make it difficult to maintain steady relationships with friends, family, and partners. Their work is extremely competitive, and it comes with a nomadic lifestyle that often leaves them to deal with new places and new audiences, alone.

So, they're acutely aware of how valuable it is to have someone to talk to. Venting to someone trustworthy, who won't necessarily offer advice or personal anecdotes, is hugely valuable for a singer's well-being, and by extension, their work. Singers meet each other as they travel from gig to gig, and they share common ground as fellow independent nomads; it means that they meet people from all over the world, leading lots of different lives. As is the case with most people who gain a broad view of the world, singers are notably not in the business of judging others, especially those who are going through their own tough times.

## Singers want their music to help people

Arguably, singing for a listener who has actively sought out a type of therapy via opera is what we would call a Dream Gig. We have [asked hundreds of singers](http://www.schmopera.com/categories/interview/) why they do what they do, and they all have a desire to communicate, to share the power in their music with others. If singers can send to their listeners one small part of the passion and humanity that they find in the characters they play, they can call that a day's work. 

Singers may not be therapists *per se*, but you can generally count on getting a quality product from someone who's passionate about what they do. Opera Helps is kind of an ingenious combination of a product (being music, singing, opera, whatever) finding its true target audience; in this case, the audience is requesting the kind of help that singers believe wholeheartedly exists in their music.

<figure data-type="video">
<iframe src="https://player.vimeo.com/video/151509561" width="500" height="281" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
</figure>

>If you're in the UK, you can apply for a visit via Opera Helps. [Click here](http://www.operahelps.com/) to find out more.
