+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2018-02-07T11:29:00-05:00"
lastmod = "2018-02-07T16:15:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518020949716/sq---hgo---the-barber-of-seville---2018---photographer-lynn-lane-142-3000x2000.jpg.jpg"
primary_image_credit = "Sofia Selowsky (Rosina) and David Portillo (Count Almaviva) in Il barbiere di Siviglia, Houston Grand Opera, 2018. Photo: Lynn Lane."
publishDate = "2018-02-07T16:15:00-05:00"
related_companies = ["scene/companies/houston-grand-opera.md"]
short_description = "At any rate, the production focuses on the perennial problem of &quot;finding good help these days;&quot; do the servants really care about their employers&#039; tribulations? Is it any wonder that Bartolo&#039;s (Peixin Chen) house is falling apart? Indeed, the Houston Grand Opera Chorus were skilled at portraying a motley group of musicians who just need to keep their voices down once in a while, lest they attract the attention of the bayonet-armed, plume-graced Seville gendarmes."
slug = "help-wanted-els-comediants-bring-barber-to-houston"
title = "Help wanted: Els Comediants bring Barber to Houston"
+++

The year 1816 was undoubtedly one of the most important ones for opera as we know it, largely because of the 24-year-old Gioachino Rossini. Not only did he revolutionize the world of serious opera with the Naples premiere of his masterful *Otello*, which transformed onstage death in Italian opera (a very French thing) into a trend that would last the entirety of the century, but he had also earlier that year in Rome bequeathed onto the musical world one of his final Italian comic operas, *Il barbiere di Siviglia*, the exemplar of the genre. Though I am indeed inclined to view his serious operas as more musically inspired, indeed, as better compositions, [Houston Grand Opera's performance](http://www.houstongrandopera.org/thebarberofseville) of this on Mendelssohn's birthday was quite genial. Certainly the fact that HM King Felipe VI had recently celebrated his 50th birthday served to put me in a very good mood to appreciate it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037028761/hgo---the-barber-of-seville---2018---photographer-lynn-lane-215-3000x2000.jpg.jpg)
<figcaption>Yelena Dyachek (Berta), David Portillo (Count Almaviva), Sofia Selowsky (Rosina), Lucas Meachem (Figaro) and HGO Supernumeraries in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Indeed, the production of the Barcelona-based troupe, Els Comediants, was whimsical enough to remind me of many a French production, for which I do acknowledge a partiality. The production took more cues from Cesare Sterbini's excellent libretto than from Rossini's music, which was content to stay out of the way of the onstage action. Indeed, I did not find the numerous supernumeraries distracting, as might otherwise be the peril in such cases: music enthusiasts could listen to vocal pyrotechnics, and theatre fans could watch the otherwise extraneous antics surrounding them; I was happily able to switch my focus between the two without difficulty and at will.

These supers, including a particularly ominous and ubiquitous duenna, were helpful more in their implications than in their actions per se. There are not many operas which could bear such treatment with ease, and admittedly, the scope of these supers' antics was limited by the unexpectedly small venue. But I found that the humorously maladroit poses in which singers found themselves did not in any way demonstrate a director's supposed lack of faith in the prodigious musical material, but rather an acknowledgement of said, while also placing credence in an equally and uncommonly buoyant and self-referential libretto which happens to have great music as its underpinning.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037042390/hgo---the-barber-of-seville---2018---photographer-lynn-lane-8-2-3000x2000.jpg.jpg)
<figcaption>David Portillo (Count Almaviva) and HGO Supernumeraries in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

At any rate, the production focuses on the perennial problem of "finding good help these days;" do the servants really care about their employers' tribulations? Is it any wonder that Bartolo's (Peixin Chen) house is falling apart? Indeed, the Houston Grand Opera Chorus were skilled at portraying a motley group of musicians who just need to keep their voices down once in a while, lest they attract the attention of the bayonet-armed, plume-graced Seville gendarmes. Offenbach's General Boum would definitely be envious of these panaches, particularly that of their quite sleazy and corruptible mustachioed commanding officer (Sol Jin).

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037070725/hgo---the-barber-of-seville---2018---photographer-lynn-lane-52-3000x2000.jpg.jpg)
<figcaption>Sofia Selowsky (Rosina) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Fiorello (Thomas Glass) and Berta (Yelena Dyachek) were definitely well-fitted to the role of showing the potential unreliability and apathy of persons hired to help run a household. I enjoyed seeing how Fiorello portrayed a person gradually becoming aware of, and resigned to his own irrelevance now that the robust Figaro (Lucas Meachem) has come on the scene. As for Dyachek, she imbued Berta's aria di sorbetto with a level of awareness that implies that this character, too, has a backstory which maybe has more involved than just the love on the surface. I perceive both of these singers have proven that these characters deserve fanfiction at some point; my perception is that they are involved in some secret society for the purpose of overthrowing the then-ruling King of Spain, Ferdinand VII, and that their jobs working for Count Almaviva (David Portillo) and the caricature Bartolo are merely a convincing front.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037088056/hgo---the-barber-of-seville---2018---photographer-lynn-lane-90-3000x2000.jpg.jpg)
<figcaption>Peixin Chen (Doctor Bartolo) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Kudos go to the stalwart choristers tasked with bringing in the Count's man-sized guitar as he prepared for his entrance aria, which Portillo delivered with grace and just the right amount of adolescent anticipation, perched atop said monster guitar. Not only did he negotiate coloratura throughout with fluency, if only a little breathiness at times, he was delightfully shown to be a little bit out of his element in all the disguises he employs, yet enjoying himself all the more. In the music lesson scene, his pretense at being Rosina's (Sofia Selowsky) voice teacher (complete with Beethovenian hairdo) was hilariously mirrored by his ridiculous antics at Bartolo's makeshift piano, which frequently had him playing in the opposite direction of the music, much to my amusement. Whether he is supposed to be using such disguises well or not so well was deliberately ambiguous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037109766/hgo---the-barber-of-seville---2018---photographer-lynn-lane-106-3000x2000.jpg.jpg)
<figcaption>David Portillo (Count Almaviva), Lucas Meachem *Figaro*, Sol Gin (Sergeant), and Peixin Chen (Doctor Bartolo) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

As Figaro entered and delivered his "Largo al factotum" with great robustness, the stage displayed various interior shots of his practice in full operation, wherein one suspects many transactions take place. Indeed, Meachem maintained a chatty tone throughout the show and made his aria into more than just a great set-piece; it set the tone for the whole evening, giving it a legitimate sitcom feel. Also, in showing the fourth wall to be nonexistent, it made the case for the audience to probe their own characters through the onstage antics of the supernumeraries, who were making all the subtext that the singers were not themselves given.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037142565/hgo---the-barber-of-seville---2018---photographer-lynn-lane-123-3000x2000.jpg.jpg)
<figcaption>Peixin Chen (Doctor Bartolo), David Portillo (Count Almaviva), Eric Owens (Don Basilio), Lucas Meachem (Figaro), Sofia Selowsky (Rosina), Yelena Dyachek (Berta), and HGO Supernumeraries in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

As Rosina, Selowsky really embraced her role in this production and showed herself to be a great executrix of coloratura, even more transcendently so than one normally expects. Indeed, her ornamentation of "Io sono docile" was inspired enough to serve as a primer on how to compose such passages with fluency and originality, and consoled me greatly for the lack of a Liszt fantasy on this opera. Regardless, however, I was pleased to note that after that piece concluded, she showed herself to be a fluent and entirely natural actress to the extent that at times I perceived this to be Beaumarchais's play with great background music. My Francophilic side was highly gratified.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037153901/hgo---the-barber-of-seville---2018---photographer-lynn-lane-154-3000x2000.jpg.jpg)
<figcaption>David Portillo (Count Almaviva), Sofia Selowsky (Rosina), Eric Owens (Don Basilio), and Lucas Meachem (Figaro) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

As Bartolo, Chen was very much in his element, rattling off his rodomontades like they were the lightest puffs of air in the world, easily showing his ability to bluster with always crisp diction while simultaneously being convincing about his character’s self-delusional belief in his omniscience. Basilio (Eric Owens) oozed slime alla Talleyrand at every turn, and his calumny aria was one of the highlights of a vivid evening, in that his vocal instrument was as flexible in showing dynamic contrast as the orchestra finally began to show itself willing to do likewise, as that was the first crescendo I heard all evening. In the extraordinarily precise brass interjections, I could hear Basilio gleefully imagining the march of his victim to his downfall. Perhaps it is a proto-Marche au supplice?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037163619/hgo---the-barber-of-seville---2018---photographer-lynn-lane-167-3000x2000.jpg.jpg)
<figcaption>Lucas Meachem (Figaro) and Peixin Chen (Doctor Bartolo) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Throughout, the Houston Grand Opera Orchestra showed a great willingness to fill the George R. Brown Convention Center, and Emily Senturia led them very admirably and deftly given the circumstances, especially given that the opaque set upstaged them for the latter three-quarters of the evening.

Throughout, tempos were not frenetic, but measured and deliberate, helping keep the music from obscuring the action. This also worked well in this venue which tended to absorb the string section's sonority and render dynamic contrast difficult to achieve, all the while putting Rossini's inspired woodwind interjections in high relief as a result. Blair Salter's recitative accompaniments were quite frequently inspired; marvelous were the ways in which recitative and aria were allowed to flow uninterrupted one into the other to create an atmosphere in which the background assisted the drama.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518037188015/hgo---the-barber-of-seville---2018---photographer-lynn-lane-173-3000x2000.jpg.jpg)
<figcaption>HGO Supernumerary and Peixin Chen (Doctor Bartolo) in *Il barbiere di Siviglia*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

So much was the timbre of HGO's pianoforte displayed to advantage that the company would only benefit by exhibiting it in chamber music concerts and Mozart piano concerti with a great deal of frequency. It would certainly do a great deal to draw the music community together in a more cohesive manner, especially during breaks in the season. If this production demonstrates anything, it is the value of a holistic approach in an operatic production as in the musical world more generally.

>HGO's [Il barbiere di Siviglia](http://www.houstongrandopera.org/thebarberofseville) runs through February 10. For details and tickets, [click here.](http://www.houstongrandopera.org/thebarberofseville)
