+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2021-11-12T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1636498589/media/2021/11/sqHeliosOpera_Fight_still_ykjwow.jpg"
primary_image_credit = "A still from Helios Opera's production of Service Provider, 2021. Image: Julien Rohel/Theodora Cottarel."
related_articles = ["articles/an-open-letter-to-a-rude-bunch-of-operagoers.md"]
related_companies = ["scene/companies/helios-opera.md"]
related_people = []
short_description = "Service Provider is essentially an opera all about cell phone use; the characters are on cell phones for most of the run-time, pretty much ignoring everything around them."
slug = "helios-opera-brings-hilarious-service-provider-home"
title = "Helios Opera brings hilarious Service Provider home"
youtube_url = ""

+++
Some companies have elected to return to live performance in this later stage of the COVID-19 pandemic, but as time goes on it has become eminently clear that the pandemic has completely changed the game in some ways that cannot be denied. It seems, for instance, that some companies are still interested in doing digitally-produced opera. This is something that I actually think is a great thing for a variety of reasons, one of the least being that it can provide a platform to present new work that has fewer audience hurdles than the traditional in-person performance.

Enter the reliably excellent [Helios Opera](/scene/companies/helios-opera/), which has opted to take its all-digital approach to a new thirty-minute work in [_Service Provider_](https://heliosopera.com/projects/service-provider/), a comedy in which half the characters cannot stay off their cell phones. This represents a kind of big artistic leap for Helios Opera: where in the past they have focused on smaller projects with only one singer, here they have graduated to a project that is somewhat larger in scale than their previous work in that they have four principal singers and a small cast of extras that populated the restaurant the work takes place in. It was really nice to see that they could take that leap.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636498625/media/2021/11/HeliosOpera_Still_1_b396yk.jpg){{% /md %}}

<figcaption>A still from Helios Opera's production of Service Provider, 2021. Image: Julien Rohel/Theodora Cottarel.</figcaption>  
</figure>

In some ways, the leap did not come without a few snags, especially in the sound design: there were several moments where some rather obvious sound effects were missing in the audio track, and when they were present sometimes the sound felt a little fake. It was thus a little distracting when wine glasses clinked with no sound effect, and it was further distracting when the sound of a cell phone hitting the floor didn't quite have enough reverb to sound convincing. I also felt that the climactic cat-fight was too obviously stuck in the exaggerations of stage-fighting to feel anything other than hyper-stylized, and there were more than a few times when the lip sync was slightly off. But this comes with the territory when trying something new and on a larger scale than previously attempted, so I can forgive these small hiccups.

And anyway, the work being presented was sufficiently entertaining that such things were never too distracting. _Service Provider_ is essentially an opera all about cell phone use; the characters are on cell phones for most of the run-time, pretty much ignoring everything around them. It's all grounded rather excellently in real stakes from the characters, however: the story is about husband and wife Autumn and Beau going out for their third anniversary, and while Beau wants to treasure it Autumn finds her way back to her cell phone every three seconds or so. It also implies a love triangle for Beau with someone else also in the restaurant, however, and the way this denouement plays out over snooping on cell phones really ties well into the theme of how people relate both over a cell phone screen and with each other in person.

> Helios Opera found really inventive, really clever ways to shoot the whole thing.

It also helps that, musically, the work makes sense. Comic opera is a very tricky creature to write, and I am very pleased to say that composer Christopher Weiss was more than up to the task of realizing John de los Santos' libretto in ways that left a lot of the comedy in the music. One of my favorite demonstrations of this is when the restaurant's much-put upon waiter Dallas sings about the night's specials: Weiss sets the specials to an overindulgent homage to Rossini and Verdi, and the fact that he spends a full minute lyrically soliloquizing about a pasta special was such a hilarious juxtaposition that I barely even cared that the specials weren't quite relevant to the plot.

I also rather liked how the married couple at the center of the story got some of their comedy in: the way Autumn interrupts Beau when he's trying to speak about his day involves such an abrupt shift in music that it drew a laugh out of me even as the scene grew more tense. And that is to say nothing of how it integrates cell phone ringing seamlessly into the score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1636498638/media/2021/11/HeliosOpera_Still_2_p8ixex.jpg){{% /md %}}

<figcaption>A still from Helios Opera's production of Service Provider, 2021. Image: Julien Rohel/Theodora Cottarel.</figcaption>  
</figure>

And of course, Helios Opera found really inventive, really clever ways to shoot the whole thing. One of my favorite moments was in a trio where Autumn, Beau, and Beau's side chick Charlene were stuck on their phones texting either at each other (in Beau and Charlene's case) or at an unnamed third party (in Autumn's case). This was shot in a close-up to all three characters spliced in three, and this was eminently fun because it played into the way the characters occasionally look up and speak past the phone, and it highlighted the way the vocal lines play off each other in the score. It also made sure to keep the action clear at all times, so that we barely missed anything that was going on. There were the hiccups I mentioned earlier, but whoever they got as a cinematographer definitely knew what they were doing, and the cinematography played very well with the score.

>  _Service Provider_ was a fast, breezy little opera, and it shows just how far Helios Opera has come.

And ultimately, they had a rather good cast of singers to realize each of the four main characters. Christina Pecce made for a loveably vain Autumn, and she played very well off of the exasperation that Scott Balantine's Beau started to show with her character. Both of them also sang their parts quite well, even managing to navigate the turn to the serious the opera shows after its denouement takes form.

It all, of course, also comes together from Carina diGianfilippo's loveably catty Charlene, who makes for a rather funny villain of the piece from how diabolical her facial expressions are to how she figures in the opera's climax. It felt a little bit like David Rivera Bozón held back slightly on how powerful his voice could be as the waiter Dallas, but his rendition of the specials arias was so loving it added to the humor in the music, and he did a great job playing the waiter that everybody else seems to dump on for no reason.

Overall, even despite the noticeable production hiccups, [_Service Provider_](https://heliosopera.com/projects/service-provider/) was a fast, breezy little opera, and it shows just how far Helios Opera has come, as one of the forerunners of producing digital opera here in the US. It really shows more promise for what they can put together in the future, and even though we are back to seeing live performance it shows that there is still a place in the world for digital productions.