+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-07-01T20:35:00-06:00"
lastmod = "2016-07-02T08:53:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467430896809/2016-07-02---Rehearsals.jpg.jpg"
publishDate = "2016-07-01T21:52:00-06:00"
related_articles = ["articles/being-a-nice-person-why-art-really-really-matters.md","articles/rehearsing-trauma-how-working-on-an-opera-helped-me-heal.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/owen-mccausland.md","scene/people/emma-char.md","scene/people/chelsea-rus.md","scene/people/iain-macneil.md","scene/people/christopher-mokrzewski.md","scene/people/vanessa-oudereimerink.md","scene/people/paul-curran.md"]
short_description = "Rehearsing comedy is a picky thing, and at least it comes with work-mandated jokes. Rehearsing tragedy can really underscore an artist&#039;s maturity, willingness to be vulnerable, and the respect that is the inevitable cornerstone of any collaborative work. It&#039;s an odd thing, to be grateful for a rape scene. Perhaps it shouldn&#039;t be surprising that the heaviest of onstage stories are the best at fostering offstage relationships."
slug = "heavy-scenes-the-fast-lane-to-a-great-rehearsal-room"
title = "Heavy scenes: the fast lane to a great rehearsal room"
+++

The rehearsal room vibe is a volatile and unique thing. It depends on the individuals in the cast and creative team: whether or not they're the types to toss around jokes, go out for post-rehearsal drinks with the crew, if they're comfortable enough with the work ahead of them to afford the occasional deep conversation or exchange of life anecdotes. Often, the mood of a rehearsal period can be dictated less by the chemistry of the people in a cast, and more by the subject matter of the opera being rehearsed.

In the past weeks we've spent time working on what could easily be categorized as a "heavy opera", in this case Britten's *The Rape of Lucretia*. Rehearsals include everything from observing centuries-old etiquette (and the depressing misogyny built into it), to unpacking the motivations of violent rapists (including the uncomfortable fact that [attackers have reasons behind their behaviour](/being-a-nice-person-why-art-really-really-matters/), be they valid or not), to actually choreographing and getting familiar with an explicit rape scene.

It's decidedly not the same as working on a comedy, where time is spent figuring out the optimal timing of a joke, perfecting ridiculous accents, and rehearsing slapstick routines in front of a mirror. The material is light, and laughter is (hopefully) a constant in the rehearsal room; it's the kind of social vibe that carries easily into happy hour, that creates inside jokes among the cast, and easily establishes friendships.

Working on tragedy, or operas with heaviness about them, requires a conscious and continuous effort to keep the rehearsal mood realistic, if not joyous. Directing this production of *Lucretia* is [Paul Curran](http://www.paulcurrandirector.com/biography/), and he has created what feels like a sense of controlled positivity within the daily rehearsal schedule. The term "controlled positivity" sounds a bit like "forced fun", but it's sort of ingenious and utterly necessary for the sanity of everyone involved in presenting Britten's heartbreaking chamber opera. Curran has choreographed not only a rape scene, but a way to rehearse it, which includes time set aside specifically for figuring out where to stand, sit, how to "pull hair", where to run, where blood packs will be hidden, how to feign being choked, and even how to physically demonstrate fear.

In some ways, the conscious maintenance of a positive rehearsal room, despite the gloomy goings-on in the show itself, makes for a faster and more meaningful bond among the creative team. For Curran, and any director working with tough stuff onstage, the active pursuit of normalcy in the rehearsal process points to a respect for the artists involved; like in any social situation, showing respect for others is a quick way to solidify valuable relationships. There's a clear and explicit demonstration that the singers are being asked to make themselves utterly vulnerable, to embody the minds of characters who hold a very different view of the world, and to do it in front of a room of people who are paid to scrutinize, perfect, and pick on all unsatisfactory details in their repeated attempts at perfection.

It's another check in the column entitled, "Reasons Why We Don't Envy Singers". Perhaps it's not too difficult to memorize fight choreography, or to walk and sing at the same time; but it's another thing entirely to place oneself in a fictional scene, and evoke a series of thoughts and reactions that result in a real-looking story of violence and horrific acts. The man who respects women is asked to become a rapist, and the woman who lives in the 21st-century is asked to adopt archaic social mores, to justify suicide as an answer to horrific victimization. There's a constant risk of anachronism, of ill-timed physical reactions to dramatic checkpoints in a scene, and of course, of the entirely naked vulnerability that comes with practicing sexual violence in front of a room of colleagues.

So, it's fascinating to work on a show that includes an extreme scene; it's as extreme, perhaps, as working out the hilarity that is the Act I finale of *Il barbiere di Siviglia*, or the goofy dancing involved in Act IV of *La bohème*. Rape is a horrific thing to witness, even if it's understood as fiction. Mercifully, great directors like Curran understand that getting two singers to "really go there" in a difficult scene doesn't require weeks of method-acting-esque depression or self-loathing. 

Rehearsing comedy is a picky thing, and at least it comes with work-mandated jokes. Rehearsing tragedy can really underscore an artist's maturity, willingness to be vulnerable, and the respect that is the inevitable cornerstone of any collaborative work. It's an odd thing, to be grateful for a rape scene. Perhaps it shouldn't be surprising that the heaviest of onstage stories are the best at fostering offstage relationships.
