+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-10T11:53:00+01:00"
lastmod = "2016-04-11T10:03:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460305282788/2016-04-10---GOERNE_Borggreve019.jpg.jpg"
primary_image_credit = "Photo: Marco Borggreve for harmonia mundi. Copyright 2008. "
publishDate = "2016-04-11T09:45:00+01:00"
related_articles = ["articles/in-review-strauss-brahms-at-the-barbican.md","articles/he-saidshe-said-mozarts-requiem-at-tso.md","articles/in-review-mahler-other-beauties-at-the-tso.md","articles/magic-theatre-jurowski-and-oaes-resurrection-symphony.md","articles/requiem-on-the-south-bank.md","articles/recitals-that-stick-matthias-goerne-at-wigmore-hall.md","articles/in-review-lpo-presents-st-luke-passion.md"]
related_people = ["scene/people/matthias-goerne.md","scene/people/sarah-tynan.md"]
short_description = "It was Goerne that was the highlight of the night. His is one of the most beautiful baritones singing today, and he was a complete picture of expression. His love for Brahms&#039; music was completely clear, and he sang with his whole body in a huge range of colour. You could certainly hear the Lieder singer as he delivered this heavy text; he risked some soft singing, but gave us some of the more satisfying moments of the Requiem with a triumphant, full sound."
slug = "heavy-nights-schoenberg-brahms-the-lpo-and-goerne"
title = "Heavy nights: Schoenberg &amp; Brahms, the LPO and Goerne"
+++

Saturday night, the London Philharmonic Orchestra offered up a heavy evening of Schoenberg and Brahms, one that left us sunk in our seats and deeply satisfied.

Christoph Eschenbach led the strings of the LPO through Schoenberg's eerily gorgeous *Verklärte Nacht*, the tone poem based on Richard Dehmel's poem of the same name. The wordless setting by Schoenberg tells, in impressively specific manner, the tale of a couple's walk through the forest, the woman confessing that she's pregnant by another man. The tonalities are tame for Schoenberg (it's only Opus 4), and the soundscape got our imaginations going immediately. A precursory sound to film scores, there were all the sounds of a dank, foggy forest and the human emotions surrounding a tense confession. The man's extension of forgiveness to the woman was shockingly tonal, consonant, making us think of Brahms and Bruckner and even Elgar.

*Verklärte Nacht* is a piece that makes even a show of the ensemble bowings, drawing our eye to long, dragging down-bows and arpeggiations that looked like dancing. At the podium, Eschenbach was strong and decisive, if not in slight physical discord with the stretching, luxurious sounds we heard. Concertmaster Pieter Schoeman played with a warm, pure sound, at times in gorgeous duet with violist Benjamin Roskams and cellist Pei-Jee Ng.

The final half marked our second hearing of Brahms' *Ein deutsches Requiem* since our arrival in London (not too bad). Soprano [Sarah Tynan](/scene/people/sarah-tynan/) and baritone [Matthias Goerne](/scene/people/matthias-goerne/) joined the full London Philharmonic Orchestra and the London Philharmonic Choir for Brahms' giant, human nod to death and life; the deaths of both Robert and Clara Schumann were the final catalysts Brahms needed to write the *Requiem*, which takes texts from Psalms, Revelation, Ecclesiasticus, Isaiah, Hebrews, Paul, Matthew and John. 

Eschenbach's slow tempi for the *Requiem* seemed to resist against the natural, yet that resistence turned to a hypnosis of sorts; he worked with Brahms' beautiful and frustrating tendency to prolong satisfaction, to avoid letting phrases edge toward spontaneity. The choir had a gorgeous unity to their sound, and the orchestra played with that grounded sound common to Brahms, with rich attention to the lowest voices. Sarah Tynan's singing of "Ihr habt nun Traurigkeit" was completely stunning, exactly how one wants to hear it. She floated and spun, but there was no sense of walking on eggshells.

It was Goerne that was the highlight of the night. His is one of the most beautiful baritones singing today, and he was a complete picture of expression. His love for Brahms' music was completely clear, and he sang with his whole body in a huge range of colour. You could certainly hear the Lieder singer as he delivered this heavy text; he risked some soft singing, but gave us some of the more satisfying moments of the *Requiem* with a triumphant, full sound. 

Goerne was beautiful to watch while he sang, but also while he sat and listened. At times, he mouthed along with the chorus (who couldn't, at those two thrilling moments of fortissimo "Denn alles Fleisch"?), and he seemed totally wrapped up in Tynan's solo. It was our first live hearing of Goerne, and he really is one of those charismatic artists who claim the spotlight even when they're not making a sound.

Next up from the London Philharmonic Orchestra is a continuation of their [Shakespeare 400](http://www.lpo.org.uk/events/shakespeare.html) festival, featuring music by De Falla, Rodrigo, and excerpts from Prokofiev's *Romeo and Juliet*, with maestro Jaime Martín and guitarist Xuefei Yang. For details and ticket information, follow our box office links below.
