+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-02-08T11:55:00-05:00"
lastmod = "2018-02-08T13:11:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518108932044/sq---renee_fleming_credit_andrew-eccles.jpg.jpg"
primary_image_credit = "Photo: Andrew Eccles."
publishDate = "2018-02-08T11:55:00-05:00"
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/renee-fleming.md"]
short_description = "The night ended with a nod to Leonard Bernstein&#039;s 100th Birthday - &quot;Somewhere&quot; from West Side Story. The lyrics &quot;There&#039;s a place for us - somewhere a place for us…&quot; she dedicated to the DACA Dreamers, and the evening ended with many in tears and everyone on their feet for several standing ovations."
slug = "heavenly-voice-visits-the-city-of-angels"
title = "Heavenly voice visits the City of Angels"
+++

Soprano Renée Fleming has reached the highest of heights, not only in the opera world, but she has gone just about as far as any classically-trained singer can go in popular culture (she even sang at a Super Bowl.) After receiving just about every award possible and after performing in fifty-plus operas, she announced her retirement from staged works last year (except for Broadway musicals.) It appears that we can now only look forward to recordings and concerts to hear "the people's diva" remind us of why she earned that title.

La Diva Fleming gave her final performance at the Met last spring in one of her signature roles, the Marschallin in [*Der Rosenkavalier*](/in-review-der-rosenkavalier-at-roh/). The Marschallin was a particularly poignant exit, as the character loses out to someone younger at the end of the opera; Ms. Fleming felt, as Leontyne Price did at her retirement, that when one is surrounded by people who are all younger, it might be time to retire.

That didn't mean Ms. Fleming would stop singing, however, and so she hit the road on a concert tour partnered with accomplished pianist Hartmut Holl. It brought her to LA Opera at the Dorothy Chandler Pavilion on February 6th. Right away she let us know that it's "lonely on the road" and interacting with the audience gives her joy. The ovations and shouts from the audience throughout the program let her know the feeling was mutual.

For whatever reason Ms. Fleming has retired, it has nothing to do with her voice, which is as glorious as ever.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518108606153/renee-fleming_recital_2-6-2018_photo_by_larry-ho_01.jpg.jpg)
<figcaption>Renée Fleming in recital with pianist Hartmut Holl at LA Opera on February 6, 2018. Photo: Larry Ho.</figcaption>
</figure>

Ms. Fleming is also beautiful, and on stage her entire persona shines like her diamond necklace, whether she is performing a comic piece or a sad piece. (She avoided anything tragic in subject matter so the word "sad" will have to suffice.) She is clearly someone with a great sense of humor, which she reveals not only in her performance, but also in her stage patter. Before she launched into a series of songs by Brahms, for example, she asked the audience to hold their applause until the last song was over, "but save it up so it's a lot."

The choice of repertoire was puzzling at times. Those coming to hear some of Ms. Fleming's "greatest hits" were disappointed and had to wait for the final number of the evening when we were treated to "Song to the Moon" from *Rusalka*. "Song to the Moon" sounded as stirring and as flawless as it has over the decades and in the many times she has reprised the role.

So why then, were we not treated to Verdi? Ms. Fleming had many triumphs as Violetta from *La Traviata*, Desdemona from *Otello* - why not the "Ave Maria"? Why not Mozart, Donizetti or Bellini? Some of the arias from her great roles such as Fiordiligi in Mozart's *Così fan tutte* would be too long and vocally taxing for the concert atmosphere - but what about some arias from the great composers that we weren't expecting, such as Puccini's "O mio babbino caro," which was a wonderful, surprise choice for her first encore?

The first half began with two short Handel airs and, other than a short detour to an aria by Rufus Wainwright, that was going to be it for the opera canon until, as noted, the big finish with Dvorak. Most of the first half was Brahms - seven short pieces put together from different sources as a kind of song cycle. The highlights included "Die Mainacht" from *Four Songs* (Op. 43) where Ms. Fleming gave her most plaintive performance, singing of the moon (one of her favorite subjects) and the burning of a tear on her face. In "Vergebliches Standchen," from *Five Romances and Songs* (Op. 84) Ms. Fleming elicited a lot of laughs portraying both sides of a potentially illicit affair, where a flirtatious woman urges a man to "extinguish (his) love."

Also included was "Wiegenlied" from *Five Songs* (Op. 49), more famously known as Brahms' Lullaby, and one assumes Ms. Fleming's daughters were once treated to this. Lucky girls to have a mother with a voice like that singing them to sleep.

The first half ended with a pair of songs from Caroline Shaw (text by Mary Jo Salter) that Ms. Fleming debuted at Carnegie Hall. Here again, with all the great parts that Ms. Fleming has debuted - operas by John Corigliano and Conrad Susa for example - these two rather indecipherable pieces seemed like an odd choice.

The second half, leading up to the finale (followed by no less than three encores), was also an eclectic soup. Ms. Fleming looked stunning in a shimmery gray gown in the first half - a cape from her shoulders descending to the ground in long, wide strands that formed a train as she entered and exited. For the second half, Ms. Fleming re-entered the stage in a gown with black sequin highlights, and humorously suggested that the ovation was due to the change she had made. "I like gown applause," she remarked with a wink; "It makes it worth it to travel with all this." The programming included a beautiful "Clair de lune" (Op. 46, No 2) from Fauré and "Les feux d'artifice t'appellent" from Rufus Wainwright's opera *Prima Donna*. Ms. Fleming sets the stage for the latter by letting us know that she is thinking of a famous photo of Maria Callas staring out a window as she sings this aria of loneliness. There was one breathtaking moment when the music called for Hartmut Holl to stop playing and Ms. Fleming's final note hung by itself in the air like a blown autumn leaf.

Ms. Fleming had a lot of fun with "Je t'aime quand même" from the operetta *Les Trois Valses* by Oscar Straus and treated us to a a very Violetta-like high note at the end.

Barbara Cook, the late great Broadway soprano and teacher who passed away last year after an extraordinary career that included *The Music Man*, *Candide*, *She Loves Me* and numerous Rodgers & Hammerstein revivals, was Renee Fleming's neighbor and dear friend. Ms. Fleming shared with us Ms. Cook's touching message to her singing students: "You are enough." A tribute to Ms. Cook was included as part of the concert, and the audience was asked to participate in the first of two "sing-a-longs" - the first of which was really a "whistle-along." For the song "I Whistle a Happy Tune" from *The King and I*, Ms. Fleming revealed that she couldn't whistle and needed our help.

The second "sing-a-long" was during one of three soaring encores. Ms. Fleming gave us "I Could Have Danced All Night" from *My Fair Lady* and asked the audience - which evidently had a number of singing students - to join in. The result: glittering high notes rose from the orchestra level to the third balcony.

The night ended with a nod to Leonard Bernstein's 100th Birthday - "Somewhere" from *West Side Story*. The lyrics "There's a place for us - somewhere a place for us…" she dedicated to the DACA Dreamers, and the evening ended with many in tears and everyone on their feet for several standing ovations.

Los Angeles made it clear that no matter what the medium or venue, Renee Fleming and her voice will always be welcome in this city.
