+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-05-04T19:01:00-04:00"
lastmod = "2018-05-05T22:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475116573/sqDSC_6417.jpg.jpg"
primary_image_credit = "Heartbeat Opera's Don Giovanni, 2018. Photo: Russ Rowland."
publishDate = "2018-05-04T20:51:00-04:00"
related_articles = ["articles/don-giovanni-strengthened-by-reinterpretation.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
related_people = ["scene/people/samarie-alicea.md","scene/people/leela-subramaniam.md","scene/people/felicia-moore.md"]
short_description = "From the overture&#039;s opening measures, the band produced genuine chamber music. Gleb Kanasevich, whose playing I&#039;ve admired since his conservatory days, had increased responsibility as the lone wind. Schlosberg&#039;s orchestration demands fast arpeggiated chords, virtuosic melodies, and character-driven phrases to compensate for the missing winds and brass."
slug = "heartbeats-giovanni-successfully-bucks-tradition"
title = "Heartbeat&#039;s Giovanni successfully bucks tradition"
+++

No spoilers. I guarantee you won't guess what happens after "Act 1" of [Heartbeat Opera](/scene/companies/heartbeat-opera/)'s new production of Mozart's *Don Giovanni* (Directed by Louisa Proske). See the show. Find out.

I'd given up hope that *Giovanni*'s plot could surprise me. But at the end of the first finale, with Giovanni caught red-handed assaulting Zerlina, I thought, with surging trepidation, "they might actually kill this guy right here, right now." I never expected what happened next.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475134347/DSC_3879-1-2.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

Heartbeat Opera productions can deviate significantly from their source material's [structure and plot](https://www.nytimes.com/2017/05/23/arts/music/butterfly-and-carmen-in-bold-and-vivid-cuts.html), perhaps never as significantly as in this *Giovanni*. Undaunted by tradition, they've reintroduced suspense into well-known operatic masterpieces.

[Felicia Moore](/scene/people/felicia-moore/) (Donna Elvira) stood out among a cast of capable voices. She managed Elvira’s leaping coloratura accurately, led the orchestra with clear diction, and sculpted notoriously challenging phrases expressively. She sang spontaneously within the rigid demands of Mozartian style. Only when she artificially straightened her tone did she veer out of tune. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475147981/DSC_4325.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

[Samarie Alicea](/scene/people/samarie-alicea/) packed her Zerlina with guile and guts. Her humor derived from a sardonic knowingness. "Vedrai, carino", her second aria, could have been cut had she not sung it so well. She bloomed effortlessly on the connective note leading into the songs heart-pumping final section.

Throughout the opera, [Leela Subramaniam](/scene/people/leela-subramaniam/) seemed mostly untaxed as Donna Anna. Her most deft acting came in her confessional second act aria, "Non mi dir". Exasperation simmered beneath a regal façade.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475170472/DSC_4974.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

I looked forward to John Taylor Ward in the title role specifically because his voice doesn't fit the stereotypically virile timbre that American opera houses arbitrarily require of a Giovanni. Ward is a consummate musician with serious early music credits, so I expected enlightened, graceful phrasing to counteract Giovanni's inherent brashness.

But Ward's voice failed the role. Giovanni's vocal range is limited but has definite requirements. His lines climax repeatedly on the same few pitches, but on exactly those crucial notes Ward's instrument withered with strain. Unnecessary ossia and ornaments in the second finale further exploited the singer's weaknesses.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475184472/DSC_4573.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

That said, Ward's second half performance was a feat of fearless physical exposure and convincing theatricality under demanding circumstances.

[Daniel Schlosberg](/don-giovanni-strengthened-by-reinterpretation/) reorchestrated Mozart's work for clarinet, string quartet, bass, and harpsichord. The band, stacked with talent, clearly knew the score in detail. Fortunately so, because with Jacob Ashworth conducting from the violin, singers were short on cues. Some transitions and complexly layered ensembles threatened shabbiness, but the band, well synced and listening caringly, adjusted immediately to singers' momentary rhythmic blips.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475201216/DSC_3447photobyRussRowlandHeartbeat'sDonGiovanni.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

From the overture's opening measures, the band produced genuine chamber music. Gleb Kanasevich, whose playing I've admired since his conservatory days, had increased responsibility as the lone wind. Schlosberg's orchestration demands fast arpeggiated chords, virtuosic melodies, and character-driven phrases to compensate for missing winds and brass. Kanasevich modestly declined an individual bow, though in many ways, the evening was his.

Mozart blessed Don Giovanni with perhaps the single most audacious stretch of music in the classical repertoire.

Giovanni's predatory party that finishes the first act (as Mozart wrote it) brings every living character to the same room in a chaotic clash of class. Emphasizing the distinction between bumkins Masetto and Zerlina, royals Anna and Ottavio, and heathens masquerading as gallants Leporello and Giovanni, Mozart composed three simultaneous, differently metered dances, two played by on-stage bands, one by the pit orchestra, underscoring disparate ensemble singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525475220485/DSC_3486photobyRussRowlandHeartbeatsDonGiovanni.jpg.jpg)
<figcaption>Heartbeat Opera's *Don Giovanni*, 2018. Photo: Russ Rowland.</figcaption>
</figure>

To see this music played flawlessly, without strain, led by an instrumentalist conductor, with reduced orchestral numbers, on an acoustically challenging stage, during appropriately chaotic staging was a Mozart lover's wet dream.

Helped by brief but impactful textless vignettes, the production's second half set up the possibility for dramatic intimacy like I've never seen in opera. I craved the singers to forego the obligation to "perform". No need to force reactions at every beat, nor emote beyond how one would in that room at that proximity. Forget the audience, forget "singing out". Just talk to each other for real.

I plan to see this Giovanni again. I was more intellectual intrigued than emotionally impacted. But I hope as the run continues, the actors' presentational tendencies dissipate and devastating subtleties emerge. I implore Mozart fans and novices alike turn out for this singular production.

>Heartbeat Opera's [Don Giovanni](http://www.heartbeatopera.org/don-giovanni/) runs though May 12. For details and tickets, [click here.](http://www.heartbeatopera.org/don-giovanni/)
