+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-05-17T02:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684462998/sqLADYM9.jpg"
primary_image_credit = "Sishel Claverie & Taylor-Alexis Dupont in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland."
related_articles = ["articles/in-review-tosca-at-the-coc.md", "articles/wno-tosca.md", "articles/tosca-at-heartbeat-opera-art-to-the-point-of-distraction.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
related_people = []
short_description = "Even if you are producing the original Verdi version of Macbeth, you better have a great 'Lady M.' Here with the story focusing on that character, the singer must be equally unimpeachable. Enter Ms. Algozzini, a diminutive Italian soprano who blasts us backwards with her extraordinary vocal cannon."
slug = "heartbeat-opera-dial-lady-m-for-murder"
title = "Heartbeat Opera: Dial Lady M for Murder"
youtube_url = ""

+++
Heartbeat Opera has emerged from the pandemic shutdown with two adaptations of classic Italian opera masterpieces: Puccini's _Tosca_ ([reviewed here](https://www.schmopera.com/tosca-at-heartbeat-opera-art-to-the-point-of-distraction/)) and Verdi's _Macbeth_, which eliminates a great deal of Verdi's score and concentrates on Lady Macbeth as the central figure of the story (hence the new title of _Lady M_). It's the more successful of the two adaptations because there is no attempt to force a concept onto or into a great work, as was the case with Heartbeat's _Tosca_. With _Lady M_ there is an unapologetic deconstruction of Verdi's opera, using some of his score, and some of the libretto by Piave, but the end result is the creation of a new piece altogether. In short, it's not "your father's _Macbeth_," especially if your father was named Verdi, Piave or Shakespeare (on whose play the opera is based).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684462997/LADYM2.jpg){{% /md %}}

<figcaption>Sishel Claverie, Taylor-Alexis Dupont and Samarie Alicea in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland.</figcaption>
</figure>

The adapters (Jacob Ashworth and Ethan Heard) have, in fact, inserted spoken portions of Shakespearean dialogue, but in the mouths of trained opera singers who are untrained Shakespearean actors, that doesn't work at all.

The story is mostly a linear lift from the original. Macbeth (baritone Kenny Stavert) and his closest ally, Banquo (bass Isaiah Musik-Ayala,) encounter three witches or "weird sisters," credited in the program as just Sisters (sopranos Samarie Alicea, Taylor-Alexi Dupont and mezzo Sishel Claverie.) The Sisters foretell Macbeth's and Banquo's future – one will be king, the other "the father of kings" - and the rest of the story is the fulfillment of those predictions, through both direct bloody action and through passive fate. The new adaptation of this well-known story has stripped away all the subplots, leaving only the six characters mentioned. The most famous scenes are here – the encounters with the witches, the plotting by the Macbeths, Banquo's death, the banquet with Banquo's ghost, etc., but altered is the trajectory of Mrs. Macbeth who no longer kills herself, but rather aids in the killing of her husband. She lives to see a new world order created from the chaos.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684462997/LADYM5.jpg){{% /md %}}

<figcaption>Kenny Stavert & Lisa Algozzini in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland.</figcaption>
</figure>

The adapters have placed the action in the modern day corporate world, and Macbeth, dressed in a business suit, kills his way into the corner office as CEO. A lot of the action takes place in front of and around a home wet bar with barstools. At one point he gets a box from Amazon that contains spy cameras so that he can keep track of his ongoing battles with rivals. He hands out business cards to members of the audience, and Lady M hands out paper invitations to the banquet. (Members who receive the papers are invited up on stage and become part of the scene.) A great set piece in this scene is the banquet table which becomes a glass coffin revealing Banquo's body when the tablecloth is pulled away. Macbeth is later trapped in the coffin as well. It's one of a number of arresting theatrical devices that include a pillow with black feathers that explodes all over the stage when Duncan is murdered.

Not so arresting is the use of a ring light which is used as a metaphor for the crown, etc., but looks exactly like…well…a ring light. (It also malfunctioned, going dark for much of the performance.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684462997/LADYM6.jpg){{% /md %}}

<figcaption>Samarie Alicea, Sishel Claverie, Taylor-Alexis Dupont, Isaiah Musik-Ayala, Lisa Algozzini and Kenny Stavert in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland.</figcaption>
</figure>

There is a lot to like about this production, however, especially the originality of the visuals, created by director Emma Jaster, scenic designer Afsoon Pajoufar, lighting designer Oliver Wason and projection designer Camilla Tassi. A rear curtain, composed of strings, allows performers to enter the stage then disappear behind it seamlessly. Their bodies can remain unseen as sometimes only their hands or faces poke through the curtain. At the same time, the strings act as a rear projector, showing images that underpin the stage action, such as the mirroring of Macbeth's surveillance footage that he's watching on his computer. When Lady M (soprano Lisa Algozzini) first appears from under a bed sheet, the sheet is spread by the three Sisters. Projected on the sheet we see images of Lady M's dream/nightmare – remembering the baby she nursed and lost.

The stage itself has a projection of an enormous flowerbed which bookends the pre-show and finale. As the show begins, the flowers dissolve into geometric plots of land, like you'd see from an airplane. The Sisters are looking down at this change, or creating it, as they "hover through the filthy air" as per Shakespeare's text. Then the rectangles and squares of land dissolve to reveal the boards of a stage and the show begins. (The first of many quibbles – all this visual excitement is preceded by a pre-show where the actresses playing the witches sit on the stage in the projected flower bed casually chatting with the musicians from the band. Why the director chooses to begin the drama by undercutting it is inexplicable.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684462997/LADYM7.jpg){{% /md %}}

<figcaption>Taylor-Alexis Dupont, Lisa Algozzini, Kenny Stavert and Sishel Claverie in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland.</figcaption>
</figure>

Even if you are producing the original Verdi version of Macbeth, you better have a great "Lady M." Here with the story focusing on that character, the singer must be equally unimpeachable. Enter Ms. Algozzini, a diminutive Italian soprano who blasts us backwards with her extraordinary vocal cannon. A consummate performer, she also can also bring it down for the intimate moments and takes us on the roller coaster of her inner turmoil. At first a schemer, coaxing her husband to become a murderer and ascend to the throne, her doubts and guilt seize her until she can't take it anymore. Macbeth is the one depicted as out of control, while Lady M comes to her senses. The final image before the final curtain is of her sitting in the (aforementioned) projected flowers which have now returned to the stage, signaling that all is once again right with the world.

Another change to the original story – and a poor choice - is that the witches are no longer ominous. Though Ms. Alicea, Ms. Dupont and Ms Claverie blend beautifully, they are costumed like escapees from a Grecian urn and spend a lot of time spreading flowers and smiling. They have some perfunctory choreography here and there but are constantly called away for triple and quadruple duty: changing the set, bringing props on and off, sweeping and swiffering the stage and covering non-witch chorus parts. One even doubles as Banquo's son. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684462997/LADYM8.jpg){{% /md %}}

<figcaption>Samarie Alicea, Sishel Claverie, Kenny Stavert and Taylor-Alexis Dupont in Heartbeat Opera's production of Lady M, 2023. Photo: Russ Rowland.</figcaption>
</figure>

Mr. Stavert seems to be in recital mode during most of the performance. He has his moments thanks to his polished and prodigious vocal gifts, but most of the time he seems detached from the lyrics. He spends a great deal of time with his hands in his pockets. If this is intentional to keep the attention focused on Ms. Algozzini, it works.

Mr. Musik-Ayala is a potent and formidable bass-baritone. He's a force to be reckoned with, not only as Banquo, but as an ascendant star in the opera world.

Music director Daniel Schlosberg loves unusual instrumentation, as was evidenced by his direction in _Tosca_, where he eliminated percussion, for example. Luckily he has strong drums and timpani to carry the dramatic moments in _Lady M_, but a lot of his choices make the Macbeths seem silly rather than sinister. The constant comments by a xylophone are almost cartoon-like, as are the various insertions of a guitar, electric guitar, lute, mandolin and even a banjo. While it's a demonstration of the virtuosity of musician Nicoletta Todesco, who plays almost all of them, the sounds make no sense, as when the acoustic guitar strums under one of Lady M's arias, making it sound more like a whimsical Italian folk song. A lot of the time, Mr. Schlosberg seems to be testing the inventory in a music store.

In both _Tosca_ and _Lady M_, Heartbeat Opera has brought together creatives who clearly have an impulse to be different. But in many cases, they've chosen to make what amounts to "improvements" on Verdi, Puccini and Shakespeare. Different doesn't always prove to be better.
