+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2019-05-13T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "The [New York Opera Fest 2019 line-up](http://nyoperafest.com/2019/) continues through June 30."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1557879697/media/2019/05/sqRJH7171-2.jpg"
primary_image_credit = "La tragédie de Carmen, City Lyric Opera, 2019. Photo courtesy of City Lyric Opera."
related_articles = []
related_companies = []
related_people = []
short_description = "The singers playfully (or angrily) splash about, shoot each other with squirt guns and finally land dead in the (unheated) water for the violent finale."
slug = "hearing-the-seldom-seen"
title = "Hearing the Seldom Seen"
youtube_url = ""

+++
When an opera isn't revived very often, there's usually a good reason. Not always – sometimes it's simply because too much time has passed in this ephemeral art form. Opera companies, however, are continually searching for something rare to add some seasoning to their seasons, and that means rare titles. Under the umbrella of the [New York Opera Fest](http://nyoperafest.com/2019/), three seldom seen works were brought back from oblivion this week - featuring three different musical genres - and the results were just as diverse.

The [little OPERA theatre of ny](/scene/companies/little-opera-theatre-of-ny/) (LOTNY), has done some digging and found silver, bringing back to life one of Benjamin Britten's final operas, _Owen Wingrave_ (1971). Originally written for BBC television and mostly forgotten since, it is well worth inclusion in the chamber repertory.  Britten returns to the scene of his greatest success - _The Turn of the Screw_, a ghost story based on a novella by Henry James. _Owen Wingrave_ is also the story of a haunting (also based on a work by Henry James.)  The ghosts in this opera only earn a few passing references, however, and so the dramatic ending isn't quite as frightening as it should be.  It’s one of the flaws in Myfawnwy Piper's rather surface libretto but Britten's music, as always, keeps the whole affair compelling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879626/media/2019/05/LOTNY_Owen%20Wingrave_Dress.jpg){{% /md %}}

<figcaption>Sir Philip (R. Müller) and Mrs. Coyle (J. Hall), with Kate (K. Pracht), Lechmere (B. Holcomb), Mrs. Julian (M. Stewart), Coyle (M. Curran), Miss Wingrave (E. Pulley) and Owen (R. Balonek) looking on in Owen Wingrave, little OPERA theatre of ny, 2019. Photo: Tina Buckman.</figcaption>

</figure>

There's always something interesting going on in the orchestral line of a Britten opera, even when the vocals remain in a small range of notes. The effect is that the orchestra and singers seem to be in their own worlds and yet, through Britten's musical genius and savvy sense of theatre, it all magically comes together. There is always the sense of the startling; singers might make sudden leaps or come together in short heart-stopping harmonies. Sometimes they will even sing _a cappella_ with the orchestra dropping out unexpectedly altogether.

> They move from outright fury to singing in long, mocking legato lines of Owen's "Scruuuuuuuuples."

Britten was a pacifist and this is his anti-war opus. The title character is part of a military family, going back many generations, but he decides to break the ancestral chain and declare that war is a crime. In the opening scene, after his teacher Spencer Coyle describes Napoleon's battle strategy, Owen states that the French Emperor and other famous generals are "ruffians – I would hang the lot!" Owen leaves his schooling and must go home to the family estate and defend his decision.

There he is verbally attacked by his aunt, Miss Wingrave, and two other women who have been longtime residents (Mrs. Julian and her daughter Kate.) They are joined by Owen's grandfather (General Sir Philip Wingrave) and soon they are all trying to shame him. They move from outright fury to singing in long, mocking legato lines of Owen's "Scruuuuuuuuples."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879638/media/2019/05/LOTNY_Owen%20Wingrave_Dress2.jpg){{% /md %}}

<figcaption>Otis Asare-Appiah, Mateo Gareza, and Luciano Pantano in Owen Wingrave, little OPERA theatre of ny, 2019. Photo: Tina Buckman.</figcaption>

</figure>

Owen is unmoved, and remarks that he is expected to "accept and obey but the orders are all wrong." The denizens of the household are convinced, however, that Owen will ultimately "listen to the house," the walls of which are covered in portraits of warrior Wingraves from the past. Owen sings that only "in peace" has he found his true character. Called a coward, Owen turns out to be the bravest person in the house and goes to confront a murderous spirit in one of the rooms.

> Powerhouse Soprano Emily Pulley is more frightening than any actual demon that might live in the house.

Robert Balonek, as the title character, has a grand baritone. He gives a great performance, making us feel the inner pain of Owen not only in his singing, but in his tortured silence, as the bullies gang-up all around him. Matthew Curran (as Spencer Coyle) is a nuanced performer, maneuvering between his official position (as Owen's teacher) and as a sympathetic ear for his student.

Soprano Janice Hall plays Mrs. Coyle, who is also sympathetic to Owen's plight, and her voice becomes the warm underside of the cold attack. Tenor Rufus Muller, expertly sings the angry outbursts of the General and then switches gears to become the Narrator of the story, beautifully delivering the most melodious lines.

Powerhouse Soprano Emily Pulley (as Owen's Aunt, Miss Wingrave) is more frightening than any actual demon that might live in the house. Soprano Mary Anne Stewart (as Mrs. Julian) and mezzo Katherine Pracht (as Kate) are the most villainous.

Ms. Stewart plays the victim-card beautifully while protecting her self-interests, and Ms. Pracht plays the ultimate confederate - pretending to love Owen only to turn on him and force him into the tragic ending of the story. Tenor Bernard Holcomb, as Owen's alleged friend Lechmere, is equally sweet and treacherous.

Great operas are, for the most part, in the public domain and so contemporary artists feel free to deconstruct, reconfigure and reimagine these works with no fear of a lawsuit. If Bizet were alive, however, I'm quite sure he would take the creators of _La Tragedie de Carmen_ (1983) to court.

> Director Victoria Collado and her design team have come up with a concept where the singers perform entirely in a rectangular pool of water, the depth of a footbath.

There isn't an opera more beloved (and produced) than Bizet's _Carmen_ and it’s understandable; it's practically perfect in every way, musically and theatrically. But esteemed opera and theatre director, Peter Brook, felt he could make it even more "interesting" and so he created a ninety-minute version, eliminating the chorus, all the singing characters (except for the four leads) and much of the music.

He kept what only can be described as "Carmen's Greatest Hits." He then replaced some truly wonderful music with some truly unnecessary spoken dialogue from non-singing characters (who appeared in the novel that inspired the opera.) In this stripped down and artistically stripped apart rendition, there is no dramatic and sexual tension before or in between the two arias where Carmen first seduces from a distance ("La Habanera") and then up close ("Près des remparts de Seville.") There is no clear-cut answer to the question "Why", but lots of answers to the question "Why, not?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879673/media/2019/05/tragedie-photo1.jpg){{% /md %}}

<figcaption>La tragédie de Carmen, City Lyric Opera, 2019. Photo courtesy of City Lyric Opera.</figcaption>

</figure>

The recent production of this misguided 80's experiment (by [City Lyric Opera](/scene/companies/city-lyric-opera/)) "leadens the lily" even further. Director Victoria Collado and her design team have come up with a concept where the singers perform entirely in a rectangular pool of water, the depth of a footbath. The idea here, according to the program, is to emphasize the "self-reflection" of the characters via a reflecting pool.

> Matthew Pearce, as Don José, overcomes all this adversity and manages to give a standout vocal performance at least.

The singers playfully (or angrily) splash about, shoot each other with squirt guns and finally land dead in the (unheated) water for the violent finale. Singing opera while soaking wet is an endurance test for any singer (not to mention the audience that has to witness it.) No doubt this is part of the reason the acting is so stiff but give credit to Ms. Collado for this too.

Matthew Pearce, as Don José, overcomes all this adversity and manages to give a standout vocal performance at least. Likewise, Young-Kwang Yoo, as Escamillo, treats us to his commanding baritone, although the great toreador here is forced to dress like a boy going on a summer vacation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879825/media/2019/05/tragediephoto2.jpg){{% /md %}}

<figcaption>La tragédie de Carmen, City Lyric Opera, 2019. Photo courtesy of City Lyric Opera.</figcaption>

</figure>

We, in turn, are forced to give up on this enterprise by the end, much like the small chamber orchestra, which gives way to a full orchestra (pre-recorded) playing Escamillo's famous entrance into the bullring. Or in this case, the splash zone. This is all unfortunate as The West End Theatre at The Church of St. Paul & St. Andrew is a great space for chamber opera. It's a small rotunda with superb acoustics.

_Patience & Sarah_ (1998) has been rediscovered by [Hunter Opera Theater](/scene/companies/hunter-opera-theater/) and there isn't much in it to justify a revival. Acclaimed more for its subject matter (it was billed as "the first Lesbian opera"), the libretto by Wende Persons (based on a novel by Isabel Miller) doesn't give the title characters any time to develop a relationship.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879863/media/2019/05/image1.jpg){{% /md %}}

<figcaption>Patience & Sarah, Hunter Opera Theater, 2019. Photo courtesy of Hunter Opera Theater.</figcaption>

</figure>

They fall almost immediately into each other's arms and most of Act I involves their families trying to keep them apart. Act II is the best written of the three acts – we are introduced to the character of Parson Daniel Beel who meets up with Sarah on the road.

Sarah has fled the intolerance in her small Connecticut town dressed as a boy named "Sam." Sarah and the Parson develop a deep friendship and the Parson confesses his attraction to "Sam."

> Tenor Brandon Snook is what is called a "ringer" – a pro brought in to liven up an otherwise amateur evening.

When Sarah resists his advances and reveals that she's actually a girl, she says "maybe that's why you were attracted to me." The Parson comically replies, "no, no, no…" Once the Parson is out of the story, however, and Sarah returns home, we're back in the same banal pattern of the lovers trying to get together while being forced apart.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557879686/media/2019/05/image2.jpg){{% /md %}}

<figcaption>Patience & Sarah, Hunter Opera Theater, 2019. Photo courtesy of Hunter Opera Theater.</figcaption>

</figure>

The music by Paula M. Kimper sounds like delicate raindrops falling into a slow-moving stream, meandering through the countryside in the pastoral world of the 1800's. Pleasant enough, but not dramatic enough to sustain a theatrical evening. Like the libretto, the best music is found in Act II with the duets and arias featuring the Parson and Sarah.

This production at Hunter College is, in almost every aspect, a college production. The students are obviously working very hard and their voices range from good to ear-splitting. Director and teacher Susan Gonzalez, however, seems to be training her students to avoid interacting as living, breathing human beings; most of the time they perform straight out to the audience in a very presentational style, which doesn't serve this simple love story.

Undergrad Markos Simopoulous is an exception to all this, performing at a near-professional level, not only with the dark chocolate sounds of his baritone voice but with his comic and poignant portrayal of the sexually confused Parson. Tenor Brandon Snook (as Patience's brother Edward) is what is called a "ringer" – a pro brought in to liven up an otherwise amateur evening. Mr. Snook is excellent as he evolves from an angry, homophobic despot into an understanding, loving sibling.

Hunter College also decided to bring in a professional orchestra. This production was a chance to hear the sterling Talea Ensemble, which continues to live up to its reputation at one of the premiere chamber ensembles in New York. (Conducted by David Fullmer.)