+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2015-01-25T14:06:00-05:00"
lastmod = "2015-04-11T22:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805225699/10428063_10152774633183547_6533989054763531644_n.jpg.jpg"
publishDate = "2015-01-25T14:06:00-05:00"
related_articles = ["articles/go-to-this-tapestry-songbook.md","articles/wallis-giunta-songbook-vi.md","articles/he-saidshe-said-songbook-vi.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/aaron-durand.md","scene/people/michael-mori.md","scene/people/peter-mcgillivray.md","scene/people/michael-robertbroder.md","scene/people/maeve-palmer.md"]
short_description = "Marking the end of my weekend hat-trick of stuff to see, was Tapestry’s Songbook V. It’s the fifth year of Tapestry’s New Opera 101 Program, which gives singers and pianists a chance to work on contemporary opera with some of the best in the business; the rep is chosen from within Tapestry’s impressive library of commissions."
slug = "he-saidshe-said-songbook-v"
title = "He said/she said: Songbook V"
+++

<h2>Jenna:</h2>
<p>
	Marking the end of my weekend hat-trick of stuff to see, was Tapestry's 
	<i>Songbook V</i>. It's the fifth year of Tapestry's New Opera 101 Program, which gives singers and pianists a chance to work on contemporary opera with some of the best in the business; the rep is chosen from within Tapestry's impressive library of commissions, and the artists get to work with the likes of Tapestry's Artistic Director <a href="https://tapestryopera.com/about#who-we-are" target="_blank">Michael Mori</a>, collaborative pianist <a href="http://www.music.utoronto.ca/faculty/faculty_members/faculty_n_to_z/steven_philcox.htm" target="_blank">Steven Philcox</a>, and baritone <a href="http://petermcgillivray.com/" target="_blank">Peter McGillivray</a>. <em>Songbook V</em> is a showcase of the culmination of a hectic two-day workshop with all these artists, and we got to see it in a concert format of semi-staged scenes.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805536855/10943744_10152774633088547_6124600343009489208_n.jpg"><img data-resize-src="http://lh3.googleusercontent.com/WSCqJEkrXGJQIEPt7WYB_6lohqYlkmE1bJz-ptV7cu4mds7PWzF8t215uGxGeYiwDO-KStTTQu621N0tdkoU7KhmHBk" src="http://lh3.googleusercontent.com/WSCqJEkrXGJQIEPt7WYB_6lohqYlkmE1bJz-ptV7cu4mds7PWzF8t215uGxGeYiwDO-KStTTQu621N0tdkoU7KhmHBk=s1200"></a><figcaption>Baritone Aaron Durand</figcaption></figure>
<p>
	Peter McGillivray and Steven Philcox treated us to a couple of numbers throughout the program, and the majority of the performances were given by the New Opera 101 participants. Considering both the short window of time, and the difficulty of the rep, the team of performers were exceptional. The pianists and singers drew me in so often, something I'm used to as a rare occurrence. I thought the rep was well-chosen; it was full of solos and duets that created one fascinating character after another. Among the strong program, there were a few standout performances for me.
</p>
<p>
	Baritone Aaron Durand, with Narmina Afandiyeva at the piano, sang a scene from Kevin Morse and Krista Dalby's 
	<em>Shaman's Tale</em>, in which he was the creepy, benevolently evil Shaman helping a couple struggling with infertility. Very Sweeney Todd, very Black Max, and really well sung; Narmina's playing matched the "let me tell you a story" sound that capped off the eerie factor.
</p>
<p>
	Maeve Palmer and Jordan Collalto sang Chris Thornborrow and David Yee's 
	<em>a little rain must</em> <em>fall</em>,<em> </em>a bizarrely funny comic opera in which a man accuses his girlfriend of killing all of his exes; at the end, mysteriously, he gets poisoned. The two of them, plus pianist Mélisande Sinsoulier, made a great comic team; Maeve calmly dodged Jordan's finger-pointing, and Jordan made himself look like a crazed accuser with hilariously massive vocal moments.
</p>
<p>
	With Anastasia Tchernikova at the piano, Heather Molloy and Michael Robert-Broder sang perhaps the weirdest scene I've ever seen in live theatre. 
	<em>In This World, George Is Heartbroken</em>, by Lembit Beecher and Hanna Moscovitch, started off like an unhappy married couple, she hurling insults at him ("You look like a pubic hair!"), he verbally and physically abusive back at her ("Don't talk to me like that, you c@&amp;*!"). Then we realize that she's his mother, and the abuse piles on, and the whole scene turns super weird, super quickly. (*Correction: after a chat with AD Michael Mori, he informed me I'd misheard, and that he calls her "Martha," not "mother." Big difference.)
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805612813/10329142_10152774632448547_5060201678186894996_n.jpg"><img data-resize-src="http://lh3.googleusercontent.com/AISgVc0F_fJ91dBaiujOcOm1Ec1GIl-fh3Cm-g0daIxo5lnOFZNgzuQW2DyElEoqDPPO9MjyP474qhaE8LLUzwXXTBu4" src="http://lh3.googleusercontent.com/AISgVc0F_fJ91dBaiujOcOm1Ec1GIl-fh3Cm-g0daIxo5lnOFZNgzuQW2DyElEoqDPPO9MjyP474qhaE8LLUzwXXTBu4=s1200"></a><figcaption>Pianist Steven Philcox and baritone Peter McGillivray</figcaption></figure>
<p>
	Peter McGillivray and Steven Philcox started and (nearly) finished the program with two expert performances. The first was "Ladies and Gentlemen", from Abigail Richardson and Alexis Diamond's 
	<em>The Perfect Screw</em>, in which Peter sells us a screwdriver. Cue plenty of sexual innuendo, subtle and not-so, plus Peter-als-salesman, and it was a perfect way to start the night. Later they performed Raoul's Aria from Omar Daniel and Alex Poch-Goldin's <em>The Shadow</em>. Raoul has fallen for a girl, for whom he's not good enough, but decides to pursue her anyway. It was one of those scenes where the audience can't help but root for the hero. Peter and Steven were fantastic together; it was great to hear artists like this mixed in with younger performers.
</p>
<p>
	I'm so pleased that Tapestry hosts events like this, which circulated new (and likely obscure) Canadian opera in large quantities of shorts. We got a rich look at the Canadian opera scene with 
	<em>Songbook V</em>, and I heard singers who were mostly new to me. The talent is promising, and the scenes are clever and entertaining. That's sort of all you need for good theatre, right? I say bravi to the whole team of <i>Songbook V</i>.
</p>
<p>
	***
</p>
<h2>Greg:</h2>
<p>
	Last night, (January 24th) Jenna and I were treated to a fabulous concert mounted by Tapestry, now being expertly steered by 
	<a href="https://tapestryopera.com/about#who-we-are" target="_blank">Michael Mori</a> at the helm.
</p>
<p>
	This concert series is something that Canadian opera audiences don't realize they're in desperate need of. During the introduction, Mori said something a lot of us have been thinking. Canada is extremely rich in new operatic works that get staged once, and never again see the light of day. It's is a travesty on all of our parts. This concert was a perfect eye-opener to let us in not only on the work Tapestry has been championing for years, but also to let us hear some amazing contemporary compositions which, unfortunately, if you missed their original mountings, it's going to be a long time before you heard any of it again.
</p>
<p>
	The concert was a culmination of a series of masterclasses led by Tapestry alums Peter McGillivray and Steven Philcox. Joining these two amazing performers were 11 young singers and 5 top-drawer collaborative pianists presenting solos and duets from the 15 large commissions and (wait for it) 160 smaller commissions written by 8 different composer/librettist teams over the course of the night. I gotta say, the budding director in me is chomping at the bit to be let alone in their library for a few hours (nay, DAYS).
</p>
<p>
	These young singers made me very excited for the future of Canadian contemporary opera. They sang with a wide range of colours, techniques and presented some pretty complex characters for us to devour (which is not easy to do when you only have one number taken out of context to convey their story).
</p>
<p>
	In the interest of time and Internet real estate I'd like to share my highlight reel.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805653220/1907937_10152774632058547_4518529430356817494_n.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ja6-VJqKP70nA60y43wqdy4SHAIzVbxDda_QGC5W6su9gu9cEY81vX59EUEfafb00FOLCHxN0ZPq-E9JnHokBarXUIptqA" src="http://lh3.googleusercontent.com/ja6-VJqKP70nA60y43wqdy4SHAIzVbxDda_QGC5W6su9gu9cEY81vX59EUEfafb00FOLCHxN0ZPq-E9JnHokBarXUIptqA=s1200"></a><figcaption>Soprano Maeve Palmer</figcaption></figure>
<p>
	McGillivray sang 2 numbers which not only flexed his caramelly baritone range but also let him show us his remarkable ability to share a character's complex thought process in a very short time. The first number from 
	<em>The Perfect Screw</em> was chock-full of innuendo and double-entendre and a great lively way to start the show. His second was an aria from Omar Daniels'<em> The Shadow</em>. His portrayal of Raoul, the idealistic lover who decides to change his entire personage to impress a lady who's name he doesn't even know. His low end rung with a warmth that shone through the complex orchestra deftly mastered by Philcox. <em>The Shadow</em> is one of the many Tapestry shows I was forced to miss due to being on stage myself, but after hearing this I MUST see the whole thing. *Mori take note.
</p>
<p>
	I really enjoyed Aaron Durand's portrayal of The Shaman from 
	<em>The Shaman's Tale</em>. Aaron displayed a wide variety of colours that coupled with his attractive, friendly face drew you completely into his narrative. His ability to use his whole body in his characterizations is something I find a lot of young baritones forget to employ. Durand was later joined by mezzo Heather Molloy to present the duet,<em> (What Rhymes With) Azimuth</em>. In my opinion it was the loveliest piece of the night. Composed by Ivan Barbotin with a libretto by Liza Balkan, the colours the two created with their easy, clear voices and delicate nuances was a great way to close the show.
</p>
<p>
	Molloy, probably the most versatile character singer I heard all night, has a great colour to her voice and an agility of diction that belies her years. Her other appearance was in a duet with baritone Michael Robert-Broder, entitled 
	<em>In this World George is Heartbroken</em>. With music by Lembit Beecher and libretto by Hanna Moscovitch, this is an intense duet that both singers sang with skill, beauty and dramatic intent that would be welcome on any major stage in Canada. Kudos on keeping the music beautiful while sharing what are some clearly ugly human moments.
</p>
<p>
	I would be remiss not to mention soprano Maeve Palmer. Oddly enough, she sang the roles of two killers. The circumstances of the killings varied greatly, but I saw nuances and choices in both that were scintillating and exciting, and will definitely have me keeping my eyes on this young soprano. Her duet partner Jodan Collalto, a tall, handsome baritone, was both charming and hilarious in his discovery of his new girlfirend's indiscretions. He's a young singer with a lot of voice. There's still some finessing to do over the top end, but I feel he's going to be another to keep an eye on.
</p>
<p>
	I could go on 
	<em>ad nauseum</em> about all the amazing music I heard all night. All these young singers are definitely on the right track, doing all the right things to A) solidify their place among Canada's great young singers and B) lead the charge in bringing contemporary Canadian opera into the big, broad, bright spotlight it deserves.
</p>
<p>
	Kudos to all involved! I had a splendid night and can't wait to hear all of you again!
</p>
<p class="intro">
	If you've not yet been able to catch Tapestry's work, this spring is a great time to start. 
	<em>Tap:Ex Tables Turned</em>, featuring soprano Carla Huhtanen and composer/DJ Nicole Lizée, happens March 20-21st, and Tapestry's full-length collaboration with Scottish opera, <em>M'Dea Undone</em>, opens May 26th. <a href="https://tapestryopera.com/subscription" target="_blank">Click here</a> for season details and to purchase tickets.
</p>
