+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-01-21T22:31:00-05:00"
lastmod = "2016-01-22T11:19:00-05:00"
preamble = "Greg Finney and I went to see one of Toronto's most anticipated concert events, presented by the Toronto Symphony Orchestra. Maestro Bernard Labadie returns to the TSO to conduct Mozart's *Requiem*, in an unique presentation led by director Joel Ivany, of [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/). Ivany has staged Mozart's unfinished work, giving movement and arc to the four soloists, [Lydia Teuscher](/scene/people/lydia-teuscher/), [Allyson McHardy](/scene/people/allyson-mchardy/), [Frédéric Antoun](/scene/people/frederic-antoun/), and [Philippe Sly](/scene/people/philippe-sly/), and both the Amadeus Choir and the Elmer Isler Singers. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453438860078/2016-01-22---Requiem-Square.jpg.jpg"
primary_image_credit = "l-r: Lydia Teuscher, Frédéric Antoun, Philippe Sly, and Allyson McHardy. Background: Bernard Labadie. Photo: Michael Morreale"
publishDate = "2016-01-22T11:00:00-05:00"
related_articles = ["articles/9-ways-to-fend-off-a-canadian-winter.md","articles/rehearsing-a-messiah-that-moves.md","articles/in-review-strauss-brahms-at-the-barbican.md","articles/heavy-nights-schoenberg-brahms-the-lpo-and-goerne.md","articles/magic-theatre-jurowski-and-oaes-resurrection-symphony.md","articles/requiem-on-the-south-bank.md","articles/the-tso-does-danny-elfmans-music-from-the-films-of-tim-burton.md","articles/review-the-personal-side-of-bachs-b-minor-mass.md","articles/in-review-seven-deadly-sins-at-tso.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/lydia-teuscher.md","scene/people/allyson-mchardy.md","scene/people/frdric-antoun.md","scene/people/philippe-sly.md","scene/people/joel-ivany.md"]
short_description = "Greg Finney and I went to see one of Toronto&#039;s most anticipated concert events, presented by the Toronto Symphony Orchestra. Maestro Bernard Labadie returns to the TSO to conduct Mozart&#039;s Requiem, in an unique presentation led by director Joel Ivany, of Against the Grain Theatre."
slug = "he-saidshe-said-mozarts-requiem-at-tso"
title = "He said/she said: Mozart&#039;s Requiem at TSO"
+++

**Greg Finney**: The Toronto Symphony Orchestra gave a wonderful show last night. They've teamed up with the hottest director in classical music right now, my friend and colleague Joel Ivany, to present a semi-staged performance of Mozart's *Requiem*. The innovator of staging oratorio with his *Messiah* in 2013 and this past holiday season, Ivany made sure this *Requiem* was not your usual lamentation over the loss of a life, but the approach seemed to be more of a celebration of the time spent with a loved one you've lost. There was a peace and a serenity to the whole thing. It gave some of the more fiery movements (here's looking at you, "Dies irae") less of a feel of condemnation, and more of an urgency and zeal.

**Jenna**: Presenting oratorio as a staged, fully dramatic work is becoming the standard for major orchestras; Peter Sellars' *St. Matthew Passion* with the Berlin Philharmonic set a precedent of sorts, not just for how to treat this repertoire, but how to use a concert hall-type space to create different boundaries between the audience and performers. Ivany is a champion of connecting with his audience, and treats Mozart's *Requiem* less spiritually than the text may suggest, instead focusing on the human experience of grieving. He asks in his director's notes, "Who is playing the requiem for the murdered and missing Aboriginal women in Canada? Who is playing the requiem for the Syrian refugees fleeing heir homes and leaving their families?"

**Greg**: In a brilliant bit of programming, they used the second movement of Mozart's Clarinet Quintet K.581 as an overture. In single file, the chorus and orchestra walked on to the stage, leaving blank white note cards on a pine dais. The quintet was stunning and clarinettist Joaquin Valdepeñas played with a warm, clean sound that danced over the quicker passages with a cleanliness and precision that we all crave when listening to classical era small ensembles. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453477913411/2016-01-22---Requiem-5.jpg.jpg)
<figcaption>Jonathan Crow, Mark Skazinetsky, Joaquin Valdepeñas, Joseph Johnson, and Teng Li. Photo by Malcolm Cook.</figcaption>
</figure>

**Greg**: Conducted by a scoreless Bernard Labadie, the TSO played the hell out of the *Requiem*. It sounded like I always hear Mozart in my mind: passionate, driven, and an understanding that andante means "walking pace" not "overly reverent processional", leaving space for any largo passages to actually mean something. The orchestra's responsiveness to Labadie's baton was inspiring. Bravissimi tutti!

**Jenna**: The four soloists each had a home base of sorts, grounded by a chair and a pool of light. Along with white index cards from every person onstage, these items stood for the people that were lost. The soloists interacted with their respective lights, mingled with the chorus and orchestra, and the quartet banded together as if offering emotional support to the one who needed it most.

**Greg**: Soprano Lydia Teuscher gave a shining performance, even if I felt her a little shy in the first movement. She settled in and delivered a solid interpretation with some delicious musical choices. Mezzo-Soprano Allyson McHardy, sang with a delicate touch which really helped accentuate Mozart's keen use of suspensions. It was great to hear her in concert again, it's been a while for me. Philippe Sly's dark, thick, baritone was a solid anchor in the small ensemble singing, and had a lovely colour against the TSO during his solo passages. The standout for me had to be tenor Frédéric Antoun. He had a bright, focused yet easy tone that just flew into the hall. He sang a subtle, nuanced performance and his solid groundedness made a good foil for Sly's more energetic physicality.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453439025144/2016-01-22---Requiem-2.jpg.jpg)
<figcaption>l-r: Fréderic Antoun, tenor, maestro Bernard Labadie, Philippe Sly, bass-baritone. Photo by Malcolm Cook.</figcaption>
</figure>

**Jenna**: *Requiem* doesn't come with an operatic narrative, and Ivany didn't impose one upon it. The chorus was almost the primary "character", with the most to sing, and their imposing Greek chorus-like gestures (another nod to Peter Sellars). The soloists all had what felt like honest, earthy voices, and they stood out as individuals among the beautifully unform sound in the chorus.

**Greg**: Blessed and cursed to have the bulk of the singing, the (appropriately named) Amadeus Choir and the Elmer Iseler singers, under the direction of Lydia Adams, sounded great. Having done #AtGMessiah, I know how difficult memorizing a work of this magnitude is, and kudos to you all.

**Jenna**: Now, a small disclaimer: when Ivany workshopped his *Requiem* last year, with a sparse number of voices and a much smaller space, I joined them to be the piano-as-orchestra. It means I came to the final product at Roy Thomson Hall with some insider information about how Ivany was approaching Mozart's work. The soloists carried with them their own personal stories of grief; I wouldn't say that any one of these stories was particularly "finished" by the final bars, but there was a clear theme of finding solace in other people, rather than grieving alone. Ivany made great use of Mozart's quartet writing for the soloists in order to show this, grouping the four singers closely together to align with their beautiful blend.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453439057017/2016-01-22---Requiem-3.jpg.jpg)
<figcaption>Lydia Teuscher, soprano, Allyson McHardy, mezzo-soprano, Fréderic Antoun, tenor, and Philippe Sly, bass-baritone. Photo by Malcolm Cook.</figcaption>
</figure>

**Greg**: I did feel like the hall was a little unkind to the chorus. Being behind the orchestra and fairly sparsely spread across the stage, I felt as though their diction got a little gobbled-up in the expanse of the hall. However, their dynamic work was on point! Their were some stunning diminuendi, beautiful sustained piano passages, and the ensemble was glorious at full voice.

**Jenna**: Under Bernard Labadie, the Toronto Symphony Orchestra sounded spectacular. The tempos were brisk and full of fire, and Labadie conducted the work with a huge amount of spirit and inspiration. The music, too, was notably human, almost imprecise at times, but with impulse and abandon.

**Greg**: Overall, it was a beautiful piece. I wonder if it may be a little more powerful in a less conventional space. I felt that the intimacy of the soloists' journeys through the piece would have been able to shine more. I felt the hall forced a more 'safe' presentation of the overall vision of the piece, but this could just be that exceptional use of an unexpected venue is what I love best about Ivany's body of work.

Dat "Benedictus" tho...

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453439007140/2016-01-22---Requiem1.jpg.jpg)
<figcaption>The Toronto Symphony Orchestra, Elmer Isler Singers, Amadeus Choir, maestro Bernard Labadie and soloists. Photo by Malcolm Cook.</figcaption>
</figure>

**Jenna**: It was an intimate take on Mozart's large work, and although our seats at Roy Thomson Hall were fantastic, I felt like I was missing a lot by being too far away to really see the soloists' faces. Their arcs are subtle, and part of a larger musical machine along with the TSO, the chorus, and the space itself. Ivany's work has notably been shown in smaller, surprising venues where the audience watches from a more conversational distance. With a piece like Mozart's *Requiem*, finding the balance between the large scale of the score and the close connection Ivany seeks between stage and audience is an ongoing challenge. I hope he and other directors get a chance to use iconic spaces like Roy Thomson Hall in this innovative way, and to explore more that tricky balance.

>Mozart's *Requiem* continues for two more performances, January 22 and 23 at Roy Thomson Hall. For details and ticket information, follow the box office links below.
